/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.location;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.location.GroupLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.location.TemplateLocation;
import eu.thesimplecloud.api.service.ICloudService;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eB/\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010B=\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J \u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Leu/thesimplecloud/api/location/ServiceLocation;", "Leu/thesimplecloud/api/location/SimpleLocation;", "service", "Leu/thesimplecloud/api/service/ICloudService;", "worldName", "", "x", "", "y", "z", "yaw", "", "pitch", "(Leu/thesimplecloud/api/service/ICloudService;Ljava/lang/String;DDDFF)V", "(Leu/thesimplecloud/api/service/ICloudService;Ljava/lang/String;DDD)V", "serviceName", "(Ljava/lang/String;Ljava/lang/String;DDD)V", "(Ljava/lang/String;Ljava/lang/String;DDDFF)V", "groupName", "getGroupName", "()Ljava/lang/String;", "getServiceName", "add", "equals", "", "other", "", "getService", "hashCode", "", "setServiceName", "setWorldName", "toGroupLocation", "Leu/thesimplecloud/api/location/GroupLocation;", "toTemplateLocation", "Leu/thesimplecloud/api/location/TemplateLocation;", "simplecloud-api"})
public final class ServiceLocation
extends SimpleLocation {
    @NotNull
    private final String groupName;
    @NotNull
    private final String serviceName;

    @NotNull
    public final String getGroupName() {
        return this.groupName;
    }

    @NotNull
    public final GroupLocation toGroupLocation() {
        return new GroupLocation(this.groupName, this.getWorldName(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @NotNull
    public final TemplateLocation toTemplateLocation() {
        ICloudService iCloudService = this.getService();
        if (iCloudService == null) {
            throw (Throwable)new IllegalStateException("Service " + this.serviceName + " cannot be found");
        }
        ICloudService service = iCloudService;
        return new TemplateLocation(service.getTemplateName(), this.getWorldName(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @Nullable
    public final ICloudService getService() {
        return CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(this.serviceName);
    }

    @Override
    @NotNull
    public ServiceLocation add(double x, double y, double z) {
        return new ServiceLocation(this.serviceName, this.getWorldName(), this.getX() + x, this.getY() + y, this.getZ() + z, this.getYaw(), this.getPitch());
    }

    @Override
    @NotNull
    public ServiceLocation setWorldName(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        return new ServiceLocation(this.serviceName, worldName, this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @NotNull
    public final ServiceLocation setServiceName(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return new ServiceLocation(serviceName, this.getWorldName(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServiceLocation)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.serviceName, (Object)((ServiceLocation)other).serviceName) ^ true);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        return result;
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    public ServiceLocation(@NotNull String serviceName, @NotNull String worldName, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        super(worldName, x, y, z, yaw, pitch);
        this.serviceName = serviceName;
        this.groupName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)this.serviceName, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    public ServiceLocation(@NotNull ICloudService service, @NotNull String worldName, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        this(service.getName(), worldName, x, y, z, yaw, pitch);
    }

    public ServiceLocation(@NotNull ICloudService service, @NotNull String worldName, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        this(service, worldName, x, y, z, 0.0f, 0.0f);
    }

    public ServiceLocation(@NotNull String serviceName, @NotNull String worldName, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        this(serviceName, worldName, x, y, z, 0.0f, 0.0f);
    }
}

