/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.message;

import com.google.gson.Gson;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.message.IMessageChannel;
import eu.thesimplecloud.api.message.IMessageChannelManager;
import eu.thesimplecloud.api.message.IMessageListener;
import eu.thesimplecloud.api.message.Message;
import eu.thesimplecloud.api.message.MessageChannelManager;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.jsonlib.GsonCreator;
import eu.thesimplecloud.jsonlib.JsonLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001eB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J#\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Leu/thesimplecloud/api/message/MessageChannel;", "T", "Leu/thesimplecloud/api/message/IMessageChannel;", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "name", "", "clazz", "Ljava/lang/Class;", "(Leu/thesimplecloud/api/external/ICloudModule;Ljava/lang/String;Ljava/lang/Class;)V", "getCloudModule", "()Leu/thesimplecloud/api/external/ICloudModule;", "listeners", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Leu/thesimplecloud/api/message/IMessageListener;", "getMessageClass", "getName", "notifyListeners", "", "message", "Leu/thesimplecloud/api/message/Message;", "registerListener", "messageListener", "sendMessage", "msg", "receivers", "", "Leu/thesimplecloud/api/network/component/INetworkComponent;", "(Ljava/lang/Object;Ljava/util/List;)V", "unregisterListener", "Companion", "simplecloud-api"})
public final class MessageChannel<T>
implements IMessageChannel<T> {
    private final CopyOnWriteArraySet<IMessageListener<T>> listeners;
    @NotNull
    private final ICloudModule cloudModule;
    private final String name;
    private final Class<T> clazz;
    private static final Gson GSON;
    @NotNull
    public static final Companion Companion;

    @Override
    public void registerListener(@NotNull IMessageListener<T> messageListener) {
        Intrinsics.checkNotNullParameter(messageListener, (String)"messageListener");
        this.listeners.add(messageListener);
    }

    @Override
    public void unregisterListener(@NotNull IMessageListener<T> messageListener) {
        Intrinsics.checkNotNullParameter(messageListener, (String)"messageListener");
        this.listeners.remove(messageListener);
    }

    public final void notifyListeners(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (Intrinsics.areEqual((Object)message.getClassName(), (Object)this.clazz.getName()) ^ true) {
            throw (Throwable)new IllegalArgumentException("Invalid message class on message channel " + message.getChannel() + ": Expected " + this.clazz.getName() + " but was " + message.getClassName() + ' ');
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonString$default(JsonLib.Companion, message.getMessageString(), null, 2, null);
        T msg = jsonLib.getObject(this.clazz);
        INetworkComponent iNetworkComponent = message.getSenderReference().getNetworkComponent();
        if (iNetworkComponent == null) {
            throw (Throwable)new IllegalArgumentException("Connected process of " + message.getSenderReference().getName() + " is null");
        }
        INetworkComponent networkComponent = iNetworkComponent;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IMessageListener it = (IMessageListener)element$iv;
            boolean bl = false;
            it.messageReceived(msg, networkComponent);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Class<T> getMessageClass() {
        return this.clazz;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendMessage(T msg, @NotNull List<? extends INetworkComponent> receivers) {
        Collection<NetworkComponentReference> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(receivers, (String)"receivers");
        INetworkComponent thisComponent = CloudAPI.Companion.getInstance().getThisSidesNetworkComponent();
        String messageString = GSON.toJson(msg);
        String string = this.getName();
        String string2 = this.clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.name");
        String string3 = messageString;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"messageString");
        Iterable iterable = receivers;
        NetworkComponentReference networkComponentReference = thisComponent.toNetworkComponentReference();
        String string4 = string3;
        String string5 = string2;
        String string6 = string;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            INetworkComponent iNetworkComponent = (INetworkComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            NetworkComponentReference networkComponentReference2 = it.toNetworkComponentReference();
            collection.add(networkComponentReference2);
        }
        Collection<NetworkComponentReference> collection2 = collection = (List)destination$iv$iv;
        NetworkComponentReference networkComponentReference3 = networkComponentReference;
        String string7 = string4;
        String string8 = string5;
        String string9 = string6;
        Message message = new Message(string9, string8, string7, networkComponentReference3, (List<NetworkComponentReference>)collection2);
        IMessageChannelManager iMessageChannelManager = CloudAPI.Companion.getInstance().getMessageChannelManager();
        if (iMessageChannelManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.message.MessageChannelManager");
        }
        ((MessageChannelManager)iMessageChannelManager).sendMessage(message);
    }

    @NotNull
    public final ICloudModule getCloudModule() {
        return this.cloudModule;
    }

    public MessageChannel(@NotNull ICloudModule cloudModule, @NotNull String name, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.cloudModule = cloudModule;
        this.name = name;
        this.clazz = clazz;
        this.listeners = new CopyOnWriteArraySet();
    }

    static {
        Companion = new Companion(null);
        GSON = new GsonCreator().create();
    }

    @Override
    public void sendMessage(T msg, @NotNull INetworkComponent receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        IMessageChannel.DefaultImpls.sendMessage(this, msg, receiver);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Leu/thesimplecloud/api/message/MessageChannel$Companion;", "", "()V", "GSON", "Lcom/google/gson/Gson;", "simplecloud-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

