/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.message;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.message.IMessageChannel;
import eu.thesimplecloud.api.message.IMessageChannelManager;
import eu.thesimplecloud.api.message.Message;
import eu.thesimplecloud.api.message.MessageChannel;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.api.network.packets.message.PacketIOChannelMessage;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.ICommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.server.INettyServer;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R^\u0010\u0003\u001aR\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*(\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Leu/thesimplecloud/api/message/MessageChannelManager;", "Leu/thesimplecloud/api/message/IMessageChannelManager;", "()V", "channels", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Leu/thesimplecloud/api/message/MessageChannel;", "getMessageChannelByName", "Leu/thesimplecloud/api/message/IMessageChannel;", "T", "name", "incomingMessage", "", "message", "Leu/thesimplecloud/api/message/Message;", "registerMessageChannel", "cloudModule", "Leu/thesimplecloud/api/external/ICloudModule;", "clazz", "Ljava/lang/Class;", "sendMessage", "unregisterMessageChannel", "simplecloud-api"})
public final class MessageChannelManager
implements IMessageChannelManager {
    private final ConcurrentMap<String, MessageChannel<?>> channels = Maps.newConcurrentMap();

    @Override
    @NotNull
    public <T> IMessageChannel<T> registerMessageChannel(@NotNull ICloudModule cloudModule, @NotNull String name, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.channels.containsKey(name)) {
            throw (Throwable)new IllegalArgumentException("Channel is already registered");
        }
        MessageChannel<T> messageChannel = new MessageChannel<T>(cloudModule, name, clazz);
        ConcurrentMap<String, MessageChannel<?>> concurrentMap = this.channels;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"this.channels");
        ((Map)concurrentMap).put(name, messageChannel);
        return messageChannel;
    }

    @Override
    @Nullable
    public <T> IMessageChannel<T> getMessageChannelByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (IMessageChannel)this.channels.get(name);
    }

    @Override
    public void unregisterMessageChannel(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.channels.remove(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterMessageChannel(@NotNull ICloudModule cloudModule) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cloudModule, (String)"cloudModule");
        Iterable $this$filter$iv = this.channels.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((MessageChannel)it.getValue()).getCloudModule(), (Object)cloudModule)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            collection.add(string);
        }
        List messageChannelNamesByModule = (List)destination$iv$iv;
        Iterable $this$forEach$iv = messageChannelNamesByModule;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String string = it2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
            this.unregisterMessageChannel(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PacketIOChannelMessage packetToSend = new PacketIOChannelMessage(message);
        if (CloudAPI.Companion.getInstance().isManager()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            ICommunicationBootstrap iCommunicationBootstrap = CloudAPI.Companion.getInstance().getThisSidesCommunicationBootstrap();
            if (iCommunicationBootstrap == null) {
                throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.server.INettyServer<*>");
            }
            INettyServer server = (INettyServer)iCommunicationBootstrap;
            Iterable $this$filter$iv = message.getReceivers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NetworkComponentReference it = (NetworkComponentReference)element$iv$iv;
                boolean bl = false;
                if (!(it.getComponentType() != NetworkComponentType.MANAGER)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                INetworkComponent iNetworkComponent;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                NetworkComponentReference it = (NetworkComponentReference)element$iv$iv;
                boolean bl2 = false;
                if (it.getNetworkComponent() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                INetworkComponent it$iv$iv = iNetworkComponent;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allNotManagerReceivers = (List)destination$iv$iv;
            Iterable $this$forEach$iv = allNotManagerReceivers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                IConnectedClient client;
                INetworkComponent it = (INetworkComponent)element$iv;
                boolean bl = false;
                IConnectedClient iConnectedClient = client = server.getClientManager().getClientByClientValue(it);
                if (iConnectedClient == null) continue;
                IPacketSender.DefaultImpls.sendUnitQuery$default(iConnectedClient, packetToSend, 0L, 2, null);
            }
        } else {
            ICommunicationBootstrap iCommunicationBootstrap = CloudAPI.Companion.getInstance().getThisSidesCommunicationBootstrap();
            if (iCommunicationBootstrap == null) {
                throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.INettyClient");
            }
            INettyClient client = (INettyClient)iCommunicationBootstrap;
            IPacketSender.DefaultImpls.sendUnitQuery$default(client.getConnection(), packetToSend, 0L, 2, null);
        }
    }

    public final void incomingMessage(@NotNull Message message) {
        block2: {
            MessageChannel channel2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                channel2 = (MessageChannel)this.channels.get(message.getChannel());
                if (!CloudAPI.Companion.getInstance().isManager()) break block1;
                this.sendMessage(message);
                if (!message.getReceivers().contains(NetworkComponentReference.Companion.getMANAGER_COMPONENT_REFERENCE())) break block2;
                MessageChannel messageChannel = channel2;
                if (messageChannel != null) {
                    messageChannel.notifyListeners(message);
                }
                break block2;
            }
            MessageChannel messageChannel = channel2;
            if (messageChannel == null) break block2;
            messageChannel.notifyListeners(message);
        }
    }
}

