/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.AbstractCacheList;
import eu.thesimplecloud.api.cachelist.ICacheObjectUpdater;
import eu.thesimplecloud.api.event.player.CloudPlayerRegisteredEvent;
import eu.thesimplecloud.api.event.player.CloudPlayerServerConnectEvent;
import eu.thesimplecloud.api.event.player.CloudPlayerServerConnectedEvent;
import eu.thesimplecloud.api.event.player.CloudPlayerUnregisteredEvent;
import eu.thesimplecloud.api.event.player.CloudPlayerUpdatedEvent;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.network.packets.sync.cachelist.PacketIOUpdateCacheObject;
import eu.thesimplecloud.api.player.AbstractCloudPlayerManager;
import eu.thesimplecloud.api.player.CloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/api/player/AbstractCloudPlayerManager;", "Leu/thesimplecloud/api/cachelist/AbstractCacheList;", "Leu/thesimplecloud/api/player/ICloudPlayer;", "Leu/thesimplecloud/api/player/ICloudPlayerManager;", "()V", "updater", "eu/thesimplecloud/api/player/AbstractCloudPlayerManager$updater$1", "Leu/thesimplecloud/api/player/AbstractCloudPlayerManager$updater$1;", "delete", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "value", "fromPacket", "", "getUpdater", "Leu/thesimplecloud/api/cachelist/ICacheObjectUpdater;", "promiseOfNullablePlayer", "cloudPlayer", "simplecloud-api"})
public abstract class AbstractCloudPlayerManager
extends AbstractCacheList<ICloudPlayer>
implements ICloudPlayerManager {
    private final updater.1 updater = new ICacheObjectUpdater<ICloudPlayer>(this){
        final /* synthetic */ AbstractCloudPlayerManager this$0;

        @NotNull
        public String getIdentificationName() {
            return "player-cache";
        }

        @Nullable
        public ICloudPlayer getCachedObjectByUpdateValue(@NotNull ICloudPlayer value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.this$0.getCachedCloudPlayer(value.getName());
        }

        @NotNull
        public List<IEvent> determineEventsToCall(@NotNull ICloudPlayer updateValue, @Nullable ICloudPlayer cachedValue) {
            Intrinsics.checkNotNullParameter((Object)updateValue, (String)"updateValue");
            ArrayList<IEvent> events = new ArrayList<IEvent>();
            ICloudPlayer iCloudPlayer = cachedValue;
            if (iCloudPlayer == null) {
                iCloudPlayer = updateValue;
            }
            ICloudPlayer playerToUse = iCloudPlayer;
            events.add(new CloudPlayerUpdatedEvent(playerToUse));
            if (cachedValue == null) {
                events.add(new CloudPlayerRegisteredEvent(playerToUse));
                return events;
            }
            if (updateValue.getConnectedServerName() != null && Intrinsics.areEqual((Object)updateValue.getConnectedServerName(), (Object)cachedValue.getConnectedServerName()) ^ true) {
                ICloudService oldServer = cachedValue.getConnectedServer();
                ICloudService iCloudService = updateValue.getConnectedServer();
                Intrinsics.checkNotNull((Object)iCloudService);
                events.add(new CloudPlayerServerConnectEvent(playerToUse, oldServer, iCloudService));
            }
            if (cachedValue.getServerConnectState() == PlayerServerConnectState.CONNECTING && updateValue.getServerConnectState() == PlayerServerConnectState.CONNECTED) {
                ICloudService iCloudService = updateValue.getConnectedServer();
                Intrinsics.checkNotNull((Object)iCloudService);
                events.add(new CloudPlayerServerConnectedEvent(playerToUse, iCloudService));
            }
            return events;
        }

        public void mergeUpdateValue(@NotNull ICloudPlayer updateValue, @NotNull ICloudPlayer cachedValue) {
            Intrinsics.checkNotNullParameter((Object)updateValue, (String)"updateValue");
            Intrinsics.checkNotNullParameter((Object)cachedValue, (String)"cachedValue");
            CloudPlayer cfr_ignored_0 = (CloudPlayer)cachedValue;
            ((CloudPlayer)cachedValue).setConnectedProxyName(updateValue.getConnectedProxyName());
            ((CloudPlayer)cachedValue).setConnectedServerName(updateValue.getConnectedServerName());
            HashMap<String, IProperty<?>> hashMap = updateValue.getMapWithNewestProperties(((CloudPlayer)cachedValue).getPropertyMap());
            if (hashMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, eu.thesimplecloud.api.property.Property<*>>");
            }
            ((CloudPlayer)cachedValue).setPropertyMap((Map)new HashMap<K, V>(TypeIntrinsics.asMutableMap(hashMap)));
            ((CloudPlayer)cachedValue).setServerConnectState(updateValue.getServerConnectState());
            cachedValue.setDisplayName(updateValue.getDisplayName());
        }

        public void addNewValue(@NotNull ICloudPlayer value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            AbstractCloudPlayerManager.access$getValues$p(this.this$0).add(value);
        }
        {
            this.this$0 = this$0;
        }

        @NotNull
        public ICommunicationPromise<Unit> sendUpdatesToOtherComponents(@NotNull ICloudPlayer value, @NotNull PacketIOUpdateCacheObject.Action action) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            return ICacheObjectUpdater.DefaultImpls.sendUpdatesToOtherComponents(this, value, action);
        }
    };

    @Override
    @NotNull
    public ICacheObjectUpdater<ICloudPlayer> getUpdater() {
        return this.updater;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> delete(@NotNull ICloudPlayer value, boolean fromPacket) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ICloudPlayer iCloudPlayer = this.updater.getCachedObjectByUpdateValue(value);
        if (iCloudPlayer == null) {
            iCloudPlayer = value;
        }
        ICloudPlayer playerToUse = iCloudPlayer;
        return super.delete(value, fromPacket).addResultListener((Function1<Unit, Unit>)((Function1)new Function1<Unit, Unit>(playerToUse){
            final /* synthetic */ ICloudPlayer $playerToUse;

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new CloudPlayerUnregisteredEvent(this.$playerToUse), false, 2, null);
            }
            {
                this.$playerToUse = iCloudPlayer;
                super(1);
            }
        }));
    }

    @NotNull
    public final ICommunicationPromise<ICloudPlayer> promiseOfNullablePlayer(@Nullable ICloudPlayer cloudPlayer) {
        return CommunicationPromise.Companion.ofNullable(cloudPlayer, new NoSuchElementException("CloudPlayer not found."));
    }

    public AbstractCloudPlayerManager() {
        super(false);
    }

    @Override
    @Nullable
    public ICloudPlayer getCachedCloudPlayer(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return ICloudPlayerManager.DefaultImpls.getCachedCloudPlayer((ICloudPlayerManager)this, uniqueId);
    }

    @Override
    @Nullable
    public ICloudPlayer getCachedCloudPlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ICloudPlayerManager.DefaultImpls.getCachedCloudPlayer((ICloudPlayerManager)this, name);
    }

    @Override
    public void setUpdates(@NotNull ICloudPlayer cloudPlayer, boolean update, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        ICloudPlayerManager.DefaultImpls.setUpdates(this, cloudPlayer, update, serviceName);
    }

    @Override
    @NotNull
    public ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByNames(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return ICloudPlayerManager.DefaultImpls.getOfflineCloudPlayersByNames(this, names);
    }

    @Override
    @NotNull
    public ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByUniqueIds(@NotNull List<UUID> uniqueIds) {
        Intrinsics.checkNotNullParameter(uniqueIds, (String)"uniqueIds");
        return ICloudPlayerManager.DefaultImpls.getOfflineCloudPlayersByUniqueIds(this, uniqueIds);
    }

    @Override
    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByNames(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return ICloudPlayerManager.DefaultImpls.getCloudPlayersByNames(this, names);
    }

    @Override
    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByUniqueIds(@NotNull List<UUID> uniqueIds) {
        Intrinsics.checkNotNullParameter(uniqueIds, (String)"uniqueIds");
        return ICloudPlayerManager.DefaultImpls.getCloudPlayersByUniqueIds(this, uniqueIds);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getValues$p(AbstractCloudPlayerManager $this) {
        return $this.getValues();
    }
}

