/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player;

import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.OfflineCloudPlayer;
import eu.thesimplecloud.api.player.PlayerMessageQueue;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.api.player.connection.IPlayerConnection;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.json.PacketExclude;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.jsonlib.JsonLibExclude;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\u0016H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0'2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010+\u001a\u00020\u001c2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0006\u0010,\u001a\u00020\u001cJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010.\u001a\u00020\u0004H\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Leu/thesimplecloud/api/player/CloudPlayer;", "Leu/thesimplecloud/api/player/OfflineCloudPlayer;", "Leu/thesimplecloud/api/player/ICloudPlayer;", "name", "", "uniqueId", "Ljava/util/UUID;", "firstLogin", "", "lastLogin", "onlineTime", "connectedProxyName", "connectedServerName", "playerConnection", "Leu/thesimplecloud/api/player/connection/DefaultPlayerConnection;", "propertyMap", "", "Leu/thesimplecloud/api/property/Property;", "(Ljava/lang/String;Ljava/util/UUID;JJJLjava/lang/String;Ljava/lang/String;Leu/thesimplecloud/api/player/connection/DefaultPlayerConnection;Ljava/util/Map;)V", "connectState", "Leu/thesimplecloud/api/player/PlayerServerConnectState;", "online", "", "playerMessageQueue", "Leu/thesimplecloud/api/player/PlayerMessageQueue;", "updatesEnabled", "clone", "disableUpdates", "", "enableUpdates", "getConnectedProxyName", "getConnectedServerName", "getOnlineTime", "getPlayerConnection", "Leu/thesimplecloud/api/player/connection/IPlayerConnection;", "getServerConnectState", "isOnline", "isUpdatesEnabled", "sendMessage", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "setConnectedProxyName", "setConnectedServerName", "setOffline", "setServerConnectState", "toString", "simplecloud-api"})
public final class CloudPlayer
extends OfflineCloudPlayer
implements ICloudPlayer {
    private volatile PlayerServerConnectState connectState;
    private volatile boolean online;
    @PacketExclude
    private volatile boolean updatesEnabled;
    @PacketExclude
    @JsonLibExclude
    private PlayerMessageQueue playerMessageQueue;
    private String connectedProxyName;
    private String connectedServerName;

    @Override
    @NotNull
    public IPlayerConnection getPlayerConnection() {
        return this.getLastPlayerConnection();
    }

    @Override
    @NotNull
    public PlayerServerConnectState getServerConnectState() {
        return this.connectState;
    }

    public final void setServerConnectState(@NotNull PlayerServerConnectState connectState) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectState), (String)"connectState");
        this.connectState = connectState;
    }

    @Override
    @NotNull
    public synchronized ICommunicationPromise<Unit> sendMessage(@NotNull CloudText cloudText) {
        Intrinsics.checkNotNullParameter((Object)cloudText, (String)"cloudText");
        if (this.playerMessageQueue == null) {
            this.playerMessageQueue = new PlayerMessageQueue(this);
        }
        PlayerMessageQueue playerMessageQueue = this.playerMessageQueue;
        Intrinsics.checkNotNull((Object)playerMessageQueue);
        return playerMessageQueue.queueMessage(cloudText);
    }

    @Override
    @NotNull
    public String getConnectedProxyName() {
        return this.connectedProxyName;
    }

    @Override
    @Nullable
    public String getConnectedServerName() {
        return this.connectedServerName;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    @NotNull
    public ICloudPlayer clone() {
        return new CloudPlayer(this.getName(), this.getUniqueId(), this.getFirstLogin(), this.getLastLogin(), this.getOnlineTime(), this.connectedProxyName, this.connectedServerName, (DefaultPlayerConnection)this.getLastPlayerConnection(), this.getPropertyMap());
    }

    @Override
    public void enableUpdates() {
        ICloudPlayer.DefaultImpls.enableUpdates(this);
        this.updatesEnabled = true;
    }

    @Override
    public void disableUpdates() {
        ICloudPlayer.DefaultImpls.disableUpdates(this);
        this.updatesEnabled = false;
    }

    @Override
    public boolean isUpdatesEnabled() {
        return this.updatesEnabled;
    }

    public final synchronized void setOffline() {
        this.online = false;
    }

    public final void setConnectedProxyName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.connectedProxyName = name;
    }

    public final void setConnectedServerName(@Nullable String name) {
        this.connectedServerName = name;
    }

    @Override
    public long getOnlineTime() {
        return System.currentTimeMillis() - this.getLastLogin() + super.getOnlineTime();
    }

    @NotNull
    public String toString() {
        return JsonLib.Companion.fromObject(this).getAsJsonString();
    }

    public CloudPlayer(@NotNull String name, @NotNull UUID uniqueId, long firstLogin, long lastLogin, long onlineTime, @NotNull String connectedProxyName, @Nullable String connectedServerName, @NotNull DefaultPlayerConnection playerConnection, @NotNull Map<String, Property<?>> propertyMap) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)connectedProxyName, (String)"connectedProxyName");
        Intrinsics.checkNotNullParameter((Object)playerConnection, (String)"playerConnection");
        Intrinsics.checkNotNullParameter(propertyMap, (String)"propertyMap");
        super(name, uniqueId, firstLogin, lastLogin, onlineTime, playerConnection, propertyMap);
        this.connectedProxyName = connectedProxyName;
        this.connectedServerName = connectedServerName;
        this.connectState = PlayerServerConnectState.CONNECTING;
        this.online = true;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return ICloudPlayer.DefaultImpls.sendMessage(this, message);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> update() {
        return ICloudPlayer.DefaultImpls.update(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connect(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        return ICloudPlayer.DefaultImpls.connect(this, cloudService);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kick(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return ICloudPlayer.DefaultImpls.kick(this, message);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kick() {
        return ICloudPlayer.DefaultImpls.kick(this);
    }

    @Override
    public void sendTitle(@NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
        ICloudPlayer.DefaultImpls.sendTitle(this, title, subTitle, fadeIn, stay, fadeOut);
    }

    @Override
    public void sendActionBar(@NotNull String actionbar) {
        Intrinsics.checkNotNullParameter((Object)actionbar, (String)"actionbar");
        ICloudPlayer.DefaultImpls.sendActionBar(this, actionbar);
    }

    @Override
    public void sendTablist(@NotNull String[] headers, @NotNull String[] footers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)footers, (String)"footers");
        ICloudPlayer.DefaultImpls.sendTablist(this, headers, footers);
    }

    @Override
    @Nullable
    public ICloudService getConnectedProxy() {
        return ICloudPlayer.DefaultImpls.getConnectedProxy(this);
    }

    @Override
    @Nullable
    public ICloudService getConnectedServer() {
        return ICloudPlayer.DefaultImpls.getConnectedServer(this);
    }

    @Override
    public void forceCommandExecution(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        ICloudPlayer.DefaultImpls.forceCommandExecution(this, command);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return ICloudPlayer.DefaultImpls.teleport((ICloudPlayer)this, location);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleport(@NotNull ServiceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return ICloudPlayer.DefaultImpls.teleport((ICloudPlayer)this, location);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ICloudPlayer.DefaultImpls.hasPermission(this, permission);
    }

    @Override
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocation() {
        return ICloudPlayer.DefaultImpls.getLocation(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendToLobby() {
        return ICloudPlayer.DefaultImpls.sendToLobby(this);
    }

    @Override
    @NotNull
    public SimpleCloudPlayer toSimplePlayer() {
        return ICloudPlayer.DefaultImpls.toSimplePlayer(this);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendProperty(@NotNull String property, String ... placeholderValues) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)placeholderValues, (String)"placeholderValues");
        return ICloudPlayer.DefaultImpls.sendProperty(this, property, placeholderValues);
    }

    @Override
    public boolean hasPermissionSync(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ICloudPlayer.DefaultImpls.hasPermissionSync(this, permission);
    }
}

