/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player.connection;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.player.CloudPlayerServerConnectedEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "", "playerUniqueId", "Ljava/util/UUID;", "alreadyConnected", "", "(Ljava/util/UUID;Z)V", "getAlreadyConnected", "()Z", "getPlayerUniqueId", "()Ljava/util/UUID;", "createConnectedPromise", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/event/player/CloudPlayerServerConnectedEvent;", "getCloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "simplecloud-api"})
public final class ConnectionResponse {
    @NotNull
    private final UUID playerUniqueId;
    private final boolean alreadyConnected;

    @NotNull
    public final ICloudPlayer getCloudPlayer() {
        ICloudPlayer iCloudPlayer = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(this.playerUniqueId);
        if (iCloudPlayer == null) {
            throw (Throwable)new IllegalStateException("Unable to find player by uuid " + this.playerUniqueId);
        }
        return iCloudPlayer;
    }

    @NotNull
    public final ICommunicationPromise<CloudPlayerServerConnectedEvent> createConnectedPromise() {
        ICloudPlayer cloudPlayer = this.getCloudPlayer();
        if (this.alreadyConnected || cloudPlayer.getServerConnectState() == PlayerServerConnectState.CONNECTED) {
            ICloudService iCloudService = cloudPlayer.getConnectedServer();
            Intrinsics.checkNotNull((Object)iCloudService);
            return CommunicationPromise.Companion.of(new CloudPlayerServerConnectedEvent(cloudPlayer, iCloudService));
        }
        boolean autoUnregister$iv = true;
        long unregisterTimeInSeconds$iv = 300L;
        boolean $i$f$cloudListener = false;
        return new AdvancedListener(CloudPlayerServerConnectedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudPlayerServerConnectedEvent, Boolean>(cloudPlayer){
            final /* synthetic */ ICloudPlayer $cloudPlayer;

            public final boolean invoke(@NotNull CloudPlayerServerConnectedEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getCloudPlayer() == this.$cloudPlayer;
            }
            {
                this.$cloudPlayer = iCloudPlayer;
                super(1);
            }
        }).toPromise();
    }

    @NotNull
    public final UUID getPlayerUniqueId() {
        return this.playerUniqueId;
    }

    public final boolean getAlreadyConnected() {
        return this.alreadyConnected;
    }

    public ConnectionResponse(@NotNull UUID playerUniqueId, boolean alreadyConnected) {
        Intrinsics.checkNotNullParameter((Object)playerUniqueId, (String)"playerUniqueId");
        this.playerUniqueId = playerUniqueId;
        this.alreadyConnected = alreadyConnected;
    }
}

