/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.client.NetworkComponentReference;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartingEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.listenerextension.AdvancedListener;
import eu.thesimplecloud.api.network.component.INetworkComponent;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.IPropertyMap;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.template.ITemplate;
import eu.thesimplecloud.api.utils.time.Timestamp;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.IBootstrap;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016J\b\u0010\u0011\u001a\u00020\bH&J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\bH&J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0017H&J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H&J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u0005H\u0016J\u0016\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010#0 0\u0005H\u0016J\b\u0010$\u001a\u00020\u0017H&J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0017H&J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H&J\b\u0010,\u001a\u00020-H&J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\bH&J\b\u00101\u001a\u000202H&J\b\u00103\u001a\u00020\u0017H&J\b\u00104\u001a\u000205H\u0016J\n\u00106\u001a\u0004\u0018\u00010\bH&J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\b\u0010:\u001a\u000208H\u0016J\b\u0010;\u001a\u000208H\u0016J\b\u0010<\u001a\u000208H\u0016J\b\u0010=\u001a\u000208H\u0016J\b\u0010>\u001a\u000208H\u0016J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0014H&J\u0010\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\bH&J\u0010\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0017H&J\u0010\u0010E\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0017H&J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020-H&J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006K"}, d2={"Leu/thesimplecloud/api/service/ICloudService;", "Leu/thesimplecloud/api/network/component/INetworkComponent;", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/IBootstrap;", "Leu/thesimplecloud/api/property/IPropertyMap;", "copy", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "path", "", "createClosedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceUnregisteredEvent;", "createConnectedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceConnectedEvent;", "createStartedPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartedEvent;", "createStartingPromise", "Leu/thesimplecloud/api/event/service/CloudServiceStartingEvent;", "getGroupName", "getHost", "getLastPlayerUpdate", "Leu/thesimplecloud/api/utils/time/Timestamp;", "getMOTD", "getMaxMemory", "", "getMaxPlayers", "getName", "getNetworkComponentType", "Leu/thesimplecloud/api/client/NetworkComponentType;", "getOnlineCount", "getOnlinePercentage", "", "getOnlinePlayers", "", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "getOnlinePlayersDirect", "Leu/thesimplecloud/api/player/ICloudPlayer;", "getPort", "getServiceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "getServiceNumber", "getServiceType", "Leu/thesimplecloud/api/service/ServiceType;", "getServiceVersion", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "getState", "Leu/thesimplecloud/api/service/ServiceState;", "getTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "getTemplateName", "getUniqueId", "Ljava/util/UUID;", "getUsedMemory", "getWrapper", "Leu/thesimplecloud/api/wrapper/IWrapperInfo;", "getWrapperName", "isActive", "", "isFull", "isLobby", "isOnline", "isProxy", "isStartingOrVisible", "isStatic", "setLastPlayerUpdate", "timeStamp", "setMOTD", "motd", "setMaxPlayers", "amount", "setOnlineCount", "setState", "serviceState", "shutdown", "start", "update", "simplecloud-api"})
public interface ICloudService
extends INetworkComponent,
IBootstrap,
IPropertyMap {
    @NotNull
    public String getGroupName();

    public int getServiceNumber();

    @NotNull
    public UUID getUniqueId();

    @NotNull
    public ServiceType getServiceType();

    @NotNull
    public ServiceVersion getServiceVersion();

    @NotNull
    public String getTemplateName();

    @NotNull
    public ITemplate getTemplate();

    @NotNull
    public ICloudServiceGroup getServiceGroup();

    public int getMaxMemory();

    public int getUsedMemory();

    @Nullable
    public String getWrapperName();

    @NotNull
    public IWrapperInfo getWrapper();

    @NotNull
    public String getHost();

    public int getPort();

    public boolean isStatic();

    public double getOnlinePercentage();

    @Override
    @NotNull
    public String getName();

    @NotNull
    public Timestamp getLastPlayerUpdate();

    public void setLastPlayerUpdate(@NotNull Timestamp var1);

    @NotNull
    public ServiceState getState();

    public void setState(@NotNull ServiceState var1);

    public int getOnlineCount();

    public void setOnlineCount(int var1);

    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers();

    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect();

    public int getMaxPlayers();

    public void setMaxPlayers(int var1);

    @NotNull
    public String getMOTD();

    public void setMOTD(@NotNull String var1);

    public boolean isOnline();

    public boolean isFull();

    @Override
    @NotNull
    public NetworkComponentType getNetworkComponentType();

    @NotNull
    public ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise();

    @NotNull
    public ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise();

    public boolean isLobby();

    public boolean isProxy();

    @NotNull
    public ICommunicationPromise<Unit> update();

    @NotNull
    public ICommunicationPromise<Unit> copy(@NotNull String var1);

    public boolean isStartingOrVisible();

    @Override
    public boolean isActive();

    @Override
    @NotNull
    public ICommunicationPromise<Unit> start();

    @Override
    @NotNull
    public ICommunicationPromise<Unit> shutdown();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static ServiceType getServiceType(@NotNull ICloudService $this) {
            return $this.getServiceGroup().getServiceType();
        }

        @NotNull
        public static ITemplate getTemplate(@NotNull ICloudService $this) {
            ITemplate iTemplate = CloudAPI.Companion.getInstance().getTemplateManager().getTemplateByName($this.getTemplateName());
            if (iTemplate == null) {
                throw (Throwable)new IllegalStateException("Can't find the template of an registered service (templates: " + CollectionsKt.joinToString$default((Iterable)CloudAPI.Companion.getInstance().getTemplateManager().getAllCachedObjects(), null, null, null, (int)0, null, (Function1)getTemplate.1.INSTANCE, (int)31, null) + ')');
            }
            return iTemplate;
        }

        @NotNull
        public static ICloudServiceGroup getServiceGroup(@NotNull ICloudService $this) {
            ICloudServiceGroup iCloudServiceGroup = CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName($this.getGroupName());
            if (iCloudServiceGroup == null) {
                throw (Throwable)new IllegalStateException("Can't find the service group of an registered service");
            }
            return iCloudServiceGroup;
        }

        @NotNull
        public static IWrapperInfo getWrapper(@NotNull ICloudService $this) {
            Object object;
            block3: {
                block2: {
                    object = $this.getWrapperName();
                    if (object == null) break block2;
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    object = CloudAPI.Companion.getInstance().getWrapperManager().getWrapperByName(it);
                    if (object != null) break block3;
                }
                throw (Throwable)new IllegalStateException("Can't find the wrapper where the service " + $this.getName() + " is running on. Wrapper-Name: " + $this.getWrapperName());
            }
            return object;
        }

        @NotNull
        public static String getHost(@NotNull ICloudService $this) {
            return $this.getWrapper().getHost();
        }

        public static boolean isStatic(@NotNull ICloudService $this) {
            return $this.getServiceGroup().isStatic();
        }

        public static double getOnlinePercentage(@NotNull ICloudService $this) {
            return (double)$this.getOnlineCount() / (double)$this.getMaxPlayers();
        }

        @NotNull
        public static String getName(@NotNull ICloudService $this) {
            return $this.getGroupName() + "-" + $this.getServiceNumber();
        }

        @NotNull
        public static ICommunicationPromise<List<SimpleCloudPlayer>> getOnlinePlayers(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudPlayerManager().getPlayersConnectedToService($this);
        }

        @NotNull
        public static ICommunicationPromise<List<ICloudPlayer>> getOnlinePlayersDirect(@NotNull ICloudService $this) {
            return CommunicationPromiseExtensionKt.flatten$default($this.getOnlinePlayers().then(getOnlinePlayersDirect.1.INSTANCE), 0L, false, 3, null);
        }

        public static boolean isOnline(@NotNull ICloudService $this) {
            return $this.getState() == ServiceState.VISIBLE || $this.getState() == ServiceState.INVISIBLE;
        }

        public static boolean isFull(@NotNull ICloudService $this) {
            return $this.getOnlineCount() >= $this.getMaxPlayers();
        }

        @NotNull
        public static NetworkComponentType getNetworkComponentType(@NotNull ICloudService $this) {
            return NetworkComponentType.SERVICE;
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartingEvent> createStartingPromise(@NotNull ICloudService $this) {
            if ($this.isActive() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceStartingEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartingEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartingEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;

                public final boolean invoke(@NotNull CloudServiceStartingEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
                {
                    this.this$0 = iCloudService;
                    super(1);
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceConnectedEvent> createConnectedPromise(@NotNull ICloudService $this) {
            if ($this.isAuthenticated() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceConnectedEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceConnectedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceConnectedEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;

                public final boolean invoke(@NotNull CloudServiceConnectedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
                {
                    this.this$0 = iCloudService;
                    super(1);
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceStartedEvent> createStartedPromise(@NotNull ICloudService $this) {
            if ($this.isOnline() || $this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceStartedEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceStartedEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceStartedEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;

                public final boolean invoke(@NotNull CloudServiceStartedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
                {
                    this.this$0 = iCloudService;
                    super(1);
                }
            }).toPromise();
        }

        @NotNull
        public static ICommunicationPromise<CloudServiceUnregisteredEvent> createClosedPromise(@NotNull ICloudService $this) {
            if ($this.getState() == ServiceState.CLOSED) {
                return CommunicationPromise.Companion.of(new CloudServiceUnregisteredEvent($this));
            }
            boolean autoUnregister$iv = true;
            long unregisterTimeInSeconds$iv = 300L;
            boolean $i$f$cloudListener = false;
            return new AdvancedListener(CloudServiceUnregisteredEvent.class, autoUnregister$iv, unregisterTimeInSeconds$iv).addCondition((Function1)new Function1<CloudServiceUnregisteredEvent, Boolean>($this){
                final /* synthetic */ ICloudService this$0;

                public final boolean invoke(@NotNull CloudServiceUnregisteredEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getCloudService() == this.this$0;
                }
                {
                    this.this$0 = iCloudService;
                    super(1);
                }
            }).toPromise();
        }

        public static boolean isLobby(@NotNull ICloudService $this) {
            return $this.getServiceType() == ServiceType.LOBBY;
        }

        public static boolean isProxy(@NotNull ICloudService $this) {
            return $this.getServiceType() == ServiceType.PROXY;
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudService $this) {
            return ICacheList.DefaultImpls.update$default(CloudAPI.Companion.getInstance().getCloudServiceManager(), $this, false, false, 6, null);
        }

        @NotNull
        public static ICommunicationPromise<Unit> copy(@NotNull ICloudService $this, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return CloudAPI.Companion.getInstance().getCloudServiceManager().copyService($this, path);
        }

        public static boolean isStartingOrVisible(@NotNull ICloudService $this) {
            return $this.getState() == ServiceState.STARTING || $this.getState() == ServiceState.VISIBLE;
        }

        public static boolean isActive(@NotNull ICloudService $this) {
            return $this.getState() != ServiceState.PREPARED && $this.getState() != ServiceState.CLOSED;
        }

        @NotNull
        public static ICommunicationPromise<Unit> start(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudServiceManager().startService($this);
        }

        @NotNull
        public static ICommunicationPromise<Unit> shutdown(@NotNull ICloudService $this) {
            return CloudAPI.Companion.getInstance().getCloudServiceManager().stopService($this);
        }

        @NotNull
        public static NetworkComponentReference toNetworkComponentReference(@NotNull ICloudService $this) {
            return INetworkComponent.DefaultImpls.toNetworkComponentReference($this);
        }

        public static void executeCommand(@NotNull ICloudService $this, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            INetworkComponent.DefaultImpls.executeCommand($this, command);
        }

        @Nullable
        public static <T> IProperty<T> getProperty(@NotNull ICloudService $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return IPropertyMap.DefaultImpls.getProperty($this, name);
        }

        public static boolean hasProperty(@NotNull ICloudService $this, @NotNull String property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return IPropertyMap.DefaultImpls.hasProperty($this, property);
        }

        @NotNull
        public static HashMap<String, IProperty<?>> getMapWithNewestProperties(@NotNull ICloudService $this, @NotNull Map<String, ? extends IProperty<?>> compareMap) {
            Intrinsics.checkNotNullParameter(compareMap, (String)"compareMap");
            return IPropertyMap.DefaultImpls.getMapWithNewestProperties($this, compareMap);
        }
    }
}

