/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.impl;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.AbstractCacheList;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.ICacheObjectUpdater;
import eu.thesimplecloud.api.event.service.CloudServiceConnectedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceEvent;
import eu.thesimplecloud.api.event.service.CloudServiceInvisibleEvent;
import eu.thesimplecloud.api.event.service.CloudServiceRegisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartedEvent;
import eu.thesimplecloud.api.event.service.CloudServiceStartingEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUnregisteredEvent;
import eu.thesimplecloud.api.event.service.CloudServiceUpdatedEvent;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.network.packets.sync.cachelist.PacketIOUpdateCacheObject;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ICloudServiceManager;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.service.impl.AbstractCloudServiceManager;
import eu.thesimplecloud.api.service.impl.DefaultCloudService;
import eu.thesimplecloud.api.utils.time.Timestamp;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Leu/thesimplecloud/api/service/impl/AbstractCloudServiceManager;", "Leu/thesimplecloud/api/cachelist/AbstractCacheList;", "Leu/thesimplecloud/api/service/ICloudService;", "Leu/thesimplecloud/api/service/ICloudServiceManager;", "()V", "updater", "eu/thesimplecloud/api/service/impl/AbstractCloudServiceManager$updater$1", "Leu/thesimplecloud/api/service/impl/AbstractCloudServiceManager$updater$1;", "delete", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "value", "fromPacket", "", "deleteCloudService", "name", "", "getUpdater", "Leu/thesimplecloud/api/cachelist/ICacheObjectUpdater;", "simplecloud-api"})
public abstract class AbstractCloudServiceManager
extends AbstractCacheList<ICloudService>
implements ICloudServiceManager {
    private final updater.1 updater = new ICacheObjectUpdater<ICloudService>(this){
        final /* synthetic */ AbstractCloudServiceManager this$0;

        @Nullable
        public ICloudService getCachedObjectByUpdateValue(@NotNull ICloudService value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.this$0.getCloudServiceByName(value.getName());
        }

        @NotNull
        public List<IEvent> determineEventsToCall(@NotNull ICloudService updateValue, @Nullable ICloudService cachedValue) {
            ICloudService serviceToUse;
            Intrinsics.checkNotNullParameter((Object)updateValue, (String)"updateValue");
            ICloudService iCloudService = cachedValue;
            if (iCloudService == null) {
                iCloudService = serviceToUse = updateValue;
            }
            if (cachedValue == null) {
                return CollectionsKt.listOf((Object[])new CloudServiceEvent[]{new CloudServiceRegisteredEvent(serviceToUse), new CloudServiceUpdatedEvent(serviceToUse)});
            }
            boolean nowStarting = cachedValue.getState() == ServiceState.PREPARED && updateValue.getState() == ServiceState.STARTING;
            boolean nowOnline = !cachedValue.isOnline() && updateValue.isOnline();
            boolean nowConnected = !cachedValue.isAuthenticated() && updateValue.isAuthenticated();
            boolean nowInvisible = cachedValue.getState() == ServiceState.VISIBLE && updateValue.getState() == ServiceState.INVISIBLE;
            ArrayList<CloudServiceEvent> events = new ArrayList<CloudServiceEvent>();
            events.add(new CloudServiceUpdatedEvent(cachedValue));
            if (nowStarting) {
                events.add(new CloudServiceStartingEvent(cachedValue));
            }
            if (nowConnected) {
                events.add(new CloudServiceConnectedEvent(cachedValue));
            }
            if (nowOnline) {
                events.add(new CloudServiceStartedEvent(cachedValue));
            }
            if (nowInvisible) {
                events.add(new CloudServiceInvisibleEvent(cachedValue));
            }
            return events;
        }

        public void mergeUpdateValue(@NotNull ICloudService updateValue, @NotNull ICloudService cachedValue) {
            Intrinsics.checkNotNullParameter((Object)updateValue, (String)"updateValue");
            Intrinsics.checkNotNullParameter((Object)cachedValue, (String)"cachedValue");
            cachedValue.setMOTD(updateValue.getMOTD());
            cachedValue.setOnlineCount(updateValue.getOnlineCount());
            cachedValue.setState(updateValue.getState());
            cachedValue.setAuthenticated(updateValue.isAuthenticated());
            cachedValue.setMaxPlayers(updateValue.getMaxPlayers());
            DefaultCloudService cfr_ignored_0 = (DefaultCloudService)cachedValue;
            ((DefaultCloudService)cachedValue).setWrapperName(updateValue.getWrapperName());
            ((DefaultCloudService)cachedValue).setPort(updateValue.getPort());
            ((DefaultCloudService)cachedValue).setUsedMemory(updateValue.getUsedMemory());
            HashMap<String, IProperty<?>> hashMap = updateValue.getMapWithNewestProperties((Map)((DefaultCloudService)cachedValue).getPropertyMap());
            if (hashMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, eu.thesimplecloud.api.property.Property<*>>");
            }
            ((DefaultCloudService)cachedValue).setPropertyMap(new HashMap<String, Property<?>>(TypeIntrinsics.asMutableMap(hashMap)));
            if (updateValue.getOnlineCount() != cachedValue.getOnlineCount()) {
                cachedValue.setLastPlayerUpdate(new Timestamp(0L, 1, null));
            }
        }

        public void addNewValue(@NotNull ICloudService value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            value.setLastPlayerUpdate(new Timestamp(0L, 1, null));
            AbstractCloudServiceManager.access$getValues$p(this.this$0).add(value);
        }

        @NotNull
        public String getIdentificationName() {
            return "service-cache";
        }
        {
            this.this$0 = this$0;
        }

        @NotNull
        public ICommunicationPromise<Unit> sendUpdatesToOtherComponents(@NotNull ICloudService value, @NotNull PacketIOUpdateCacheObject.Action action) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            return ICacheObjectUpdater.DefaultImpls.sendUpdatesToOtherComponents(this, value, action);
        }
    };

    @Override
    @NotNull
    public ICacheObjectUpdater<ICloudService> getUpdater() {
        return this.updater;
    }

    @Override
    public void deleteCloudService(@NotNull String name) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ICloudService iCloudService = this.getCloudServiceByName(name);
            if (iCloudService == null) break block0;
            ICloudService iCloudService2 = iCloudService;
            boolean bl = false;
            boolean bl2 = false;
            ICloudService it = iCloudService2;
            boolean bl3 = false;
            ICacheList.DefaultImpls.delete$default(this, it, false, 2, null);
        }
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> delete(@NotNull ICloudService value, boolean fromPacket) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new CloudServiceUnregisteredEvent(value), false, 2, null);
        return super.delete(value, fromPacket);
    }

    public AbstractCloudServiceManager() {
        super(false, 1, null);
    }

    @Override
    @Nullable
    public ICloudService getCloudServiceByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ICloudServiceManager.DefaultImpls.getCloudServiceByName(this, name);
    }

    @Override
    @NotNull
    public List<ICloudService> getCloudServicesByGroupName(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return ICloudServiceManager.DefaultImpls.getCloudServicesByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getCloudServicesInLobbyStateByGroupName(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return ICloudServiceManager.DefaultImpls.getCloudServicesInLobbyStateByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getNotFullServicesInLobbyStateByGroupName(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return ICloudServiceManager.DefaultImpls.getNotFullServicesInLobbyStateByGroupName(this, groupName);
    }

    @Override
    @NotNull
    public List<ICloudService> getServicesRunningOnWrapper(@NotNull String wrapperName) {
        Intrinsics.checkNotNullParameter((Object)wrapperName, (String)"wrapperName");
        return ICloudServiceManager.DefaultImpls.getServicesRunningOnWrapper(this, wrapperName);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> startService(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        return ICloudServiceManager.DefaultImpls.startService(this, cloudService);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getValues$p(AbstractCloudServiceManager $this) {
        return $this.getValues();
    }
}

