/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.start.configuration;

import eu.thesimplecloud.api.service.start.configuration.IServiceStartConfiguration;
import eu.thesimplecloud.api.service.start.future.IServiceStartPromise;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.template.ITemplate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u001dH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR$\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u001e"}, d2={"Leu/thesimplecloud/api/service/start/configuration/ServiceStartConfiguration;", "Leu/thesimplecloud/api/service/start/configuration/IServiceStartConfiguration;", "serviceGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "(Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;)V", "groupName", "", "getGroupName", "()Ljava/lang/String;", "<set-?>", "", "maxMemory", "getMaxMemory", "()I", "maxPlayers", "getMaxPlayers", "serviceNumber", "getServiceNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "template", "getTemplate", "getServiceGroupName", "setMaxMemory", "memory", "setMaxPlayers", "setServiceNumber", "number", "setTemplate", "Leu/thesimplecloud/api/template/ITemplate;", "simplecloud-api"})
public final class ServiceStartConfiguration
implements IServiceStartConfiguration {
    @NotNull
    private final String groupName;
    private int maxMemory;
    private int maxPlayers;
    @NotNull
    private String template;
    @Nullable
    private Integer serviceNumber;

    @NotNull
    public final String getGroupName() {
        return this.groupName;
    }

    public final int getMaxMemory() {
        return this.maxMemory;
    }

    public final int getMaxPlayers() {
        return this.maxPlayers;
    }

    @NotNull
    public final String getTemplate() {
        return this.template;
    }

    @Nullable
    public final Integer getServiceNumber() {
        return this.serviceNumber;
    }

    @Override
    @NotNull
    public String getServiceGroupName() {
        return this.groupName;
    }

    @Override
    @NotNull
    public ServiceStartConfiguration setMaxMemory(int memory) {
        boolean bl = memory >= 100;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified memory must be at least 100";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxMemory = memory;
        return this;
    }

    @Override
    @NotNull
    public ServiceStartConfiguration setMaxPlayers(int maxPlayers) {
        boolean bl = maxPlayers > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified amount of maxPlayers must be positive.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.maxPlayers = maxPlayers;
        return this;
    }

    @Override
    @NotNull
    public ServiceStartConfiguration setTemplate(@NotNull ITemplate template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        this.template = template.getName();
        return this;
    }

    @Override
    @NotNull
    public ServiceStartConfiguration setServiceNumber(int number) {
        boolean bl = number > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified number must be positive.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.serviceNumber = number;
        return this;
    }

    public ServiceStartConfiguration(@NotNull ICloudServiceGroup serviceGroup) {
        Intrinsics.checkNotNullParameter((Object)serviceGroup, (String)"serviceGroup");
        this.groupName = serviceGroup.getName();
        this.maxMemory = serviceGroup.getMaxMemory();
        this.maxPlayers = serviceGroup.getMaxPlayers();
        this.template = serviceGroup.getTemplateName();
    }

    @Override
    @NotNull
    public ICloudServiceGroup getServiceGroup() {
        return IServiceStartConfiguration.DefaultImpls.getServiceGroup(this);
    }

    @Override
    @NotNull
    public IServiceStartPromise startService() {
        return IServiceStartConfiguration.DefaultImpls.startService(this);
    }
}

