/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.version;

import eu.thesimplecloud.api.directorypaths.DirectoryPaths;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.utils.WebContentLoader;
import eu.thesimplecloud.jsonlib.JsonLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Leu/thesimplecloud/api/service/version/ServiceVersionWebLoader;", "", "()V", "file", "Ljava/io/File;", "loadFromFile", "", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "loadVersions", "processWebContent", "contentString", "", "simplecloud-api"})
public final class ServiceVersionWebLoader {
    private static final File file;
    @NotNull
    public static final ServiceVersionWebLoader INSTANCE;

    @NotNull
    public final List<ServiceVersion> loadVersions() {
        String contentString = new WebContentLoader().loadContent("https://api.thesimplecloud.eu/versions");
        return contentString == null ? this.loadFromFile() : this.processWebContent(contentString);
    }

    private final List<ServiceVersion> loadFromFile() {
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist and the web server to load the service versions from is not available");
        }
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default(JsonLib.Companion, file, null, 2, null);
        Intrinsics.checkNotNull((Object)jsonLib);
        return ArraysKt.toList((Object[])jsonLib.getObject(ServiceVersion[].class));
    }

    private final List<ServiceVersion> processWebContent(String contentString) {
        JsonLib jsonLib = JsonLib.Companion.fromJsonString$default(JsonLib.Companion, contentString, null, 2, null);
        jsonLib.saveAsFile(file);
        return ArraysKt.toList((Object[])jsonLib.getObject(ServiceVersion[].class));
    }

    private ServiceVersionWebLoader() {
    }

    static {
        ServiceVersionWebLoader serviceVersionWebLoader;
        INSTANCE = serviceVersionWebLoader = new ServiceVersionWebLoader();
        file = new File(DirectoryPaths.Companion.getPaths().getStoragePath() + "mc-versions.json");
    }
}

