/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0005\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0004R*\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Leu/thesimplecloud/api/utils/FileEditor;", "", "lines", "", "", "(Ljava/util/List;)V", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "()V", "<set-?>", "", "getLines", "()Ljava/util/List;", "get", "name", "getLine", "i", "", "readFile", "", "replaceInAllLines", "old", "new", "replaceLine", "line", "replace", "save", "set", "value", "write", "s", "simplecloud-api"})
public final class FileEditor {
    @NotNull
    private List<String> lines;

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (String s : this.lines) {
            String[] array;
            CharSequence charSequence = s;
            String string = "=";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            Collection $this$toTypedArray$iv = string.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (!StringsKt.equals((String)array[0], (String)name, (boolean)true)) continue;
            return array[1];
        }
        return null;
    }

    public final void write(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.lines.add(s);
    }

    @Nullable
    public final String getLine(int i) {
        return i > this.lines.size() - 1 ? null : this.lines.get(i);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int line = -1;
        int n = 0;
        int n2 = ((Collection)this.lines).size();
        while (n < n2) {
            String[] array;
            List list;
            void i;
            String s = this.lines.get((int)i);
            CharSequence charSequence = s;
            String string = "=";
            int n3 = 0;
            string = new Regex(string);
            n3 = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n3);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (StringsKt.equals((String)array[0], (String)name, (boolean)true)) {
                line = i;
            }
            ++i;
        }
        if (line != -1) {
            this.lines.remove(line);
        }
        this.lines.add(name + '=' + value);
    }

    public final void save(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BufferedWriter writer = null;
        writer = new BufferedWriter(new FileWriter(file));
        for (String line : this.lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.close();
    }

    private final void readFile(File file) {
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        this.lines = new ArrayList(FilesKt.readLines((File)file, (Charset)charset));
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceLine(@NotNull String line, @NotNull String replace) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)replace, (String)"replace");
        int n = 0;
        int n2 = ((Collection)this.lines).size();
        while (n < n2) {
            void i;
            String s = this.lines.get((int)i);
            if (StringsKt.equals((String)s, (String)line, (boolean)true)) {
                this.lines.remove((int)i);
                this.lines.set((int)i, replace);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceInAllLines(@NotNull String old, @NotNull String string) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Iterable iterable = this.lines;
        FileEditor fileEditor = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = StringsKt.replace$default((String)it, (String)old, (String)string, (boolean)false, (int)4, null);
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        fileEditor.lines = new ArrayList(collection2);
    }

    public FileEditor() {
        this.lines = new ArrayList();
    }

    public FileEditor(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this();
        this.lines = new ArrayList(lines);
    }

    public FileEditor(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this();
        Stream<String> stream2 = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines();
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"BufferedReader(InputStre\u2026dCharsets.UTF_8)).lines()");
        this.lines = new ArrayList(StreamsKt.toList(stream2));
    }

    public FileEditor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this();
        if (!file.exists()) {
            File dir = new File(file, "..");
            dir.mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lines = new ArrayList();
        this.readFile(file);
    }
}

