/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/api/utils/ZipUtils;", "", "()V", "deletePath", "", "file", "Ljava/io/File;", "path", "", "simplecloud-api"})
public final class ZipUtils {
    public final void deletePath(@NotNull File file, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HashMap env = new HashMap();
        ((Map)env).put("create", "true");
        ((Map)env).put("encoding", "UTF-8");
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        URI uri = URI.create("jar:" + file.toURI().toString());
        FileSystem fileSystem = FileSystems.newFileSystem(uri, (Map)env);
        while (entries.hasMoreElements()) {
            Path pathInZipfile;
            ZipEntry nextElement;
            ZipEntry zipEntry = nextElement = entries.nextElement();
            Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"nextElement");
            String string = zipEntry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextElement.name");
            if (!StringsKt.startsWith$default((String)string, (String)path, (boolean)false, (int)2, null) || nextElement.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem.getPath(nextElement.getName(), new String[0]), (String)"fileSystem.getPath(nextElement.name)");
            Files.delete(pathInZipfile);
        }
        zipFile.close();
        fileSystem.close();
    }
}

