/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.connection;

import eu.thesimplecloud.clientserverapi.lib.connection.AbstractConnection;
import eu.thesimplecloud.clientserverapi.lib.connection.AbstractNettyConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/clientserverapi/lib/connection/AbstractNettyConnection;", "Leu/thesimplecloud/clientserverapi/lib/connection/AbstractConnection;", "()V", "closeConnection", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "getChannel", "Lio/netty/channel/Channel;", "getHost", "", "isOpen", "", "sendPacket", "wrappedPacket", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "promise", "", "clientserverapi"})
public abstract class AbstractNettyConnection
extends AbstractConnection {
    @Override
    public synchronized void sendPacket(@NotNull WrappedPacket wrappedPacket, @NotNull ICommunicationPromise<? extends Object> promise) {
        Intrinsics.checkNotNullParameter((Object)wrappedPacket, (String)"wrappedPacket");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (!this.isOpen()) {
            IOException exception = new IOException("Connection is closed. Packet to send was " + wrappedPacket.getPacketData().getSentPacketName() + '.');
            promise.tryFailure(exception);
            throw (Throwable)exception;
        }
        Channel channel2 = this.getChannel();
        Intrinsics.checkNotNull((Object)channel2);
        Channel channel3 = channel2;
        channel3.eventLoop().execute(new Runnable(channel3, wrappedPacket, promise){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ WrappedPacket $wrappedPacket;
            final /* synthetic */ ICommunicationPromise $promise;

            public final void run() {
                this.$channel.writeAndFlush((Object)this.$wrappedPacket).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this){
                    final /* synthetic */ sendPacket.1 this$0;

                    public final void operationComplete(Future<? super Void> it) {
                        Future<? super Void> future = it;
                        Intrinsics.checkNotNullExpressionValue(future, (String)"it");
                        if (!future.isSuccess()) {
                            this.this$0.$promise.tryFailure(it.cause());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$channel = channel2;
                this.$wrappedPacket = wrappedPacket;
                this.$promise = iCommunicationPromise;
            }
        });
    }

    @Nullable
    public abstract Channel getChannel();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpen() {
        if (this.getChannel() == null) return false;
        Channel channel2 = this.getChannel();
        if (channel2 == null) return false;
        boolean bl = channel2.isActive();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> closeConnection() {
        CommunicationPromise connectionPromise;
        block4: {
            block3: {
                block2: {
                    if (this.getChannel() == null) break block2;
                    Channel channel2 = this.getChannel();
                    Intrinsics.checkNotNull((Object)channel2);
                    if (channel2.isOpen()) break block3;
                }
                throw (Throwable)new IllegalStateException("Connection already closed.");
            }
            connectionPromise = new CommunicationPromise(2000L, false, 2, null);
            Channel channel3 = this.getChannel();
            if (channel3 == null || (channel3 = channel3.close()) == null) break block4;
            channel3.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(connectionPromise){
                final /* synthetic */ CommunicationPromise $connectionPromise;

                public final void operationComplete(Future<? super Void> it) {
                    this.$connectionPromise.trySuccess(Unit.INSTANCE);
                }
                {
                    this.$connectionPromise = communicationPromise;
                }
            });
        }
        return connectionPromise;
    }

    @Override
    @Nullable
    public String getHost() {
        if (!this.isOpen()) {
            return null;
        }
        Channel channel2 = this.getChannel();
        Intrinsics.checkNotNull((Object)channel2);
        SocketAddress socketAddress = channel2.remoteAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        return ((InetSocketAddress)socketAddress).getHostString();
    }
}

