/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.directorywatch;

import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatch;
import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatchListener;
import eu.thesimplecloud.clientserverapi.lib.directorywatch.IDirectoryWatchManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u000ej\b\u0012\u0004\u0012\u00020\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Leu/thesimplecloud/clientserverapi/lib/directorywatch/DirectoryWatch;", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatch;", "directoryWatchManager", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;", "directory", "Ljava/io/File;", "(Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchManager;Ljava/io/File;)V", "lastTickFiles", "", "listeners", "Ljava/util/ArrayList;", "Leu/thesimplecloud/clientserverapi/lib/directorywatch/IDirectoryWatchListener;", "Lkotlin/collections/ArrayList;", "subDirectoryWatches", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addWatchListener", "", "watchListener", "createSubDirectoryWatch", "file", "getAllCurrentFiles", "getAllListenersExceptFirst", "getDirectory", "removeSubDirectoryWatch", "removeWatchListener", "tick", "clientserverapi"})
public final class DirectoryWatch
implements IDirectoryWatch {
    private final HashSet<IDirectoryWatch> subDirectoryWatches;
    private final ArrayList<IDirectoryWatchListener> listeners;
    private List<? extends File> lastTickFiles;
    private final IDirectoryWatchManager directoryWatchManager;
    private final File directory;

    public final void tick() {
        Iterator $this$filterTo$iv$iv;
        Object $this$forEach$iv;
        Object element$iv2;
        List<File> allCurrentFiles = this.getAllCurrentFiles();
        List addedFiles = CollectionsKt.toMutableList((Collection)allCurrentFiles);
        addedFiles.removeAll((Collection)this.lastTickFiles);
        Iterable $this$forEach$iv2 = addedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            File file = (File)element$iv2;
            boolean bl = false;
            $this$forEach$iv = this.listeners;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv3 = iterator.next();
                IDirectoryWatchListener it2 = (IDirectoryWatchListener)element$iv3;
                boolean bl2 = false;
                it2.fileCreated(file);
            }
        }
        Iterable $this$filter$iv = this.lastTickFiles;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        $this$forEach$iv = $this$filterTo$iv$iv.iterator();
        while ($this$forEach$iv.hasNext()) {
            Object element$iv$iv = $this$forEach$iv.next();
            File it = (File)element$iv$iv;
            boolean bl = false;
            long it2 = System.currentTimeMillis() - it.lastModified();
            if (!((long)200 <= it2 && (long)399 >= it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv3 = modifiedFiles;
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            File file = (File)element$iv4;
            boolean bl = false;
            Iterable $this$forEach$iv4 = this.listeners;
            boolean $i$f$forEach4 = false;
            for (Object element$iv5 : $this$forEach$iv4) {
                IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv5;
                boolean bl3 = false;
                it.fileModified(file);
            }
        }
        List removedFiles = CollectionsKt.toMutableList((Collection)this.lastTickFiles);
        removedFiles.removeAll((Collection)allCurrentFiles);
        Iterable $this$forEach$iv5 = removedFiles;
        boolean $i$f$forEach5 = false;
        for (Object element$iv6 : $this$forEach$iv5) {
            File file = (File)element$iv6;
            boolean bl = false;
            Iterable $this$forEach$iv6 = this.listeners;
            boolean $i$f$forEach6 = false;
            for (Object element$iv7 : $this$forEach$iv6) {
                IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv7;
                boolean bl4 = false;
                it.fileDeleted(file);
            }
        }
        this.lastTickFiles = this.getAllCurrentFiles();
    }

    private final List<File> getAllCurrentFiles() {
        Object object = this.directory.listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final void createSubDirectoryWatch(File file) {
        IDirectoryWatch directoryWatch = this.directoryWatchManager.createDirectoryWatch(file);
        this.subDirectoryWatches.add(directoryWatch);
        Iterable $this$forEach$iv = this.getAllListenersExceptFirst();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatchListener it = (IDirectoryWatchListener)element$iv;
            boolean bl = false;
            directoryWatch.addWatchListener(it);
        }
    }

    private final void removeSubDirectoryWatch(File file) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.subDirectoryWatches;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IDirectoryWatch it = (IDirectoryWatch)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDirectory(), (Object)file)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IDirectoryWatch iDirectoryWatch = v0;
        if (iDirectoryWatch == null) {
            return;
        }
        IDirectoryWatch subDirectoryWatch = iDirectoryWatch;
        this.subDirectoryWatches.remove(subDirectoryWatch);
        this.directoryWatchManager.deleteDirectoryWatch(subDirectoryWatch);
    }

    @Override
    public void addWatchListener(@NotNull IDirectoryWatchListener watchListener) {
        Intrinsics.checkNotNullParameter((Object)watchListener, (String)"watchListener");
        this.listeners.add(watchListener);
        Iterable $this$forEach$iv = this.subDirectoryWatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatch it = (IDirectoryWatch)element$iv;
            boolean bl = false;
            it.addWatchListener(watchListener);
        }
    }

    @Override
    public void removeWatchListener(@NotNull IDirectoryWatchListener watchListener) {
        Intrinsics.checkNotNullParameter((Object)watchListener, (String)"watchListener");
        this.listeners.remove(watchListener);
        Iterable $this$forEach$iv = this.subDirectoryWatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IDirectoryWatch it = (IDirectoryWatch)element$iv;
            boolean bl = false;
            it.removeWatchListener(watchListener);
        }
    }

    @NotNull
    public final List<IDirectoryWatchListener> getAllListenersExceptFirst() {
        return CollectionsKt.drop((Iterable)this.listeners, (int)1);
    }

    @Override
    @NotNull
    public File getDirectory() {
        return this.directory;
    }

    /*
     * WARNING - void declaration
     */
    public DirectoryWatch(@NotNull IDirectoryWatchManager directoryWatchManager, @NotNull File directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directoryWatchManager, (String)"directoryWatchManager");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directoryWatchManager = directoryWatchManager;
        this.directory = directory;
        this.subDirectoryWatches = new HashSet();
        this.listeners = new ArrayList();
        this.lastTickFiles = this.getAllCurrentFiles();
        boolean bl = this.directory.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Specified file must be a directory";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        File[] fileArray = this.directory.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"directory.listFiles()");
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_13 = $this$filterTo$iv$iv;
        int n = ((void)var8_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var8_13[i];
            boolean bl5 = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!v1.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl6 = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            this.createSubDirectoryWatch(file);
        }
        this.addWatchListener(new IDirectoryWatchListener(){

            @Override
            public void fileCreated(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isDirectory()) {
                    this.createSubDirectoryWatch(file);
                }
            }

            @Override
            public void fileModified(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            }

            @Override
            public void fileDeleted(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.removeSubDirectoryWatch(file);
            }
        });
    }
}

