/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.packetmanager;

import com.google.common.collect.Maps;
import eu.thesimplecloud.clientserverapi.lib.extension.MapExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packetmanager.IPacketManager;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016Rn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/clientserverapi/lib/packetmanager/PacketManager;", "Leu/thesimplecloud/clientserverapi/lib/packetmanager/IPacketManager;", "()V", "packets", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Ljava/lang/Class;", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "clearPackets", "", "getPacketClassByOppositePacketName", "name", "getPacketClassBySimpleName", "registerPacket", "packetClass", "unregisterPacket", "", "clientserverapi"})
public final class PacketManager
implements IPacketManager {
    private final ConcurrentMap<String, Class<? extends IPacket>> packets = Maps.newConcurrentMap();

    @Override
    @Nullable
    public Class<? extends IPacket> getPacketClassBySimpleName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Class)this.packets.get(name);
    }

    @Override
    @Nullable
    public Class<? extends IPacket> getPacketClassByOppositePacketName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String oppositePacketName = StringsKt.startsWith$default((String)name, (String)"PacketOut", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)name, (String)"PacketOut", (String)"PacketIn", (boolean)false, (int)4, null) : (StringsKt.startsWith$default((String)name, (String)"PacketIn", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)name, (String)"PacketIn", (String)"PacketOut", (boolean)false, (int)4, null) : name);
        return (Class)this.packets.get(oppositePacketName);
    }

    @Override
    public void registerPacket(@NotNull Class<? extends IPacket> packetClass) {
        Intrinsics.checkNotNullParameter(packetClass, (String)"packetClass");
        ConcurrentMap<String, Class<? extends IPacket>> concurrentMap = this.packets;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"packets");
        ((Map)concurrentMap).put(packetClass.getSimpleName(), packetClass);
    }

    @Override
    public boolean unregisterPacket(@NotNull Class<? extends IPacket> packetClass) {
        String key2;
        block0: {
            Intrinsics.checkNotNullParameter(packetClass, (String)"packetClass");
            ConcurrentMap<String, Class<? extends IPacket>> concurrentMap = this.packets;
            Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"packets");
            String string = key2 = (String)MapExtensionKt.getKey((Map)concurrentMap, (Function1)new Function1<Class<? extends IPacket>, Boolean>(packetClass){
                final /* synthetic */ Class $packetClass;

                public final boolean invoke(Class<? extends IPacket> it) {
                    Class<? extends IPacket> clazz = it;
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"it");
                    return Intrinsics.areEqual((Object)clazz.getSimpleName(), (Object)this.$packetClass.getSimpleName());
                }
                {
                    this.$packetClass = clazz;
                    super(1);
                }
            });
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Class cfr_ignored_0 = (Class)this.packets.remove(it);
        }
        return key2 != null;
    }

    @Override
    public void clearPackets() {
        this.packets.clear();
    }
}

