/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.testing;

import eu.thesimplecloud.clientserverapi.lib.connection.AbstractConnection;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.clientserverapi.testing.NetworkTestManager;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Leu/thesimplecloud/clientserverapi/testing/AbstractTestConnection;", "Leu/thesimplecloud/clientserverapi/lib/connection/AbstractConnection;", "()V", "otherSideConnection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "getOtherSideConnection", "()Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "setOtherSideConnection", "(Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;)V", "closeConnection", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "getHost", "", "isOpen", "", "sendPacket", "wrappedPacket", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "promise", "", "clientserverapi"})
public abstract class AbstractTestConnection
extends AbstractConnection {
    @Nullable
    private volatile IConnection otherSideConnection;

    @Nullable
    public final IConnection getOtherSideConnection() {
        return this.otherSideConnection;
    }

    public final void setOtherSideConnection(@Nullable IConnection iConnection) {
        this.otherSideConnection = iConnection;
    }

    @Override
    public void sendPacket(@NotNull WrappedPacket wrappedPacket, @NotNull ICommunicationPromise<? extends Object> promise) {
        Intrinsics.checkNotNullParameter((Object)wrappedPacket, (String)"wrappedPacket");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (!this.isOpen()) {
            IOException exception = new IOException("Connection is closed. Packet to send was " + wrappedPacket.getPacketData().getSentPacketName() + ". This: " + this.getClass().getName());
            promise.tryFailure(exception);
            throw (Throwable)exception;
        }
        NetworkTestManager.INSTANCE.sendPacket(this, wrappedPacket);
    }

    @Override
    public boolean isOpen() {
        return this.otherSideConnection != null;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> closeConnection() {
        NetworkTestManager.INSTANCE.closeConnection(this);
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    @Override
    @Nullable
    public String getHost() {
        if (!this.isOpen()) {
            return null;
        }
        return "127.0.0.1";
    }
}

