/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.jsonlib.bukkit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import eu.thesimplecloud.jsonlib.JsonLib;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/jsonlib/bukkit/LocationSerializer;", "Lcom/google/gson/JsonSerializer;", "Lorg/bukkit/Location;", "Lcom/google/gson/JsonDeserializer;", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "json-lib"})
public final class LocationSerializer
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    @NotNull
    public JsonElement serialize(@NotNull Location src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        JsonObject result = new JsonObject();
        result.add("x", (JsonElement)new JsonPrimitive((Number)src.getX()));
        result.add("y", (JsonElement)new JsonPrimitive((Number)src.getY()));
        result.add("z", (JsonElement)new JsonPrimitive((Number)src.getZ()));
        result.add("yaw", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getYaw())));
        result.add("pitch", (JsonElement)new JsonPrimitive((Number)Float.valueOf(src.getPitch())));
        World world = src.getWorld();
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"src.world!!");
        result.add("world", (JsonElement)new JsonPrimitive(world.getName()));
        return (JsonElement)result;
    }

    @Nullable
    public Location deserialize(@NotNull JsonElement jsonElement, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonElement.asJsonObject");
        JsonObject jsonObject2 = jsonObject;
        JsonLib jsonLib = JsonLib.Companion.fromJsonElement((JsonElement)jsonObject2);
        String string = jsonLib.getString("world");
        if (string == null) {
            return null;
        }
        String worldName = string;
        World world = Bukkit.getWorld((String)worldName);
        Double d = jsonLib.getDouble("x");
        if (d == null) {
            return null;
        }
        double x = d;
        Double d2 = jsonLib.getDouble("y");
        if (d2 == null) {
            return null;
        }
        double y = d2;
        Double d3 = jsonLib.getDouble("z");
        if (d3 == null) {
            return null;
        }
        double z = d3;
        Float f = jsonLib.getFloat("yaw");
        if (f == null) {
            return null;
        }
        float yaw = f.floatValue();
        Float f2 = jsonLib.getFloat("pitch");
        if (f2 == null) {
            return null;
        }
        float pitch = f2.floatValue();
        return new Location(world, x, y, z, yaw, pitch);
    }
}

