/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.impl.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.exception.NoSuchPlayerException;
import eu.thesimplecloud.api.exception.NoSuchServiceException;
import eu.thesimplecloud.api.exception.PlayerConnectException;
import eu.thesimplecloud.api.exception.UnreachableComponentException;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOCloudPlayerForceCommandExecution;
import eu.thesimplecloud.api.network.packets.player.PacketIOConnectCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOGetPlayerLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOKickCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOPlayerHasPermission;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendActionbarToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendMessageToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendPlayerToLobby;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTablistToPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTitleToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOTeleportPlayer;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.impl.player.AbstractServiceCloudPlayerManager;
import eu.thesimplecloud.plugin.network.packets.PacketOutTeleportOtherService;
import eu.thesimplecloud.plugin.proxy.bungee.CloudBungeePlugin;
import eu.thesimplecloud.plugin.proxy.bungee.LobbyConnector;
import eu.thesimplecloud.plugin.proxy.bungee.text.CloudTextBuilder;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J1\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0!H\u0016\u00a2\u0006\u0002\u0010#J8\u0010$\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u000fH\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0016\u00a8\u0006."}, d2={"Leu/thesimplecloud/plugin/impl/player/CloudPlayerManagerBungee;", "Leu/thesimplecloud/plugin/impl/player/AbstractServiceCloudPlayerManager;", "()V", "connectPlayer", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "forcePlayerCommandExecution", "", "command", "", "getLocationOfPlayer", "Leu/thesimplecloud/api/location/ServiceLocation;", "getProxiedPlayerByCloudPlayer", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "getServerInfoByCloudService", "Lnet/md_5/bungee/api/config/ServerInfo;", "hasPermission", "", "permission", "kickPlayer", "message", "sendActionbar", "actionbar", "sendMessageToPlayer", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "sendPlayerToLobby", "sendTablist", "headers", "", "footers", "(Leu/thesimplecloud/api/player/ICloudPlayer;[Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "", "stay", "fadeOut", "teleportPlayer", "location", "Leu/thesimplecloud/api/location/SimpleLocation;", "simplecloud-plugin"})
public final class CloudPlayerManagerBungee
extends AbstractServiceCloudPlayerManager {
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull CloudText cloudText) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)cloudText, (String)"cloudText");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendMessageToCloudPlayer(cloudPlayer, cloudText), 0L, 2, null);
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendMessage((BaseComponent)new CloudTextBuilder().build(cloudText));
        }
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connectPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        boolean bl = this.getCachedCloudPlayer(cloudPlayer.getUniqueId()) == cloudPlayer;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "CloudPlayer must be the cached player.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (cloudService.getServiceType() == ServiceType.PROXY) {
            return CommunicationPromise.Companion.failed(new IllegalArgumentException("Cannot send a player to a proxy service"));
        }
        if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedServerName(), (Object)cloudService.getName())) {
            return CommunicationPromise.Companion.of(new ConnectionResponse(cloudPlayer.getUniqueId(), true));
        }
        if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
            void packet$iv;
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket iPacket = new PacketIOConnectCloudPlayer(cloudPlayer, cloudService);
            long timeout$iv = 500L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, ConnectionResponse.class, timeout$iv);
        }
        ServerInfo serverInfo = this.getServerInfoByCloudService(cloudService);
        if (serverInfo == null) {
            return CommunicationPromise.Companion.failed(new UnreachableComponentException("Service is not registered on player's proxy"));
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchElementException("Unable to find the player on the proxy service"));
        }
        CommunicationPromise communicationPromise = new CommunicationPromise(0L, false, 3, null);
        proxiedPlayer.connect(serverInfo, (Callback)new Callback<Boolean>(communicationPromise, cloudPlayer){
            final /* synthetic */ CommunicationPromise $communicationPromise;
            final /* synthetic */ ICloudPlayer $cloudPlayer;

            public final void done(Boolean bl, Throwable $noName_1) {
                Boolean bl2 = bl;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"boolean");
                if (bl2.booleanValue()) {
                    this.$communicationPromise.trySuccess(new ConnectionResponse(this.$cloudPlayer.getUniqueId(), false));
                } else {
                    this.$communicationPromise.tryFailure(new PlayerConnectException("Unable to connect the player to the service"));
                }
            }
            {
                this.$communicationPromise = communicationPromise;
                this.$cloudPlayer = iCloudPlayer;
            }
        });
        return communicationPromise;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kickPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOKickCloudPlayer(cloudPlayer, message), 0L, 2, null);
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
        }
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    @Override
    public void sendTitle(@NotNull ICloudPlayer cloudPlayer, @NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTitleToCloudPlayer(cloudPlayer, title, subTitle, fadeIn, stay, fadeOut), 0L, 2, null);
                return;
            }
            Title titleObj = ProxyServer.getInstance().createTitle();
            titleObj.title((BaseComponent)new CloudTextBuilder().build(new CloudText(title))).subTitle((BaseComponent)new CloudTextBuilder().build(new CloudText(subTitle))).fadeIn(fadeIn).stay(stay).fadeOut(fadeOut);
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendTitle(titleObj);
        }
    }

    @Override
    public void forcePlayerCommandExecution(@NotNull ICloudPlayer cloudPlayer, @NotNull String command) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOCloudPlayerForceCommandExecution(cloudPlayer, command), 0L, 2, null);
                return;
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.chat('/' + command);
        }
    }

    @Override
    public void sendActionbar(@NotNull ICloudPlayer cloudPlayer, @NotNull String actionbar) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)actionbar, (String)"actionbar");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendActionbarToCloudPlayer(cloudPlayer, actionbar), 0L, 2, null);
                return;
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new CloudTextBuilder().build(new CloudText(actionbar)));
        }
    }

    @Override
    public void sendTablist(@NotNull ICloudPlayer cloudPlayer, @NotNull String[] headers, @NotNull String[] footers) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)footers, (String)"footers");
            if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTablistToPlayer(cloudPlayer.getUniqueId(), headers, footers), 0L, 2, null);
                return;
            }
            String headerString = ArraysKt.joinToString$default((Object[])headers, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            String footerString = ArraysKt.joinToString$default((Object[])footers, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.setTabHeader((BaseComponent)new CloudTextBuilder().build(new CloudText(headerString)), (BaseComponent)new CloudTextBuilder().build(new CloudText(footerString)));
        }
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOTeleportPlayer(cloudPlayer, location), 0L, 2, null);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ServiceLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (location.getService() == null) {
            return CommunicationPromise.Companion.failed(new NoSuchServiceException("Service to connect the player to cannot be found."));
        }
        return CloudPlugin.Companion.getInstance().getConnectionToManager().sendUnitQuery(new PacketOutTeleportOtherService(cloudPlayer.getUniqueId(), location.getServiceName(), location), 1000L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer cloudPlayer, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (Intrinsics.areEqual((Object)cloudPlayer.getConnectedProxyName(), (Object)CloudPlugin.Companion.getInstance().getThisServiceName()) ^ true) {
            void packet$iv;
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket iPacket = new PacketIOPlayerHasPermission(cloudPlayer.getUniqueId(), permission);
            long timeout$iv = 400L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, Boolean.class, timeout$iv);
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find bungeecord player"));
        }
        return CommunicationPromise.Companion.of(proxiedPlayer.hasPermission(permission));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocationOfPlayer(@NotNull ICloudPlayer cloudPlayer) {
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket packet$iv = new PacketIOGetPlayerLocation(cloudPlayer);
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery(packet$iv, ServiceLocation.class, timeout$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendPlayerToLobby(@NotNull ICloudPlayer cloudPlayer) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        if (Intrinsics.areEqual((Object)CloudPlugin.Companion.getInstance().getThisServiceName(), (Object)cloudPlayer.getConnectedProxyName()) ^ true) {
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket packet$iv = new PacketIOSendPlayerToLobby(cloudPlayer.getUniqueId());
            long timeout$iv = 200L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery(packet$iv, Unit.class, timeout$iv);
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find bungeecord player"));
        }
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer;
        ServerInfo serverInfo = LobbyConnector.getLobbyServer$default(CloudBungeePlugin.Companion.getInstance().getLobbyConnector(), proxiedPlayer2, null, 2, null);
        if (serverInfo == null) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
            proxiedPlayer2.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
            return CommunicationPromise.Companion.failed(new NoSuchServiceException("No fallback server found"));
        }
        proxiedPlayer2.connect(serverInfo);
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    private final ProxiedPlayer getProxiedPlayerByCloudPlayer(ICloudPlayer cloudPlayer) {
        return ProxyServer.getInstance().getPlayer(cloudPlayer.getUniqueId());
    }

    private final ServerInfo getServerInfoByCloudService(ICloudService cloudService) {
        return ProxyServer.getInstance().getServerInfo(cloudService.getName());
    }
}

