/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.impl.player;

import eu.thesimplecloud.api.exception.NoSuchPlayerException;
import eu.thesimplecloud.api.exception.NoSuchServiceException;
import eu.thesimplecloud.api.exception.NoSuchWorldException;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOCloudPlayerForceCommandExecution;
import eu.thesimplecloud.api.network.packets.player.PacketIOConnectCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOGetPlayerLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOKickCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOPlayerHasPermission;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendActionbarToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendMessageToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendPlayerToLobby;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTablistToPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTitleToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOTeleportPlayer;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.extension.SyncExtensionKt;
import eu.thesimplecloud.plugin.impl.player.AbstractServiceCloudPlayerManager;
import eu.thesimplecloud.plugin.network.packets.PacketOutTeleportOtherService;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J1\u0010!\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0016\u00a2\u0006\u0002\u0010%J8\u0010&\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0013H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0011H\u0016\u00a8\u0006/"}, d2={"Leu/thesimplecloud/plugin/impl/player/CloudPlayerManagerSpigot;", "Leu/thesimplecloud/plugin/impl/player/AbstractServiceCloudPlayerManager;", "()V", "connectPlayer", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "forcePlayerCommandExecution", "", "command", "", "getLocationBySimpleLocation", "Lorg/bukkit/Location;", "simpleLocation", "Leu/thesimplecloud/api/location/SimpleLocation;", "getLocationOfPlayer", "Leu/thesimplecloud/api/location/ServiceLocation;", "getPlayerByCloudPlayer", "Lorg/bukkit/entity/Player;", "hasPermission", "", "permission", "kickPlayer", "message", "sendActionbar", "actionbar", "sendMessageToPlayer", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "sendPlayerToLobby", "sendTablist", "headers", "", "footers", "(Leu/thesimplecloud/api/player/ICloudPlayer;[Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "", "stay", "fadeOut", "teleportPlayer", "location", "simplecloud-plugin"})
public final class CloudPlayerManagerSpigot
extends AbstractServiceCloudPlayerManager {
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull CloudText cloudText) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)cloudText, (String)"cloudText");
        return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendMessageToCloudPlayer(cloudPlayer, cloudText), 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connectPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ICloudService cloudService) {
        void packet$iv;
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket iPacket = new PacketIOConnectCloudPlayer(cloudPlayer, cloudService);
        long timeout$iv = 500L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, ConnectionResponse.class, timeout$iv);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kickPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOKickCloudPlayer(cloudPlayer, message), 0L, 2, null);
    }

    @Override
    public void sendTitle(@NotNull ICloudPlayer cloudPlayer, @NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subTitle, (String)"subTitle");
        IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTitleToCloudPlayer(cloudPlayer, title, subTitle, fadeIn, stay, fadeOut), 0L, 2, null);
    }

    @Override
    public void forcePlayerCommandExecution(@NotNull ICloudPlayer cloudPlayer, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOCloudPlayerForceCommandExecution(cloudPlayer, command), 0L, 2, null);
    }

    @Override
    public void sendActionbar(@NotNull ICloudPlayer cloudPlayer, @NotNull String actionbar) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)actionbar, (String)"actionbar");
        IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendActionbarToCloudPlayer(cloudPlayer, actionbar), 0L, 2, null);
    }

    @Override
    public void sendTablist(@NotNull ICloudPlayer cloudPlayer, @NotNull String[] headers, @NotNull String[] footers) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)footers, (String)"footers");
        IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTablistToPlayer(cloudPlayer.getUniqueId(), headers, footers), 0L, 2, null);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (Intrinsics.areEqual((Object)CloudPlugin.Companion.getInstance().getThisServiceName(), (Object)cloudPlayer.getConnectedServerName()) ^ true) {
            return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOTeleportPlayer(cloudPlayer, location), 0L, 2, null);
        }
        Player bukkitPlayer = this.getPlayerByCloudPlayer(cloudPlayer);
        if (bukkitPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find the player on the server service"));
        }
        Location bukkitLocation = this.getLocationBySimpleLocation(location);
        if (bukkitLocation == null) {
            return CommunicationPromise.Companion.failed(new NoSuchWorldException("Unable to find world: " + location.getWorldName()));
        }
        SyncExtensionKt.syncBukkit((Function0<Unit>)((Function0)new Function0<Unit>(bukkitPlayer, bukkitLocation){
            final /* synthetic */ Player $bukkitPlayer;
            final /* synthetic */ Location $bukkitLocation;

            public final void invoke() {
                this.$bukkitPlayer.teleport(this.$bukkitLocation);
            }
            {
                this.$bukkitPlayer = player;
                this.$bukkitLocation = location;
                super(0);
            }
        }));
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ServiceLocation location) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (location.getService() == null) {
            return CommunicationPromise.Companion.failed(new NoSuchServiceException("Service to connect the player to cannot be found."));
        }
        return CloudPlugin.Companion.getInstance().getConnectionToManager().sendUnitQuery(new PacketOutTeleportOtherService(cloudPlayer.getUniqueId(), location.getServiceName(), location), 1000L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer cloudPlayer, @NotNull String permission) {
        void packet$iv;
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket iPacket = new PacketIOPlayerHasPermission(cloudPlayer.getUniqueId(), permission);
        long timeout$iv = 400L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, Boolean.class, timeout$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocationOfPlayer(@NotNull ICloudPlayer cloudPlayer) {
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        if (Intrinsics.areEqual((Object)CloudPlugin.Companion.getInstance().getThisServiceName(), (Object)cloudPlayer.getConnectedServerName()) ^ true) {
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket packet$iv = new PacketIOGetPlayerLocation(cloudPlayer);
            long timeout$iv = 200L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery(packet$iv, ServiceLocation.class, timeout$iv);
        }
        Player bukkitPlayer = this.getPlayerByCloudPlayer(cloudPlayer);
        if (bukkitPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find bukkit player"));
        }
        Location location = bukkitPlayer.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"bukkitPlayer.location");
        Location playerLocation = location;
        if (playerLocation.getWorld() == null) {
            return CommunicationPromise.Companion.failed(new NoSuchWorldException("The world the player is on is null"));
        }
        ICloudService iCloudService = CloudPlugin.Companion.getInstance().thisService();
        World world = playerLocation.getWorld();
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"playerLocation.world!!");
        String string = world.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"playerLocation.world!!.name");
        return CommunicationPromise.Companion.of(new ServiceLocation(iCloudService, string, playerLocation.getX(), playerLocation.getY(), playerLocation.getZ(), playerLocation.getYaw(), playerLocation.getPitch()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendPlayerToLobby(@NotNull ICloudPlayer cloudPlayer) {
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter((Object)cloudPlayer, (String)"cloudPlayer");
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket packet$iv = new PacketIOSendPlayerToLobby(cloudPlayer.getUniqueId());
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery(packet$iv, Unit.class, timeout$iv);
    }

    private final Location getLocationBySimpleLocation(SimpleLocation simpleLocation) {
        World world = Bukkit.getWorld((String)simpleLocation.getWorldName());
        if (world == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"Bukkit.getWorld(simpleLo\u2026worldName) ?: return null");
        World world2 = world;
        return new Location(world2, simpleLocation.getX(), simpleLocation.getY(), simpleLocation.getZ(), simpleLocation.getYaw(), simpleLocation.getPitch());
    }

    private final Player getPlayerByCloudPlayer(ICloudPlayer cloudPlayer) {
        return Bukkit.getPlayer((UUID)cloudPlayer.getUniqueId());
    }
}

