/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.bungee;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.impl.player.CloudPlayerManagerBungee;
import eu.thesimplecloud.plugin.listener.CloudListener;
import eu.thesimplecloud.plugin.proxy.ICloudProxyPlugin;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.bungee.LobbyConnector;
import eu.thesimplecloud.plugin.proxy.bungee.ReconnectHandlerImpl;
import eu.thesimplecloud.plugin.proxy.bungee.listener.BungeeListener;
import eu.thesimplecloud.plugin.proxy.bungee.listener.IngameCommandListener;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0010H\u0002J\b\u0010\"\u001a\u00020\u0010H\u0016J\b\u0010#\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R6\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Leu/thesimplecloud/plugin/proxy/bungee/CloudBungeePlugin;", "Lnet/md_5/bungee/api/plugin/Plugin;", "Leu/thesimplecloud/plugin/proxy/ICloudProxyPlugin;", "()V", "lobbyConnector", "Leu/thesimplecloud/plugin/proxy/bungee/LobbyConnector;", "getLobbyConnector", "()Leu/thesimplecloud/plugin/proxy/bungee/LobbyConnector;", "<set-?>", "Leu/thesimplecloud/api/property/IProperty;", "", "", "synchronizedIngameCommandsProperty", "getSynchronizedIngameCommandsProperty", "()Leu/thesimplecloud/api/property/IProperty;", "addServiceToProxy", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "getCloudPlayerManagerClass", "Lkotlin/reflect/KClass;", "Leu/thesimplecloud/api/player/ICloudPlayerManager;", "onDisable", "onEnable", "onLoad", "registerFallbackService", "registerService", "name", "uniqueId", "Ljava/util/UUID;", "socketAddress", "Ljava/net/InetSocketAddress;", "removeServiceFromProxy", "runOfflinePlayerChecker", "shutdown", "synchronizeOnlineCountTask", "Companion", "simplecloud-plugin"})
public final class CloudBungeePlugin
extends Plugin
implements ICloudProxyPlugin {
    @NotNull
    private final LobbyConnector lobbyConnector = new LobbyConnector();
    private volatile IProperty<String[]> synchronizedIngameCommandsProperty;
    public static CloudBungeePlugin instance;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final LobbyConnector getLobbyConnector() {
        return this.lobbyConnector;
    }

    @NotNull
    public final IProperty<String[]> getSynchronizedIngameCommandsProperty() {
        IProperty<String[]> iProperty = this.synchronizedIngameCommandsProperty;
        if (iProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"synchronizedIngameCommandsProperty");
        }
        return iProperty;
    }

    @Override
    public void shutdown() {
        ProxyServer.getInstance().stop();
    }

    @Override
    public void addServiceToProxy(@NotNull ICloudService cloudService) {
        ICloudServiceGroup cloudServiceGroup;
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        if (ProxyServer.getInstance().getServerInfo(cloudService.getName()) != null) {
            throw (Throwable)new IllegalArgumentException("Service is already registered!");
        }
        if (cloudService.getServiceType().isProxy()) {
            return;
        }
        ICloudServiceGroup iCloudServiceGroup = cloudServiceGroup = cloudService.getServiceGroup();
        if (iCloudServiceGroup == null) {
            throw new NullPointerException("null cannot be cast to non-null type eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup");
        }
        if (((ICloudServerGroup)iCloudServiceGroup).getHiddenAtProxyGroups().contains(CloudPlugin.Companion.getInstance().getGroupName())) {
            return;
        }
        String string = "Registered service " + cloudService.getName();
        boolean bl = false;
        System.out.println((Object)string);
        InetSocketAddress socketAddress = new InetSocketAddress(cloudService.getHost(), cloudService.getPort());
        this.registerService(cloudService.getName(), cloudService.getUniqueId(), socketAddress);
    }

    private final void registerFallbackService() {
        UUID uUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.fromString(\"0000000\u2026-0000-0000-000000000000\")");
        this.registerService("fallback", uUID, new InetSocketAddress("127.0.0.1", 0));
    }

    private final void registerService(String name, UUID uniqueId, InetSocketAddress socketAddress) {
        ServerInfo info = ProxyServer.getInstance().constructServerInfo(name, socketAddress, uniqueId.toString(), false);
        ProxyServer proxyServer = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"ProxyServer.getInstance()");
        Map map = proxyServer.getServers();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"ProxyServer.getInstance().servers");
        map.put(name, info);
    }

    @Override
    public void removeServiceFromProxy(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter((Object)cloudService, (String)"cloudService");
        ProxyServer proxyServer = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"ProxyServer.getInstance()");
        proxyServer.getServers().remove(cloudService.getName());
    }

    public void onLoad() {
        ProxyServer proxyServer = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"ProxyServer.getInstance()");
        proxyServer.setReconnectHandler((ReconnectHandler)new ReconnectHandlerImpl());
        new CloudPlugin(this);
        ICommunicationPromise synchronizedObjectPromise = CloudAPI.Companion.getInstance().getGlobalPropertyHolder().requestProperty("simplecloud-ingamecommands");
        synchronizedObjectPromise.addResultListener((Function1)new Function1<IProperty<String[]>, Unit>(this){
            final /* synthetic */ CloudBungeePlugin this$0;

            public final void invoke(@NotNull IProperty<String[]> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                CloudBungeePlugin.access$setSynchronizedIngameCommandsProperty$p(this.this$0, it);
            }
            {
                this.this$0 = cloudBungeePlugin;
                super(1);
            }
        }).throwFailure();
    }

    /*
     * WARNING - void declaration
     */
    public void onEnable() {
        void $this$filterTo$iv$iv;
        ProxyServer proxyServer = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"ProxyServer.getInstance()");
        ConfigurationAdapter configurationAdapter = proxyServer.getConfigurationAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)configurationAdapter, (String)"ProxyServer.getInstance().configurationAdapter");
        configurationAdapter.getServers().clear();
        ProxyServer proxyServer2 = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer2, (String)"ProxyServer.getInstance()");
        proxyServer2.getServers().clear();
        ProxyServer proxyServer3 = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer3, (String)"ProxyServer.getInstance()");
        ConfigurationAdapter configurationAdapter2 = proxyServer3.getConfigurationAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)configurationAdapter2, (String)"ProxyServer.getInstance().configurationAdapter");
        Iterator iterator = configurationAdapter2.getListeners().iterator();
        while (iterator.hasNext()) {
            ListenerInfo info;
            ListenerInfo listenerInfo = info = (ListenerInfo)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)listenerInfo, (String)"info");
            listenerInfo.getServerPriority().clear();
        }
        this.registerFallbackService();
        CloudPlugin.Companion.getInstance().onEnable();
        Iterable $this$filter$iv = CloudAPI.Companion.getInstance().getCloudServiceManager().getAllCachedObjects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudService it = (ICloudService)element$iv;
            boolean bl = false;
            this.addServiceToProxy(it);
        }
        CloudAPI.Companion.getInstance().getEventManager().registerListener(CloudPlugin.Companion.getInstance(), new CloudListener());
        ProxyServer proxyServer4 = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer4, (String)"ProxyServer.getInstance()");
        proxyServer4.getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener());
        ProxyServer proxyServer5 = ProxyServer.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer5, (String)"ProxyServer.getInstance()");
        proxyServer5.getPluginManager().registerListener((Plugin)this, (Listener)new IngameCommandListener());
        this.synchronizeOnlineCountTask();
        this.runOfflinePlayerChecker();
    }

    public void onDisable() {
        CloudPlugin.Companion.getInstance().onDisable();
    }

    private final void runOfflinePlayerChecker() {
        ProxyServer proxyServer = this.getProxy();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"proxy");
        proxyServer.getScheduler().schedule((Plugin)this, new Runnable(this){
            final /* synthetic */ CloudBungeePlugin this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$filterTo$iv$iv;
                List<T> playersOnThisService = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
                Iterable $this$filter$iv = playersOnThisService;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ICloudPlayer it = (ICloudPlayer)element$iv$iv;
                    boolean bl = false;
                    if (!(this.this$0.getProxy().getPlayer(it.getUniqueId()) == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List playersOffline = (List)destination$iv$iv;
                Iterable $this$forEach$iv = playersOffline;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    ICloudPlayer it = (ICloudPlayer)element$iv;
                    boolean bl = false;
                    ProxyEventHandler.INSTANCE.handleDisconnect(it.getUniqueId(), it.getName());
                }
            }
            {
                this.this$0 = cloudBungeePlugin;
            }
        }, 2L, 30L, TimeUnit.SECONDS);
    }

    private final void synchronizeOnlineCountTask() {
        ProxyServer proxyServer = this.getProxy();
        Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"proxy");
        proxyServer.getScheduler().schedule((Plugin)this, new Runnable(this){
            final /* synthetic */ CloudBungeePlugin this$0;

            public final void run() {
                ICloudService service = CloudPlugin.Companion.getInstance().thisService();
                int n = service.getOnlineCount();
                ProxyServer proxyServer = this.this$0.getProxy();
                Intrinsics.checkNotNullExpressionValue((Object)proxyServer, (String)"proxy");
                if (n != proxyServer.getOnlineCount()) {
                    ProxyServer proxyServer2 = this.this$0.getProxy();
                    Intrinsics.checkNotNullExpressionValue((Object)proxyServer2, (String)"proxy");
                    service.setOnlineCount(proxyServer2.getOnlineCount());
                    service.update();
                }
            }
            {
                this.this$0 = cloudBungeePlugin;
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public KClass<? extends ICloudPlayerManager> getCloudPlayerManagerClass() {
        return Reflection.getOrCreateKotlinClass(CloudPlayerManagerBungee.class);
    }

    public CloudBungeePlugin() {
        instance = this;
    }

    static {
        Companion = new Companion(null);
    }

    @Override
    public void onBeforeFirstUpdate() {
        ICloudProxyPlugin.DefaultImpls.onBeforeFirstUpdate(this);
    }

    public static final /* synthetic */ IProperty access$getSynchronizedIngameCommandsProperty$p(CloudBungeePlugin $this) {
        IProperty<String[]> iProperty = $this.synchronizedIngameCommandsProperty;
        if (iProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"synchronizedIngameCommandsProperty");
        }
        return iProperty;
    }

    public static final /* synthetic */ void access$setSynchronizedIngameCommandsProperty$p(CloudBungeePlugin $this, IProperty iProperty) {
        $this.synchronizedIngameCommandsProperty = iProperty;
    }

    @NotNull
    public static final CloudBungeePlugin getInstance() {
        Companion companion = Companion;
        CloudBungeePlugin cloudBungeePlugin = instance;
        if (cloudBungeePlugin == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
        }
        return cloudBungeePlugin;
    }

    public static final void setInstance(@NotNull CloudBungeePlugin cloudBungeePlugin) {
        Companion companion = Companion;
        instance = cloudBungeePlugin;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Leu/thesimplecloud/plugin/proxy/bungee/CloudBungeePlugin$Companion;", "", "()V", "instance", "Leu/thesimplecloud/plugin/proxy/bungee/CloudBungeePlugin;", "getInstance$annotations", "getInstance", "()Leu/thesimplecloud/plugin/proxy/bungee/CloudBungeePlugin;", "setInstance", "(Leu/thesimplecloud/plugin/proxy/bungee/CloudBungeePlugin;)V", "simplecloud-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final CloudBungeePlugin getInstance() {
            CloudBungeePlugin cloudBungeePlugin = instance;
            if (cloudBungeePlugin == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            }
            return cloudBungeePlugin;
        }

        public final void setInstance(@NotNull CloudBungeePlugin cloudBungeePlugin) {
            Intrinsics.checkNotNullParameter((Object)cloudBungeePlugin, (String)"<set-?>");
            instance = cloudBungeePlugin;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

