/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.bungee.listener;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.DefaultPlayerAddress;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import eu.thesimplecloud.plugin.proxy.CancelType;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.bungee.CloudBungeePlugin;
import eu.thesimplecloud.plugin.proxy.bungee.LobbyConnector;
import eu.thesimplecloud.plugin.proxy.bungee.text.CloudTextBuilder;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Leu/thesimplecloud/plugin/proxy/bungee/listener/BungeeListener;", "Lnet/md_5/bungee/api/plugin/Listener;", "()V", "getNoFallbackServerFoundMessage", "", "on", "", "event", "Lnet/md_5/bungee/api/event/LoginEvent;", "Lnet/md_5/bungee/api/event/PlayerDisconnectEvent;", "Lnet/md_5/bungee/api/event/PostLoginEvent;", "Lnet/md_5/bungee/api/event/ServerConnectEvent;", "Lnet/md_5/bungee/api/event/ServerConnectedEvent;", "Lnet/md_5/bungee/api/event/ServerKickEvent;", "simplecloud-plugin"})
public final class BungeeListener
implements Listener {
    @EventHandler(priority=-32)
    public final void on(@NotNull LoginEvent event) {
        PendingConnection connection;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        PendingConnection pendingConnection = connection = event.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)pendingConnection, (String)"connection");
        InetSocketAddress inetSocketAddress = pendingConnection.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"connection.address");
        String string = inetSocketAddress.getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.address.hostString");
        InetSocketAddress inetSocketAddress2 = connection.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress2, (String)"connection.address");
        DefaultPlayerAddress playerAddress = new DefaultPlayerAddress(string, inetSocketAddress2.getPort());
        String string2 = connection.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.name");
        UUID uUID = connection.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"connection.uniqueId");
        DefaultPlayerConnection playerConnection = new DefaultPlayerConnection(playerAddress, string2, uUID, connection.isOnlineMode(), connection.getVersion());
        ProxyEventHandler.INSTANCE.handleLogin(playerConnection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(event){
            final /* synthetic */ LoginEvent $event;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$event.setCancelled(true);
                this.$event.setCancelReason(new BaseComponent[]{(BaseComponent)new CloudTextBuilder().build(new CloudText(it))});
            }
            {
                this.$event = loginEvent;
                super(1);
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull PostLoginEvent event) {
        ProxiedPlayer proxiedPlayer;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer2, (String)"proxiedPlayer");
        proxiedPlayer2.setReconnectServer((ServerInfo)null);
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = proxiedPlayer.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proxiedPlayer.name");
        ProxyEventHandler.INSTANCE.handlePostLogin(uUID, string);
        if (LobbyConnector.getLobbyServer$default(CloudBungeePlugin.Companion.getInstance().getLobbyConnector(), proxiedPlayer, null, 2, null) == null) {
            event.getPlayer().disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage())));
            return;
        }
    }

    @EventHandler(priority=64)
    public final void on(@NotNull PlayerDisconnectEvent event) {
        ProxiedPlayer proxiedPlayer;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer2, (String)"proxiedPlayer");
        UUID uUID = proxiedPlayer2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = proxiedPlayer.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proxiedPlayer.name");
        ProxyEventHandler.INSTANCE.handleDisconnect(uUID, string);
    }

    @EventHandler
    public final void on(@NotNull ServerConnectEvent event) {
        ServerInfo target;
        ServerInfo serverInfo;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        ServerInfo serverInfo2 = event.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo2, (String)"event.target");
        if (Intrinsics.areEqual((Object)serverInfo2.getName(), (Object)"fallback")) {
            LobbyConnector lobbyConnector = CloudBungeePlugin.Companion.getInstance().getLobbyConnector();
            ProxiedPlayer proxiedPlayer2 = proxiedPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer2, (String)"proxiedPlayer");
            serverInfo = LobbyConnector.getLobbyServer$default(lobbyConnector, proxiedPlayer2, null, 2, null);
        } else {
            serverInfo = target = event.getTarget();
        }
        if (target == null) {
            event.getPlayer().disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage())));
            return;
        }
        event.setTarget(target);
        ProxiedPlayer proxiedPlayer3 = proxiedPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer3, (String)"proxiedPlayer");
        Server server = proxiedPlayer3.getServer();
        String name = server != null && (server = server.getInfo()) != null ? server.getName() : null;
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name");
        ProxyEventHandler.INSTANCE.handleServerPreConnect(uUID, name, string, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(proxiedPlayer, event){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;
            final /* synthetic */ ServerConnectEvent $event;

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$proxiedPlayer.sendMessage((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
                } else {
                    this.$proxiedPlayer.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
                }
                this.$event.setCancelled(true);
            }
            {
                this.$proxiedPlayer = proxiedPlayer;
                this.$event = serverConnectEvent;
                super(2);
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull ServerConnectedEvent event) {
        ProxiedPlayer proxiedPlayer;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer2, (String)"proxiedPlayer");
        UUID uUID = proxiedPlayer2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        Server server = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"event.server");
        ServerInfo serverInfo = server.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"event.server.info");
        String string = serverInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.server.info.name");
        ProxyEventHandler.INSTANCE.handleServerConnect(uUID, string, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(proxiedPlayer){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$proxiedPlayer.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText("\u00a7cService does not exist.")));
            }
            {
                this.$proxiedPlayer = proxiedPlayer;
                super(1);
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull ServerKickEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        BaseComponent[] baseComponentArray = event.getKickReasonComponent();
        Intrinsics.checkNotNullExpressionValue((Object)baseComponentArray, (String)"event.kickReasonComponent");
        BaseComponent[] baseComponentArray2 = baseComponentArray;
        boolean bl = false;
        if (baseComponentArray2.length == 0) {
            string = "";
        } else {
            String string2 = event.getKickReasonComponent()[0].toLegacyText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.kickReasonComponent[0].toLegacyText()");
        }
        String kickReasonString = string;
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        ServerInfo serverInfo = event.getKickedFrom();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"event.kickedFrom");
        String kickedServerName = serverInfo.getName();
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer2, (String)"proxiedPlayer");
        ICloudPlayer iCloudPlayer = PlayerExtensionsKt.getCloudPlayer(proxiedPlayer2);
        String string3 = kickedServerName;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"kickedServerName");
        ProxyEventHandler.INSTANCE.handleServerKick(iCloudPlayer, kickReasonString, string3, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(proxiedPlayer){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$proxiedPlayer.sendMessage((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
                } else {
                    this.$proxiedPlayer.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(message)));
                }
            }
            {
                this.$proxiedPlayer = proxiedPlayer;
                super(2);
            }
        }));
        ServerInfo fallback = CloudBungeePlugin.Companion.getInstance().getLobbyConnector().getLobbyServer(proxiedPlayer, CollectionsKt.listOf((Object)kickedServerName));
        if (fallback == null) {
            proxiedPlayer.disconnect((BaseComponent)new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage())));
            return;
        }
        BaseComponent[] baseComponentArray3 = event.getKickReasonComponent();
        proxiedPlayer.sendMessage(Arrays.copyOf(baseComponentArray3, baseComponentArray3.length));
        event.setCancelServer(fallback);
        event.setCancelled(true);
    }

    private final String getNoFallbackServerFoundMessage() {
        return CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
    }
}

