/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.velocity.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.config.ProxyConfig;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.DefaultPlayerAddress;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import eu.thesimplecloud.plugin.proxy.CancelType;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.velocity.CloudVelocityPlugin;
import eu.thesimplecloud.plugin.proxy.velocity.LobbyConnector;
import eu.thesimplecloud.plugin.proxy.velocity.text.CloudTextBuilder;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/plugin/proxy/velocity/listener/VelocityListener;", "", "plugin", "Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "(Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;)V", "getPlugin", "()Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "getNoFallbackServerFoundMessage", "", "handle", "", "event", "Lcom/velocitypowered/api/event/connection/DisconnectEvent;", "Lcom/velocitypowered/api/event/connection/LoginEvent;", "Lcom/velocitypowered/api/event/connection/PostLoginEvent;", "Lcom/velocitypowered/api/event/player/KickedFromServerEvent;", "Lcom/velocitypowered/api/event/player/ServerConnectedEvent;", "Lcom/velocitypowered/api/event/player/ServerPreConnectEvent;", "simplecloud-plugin"})
public final class VelocityListener {
    @NotNull
    private final CloudVelocityPlugin plugin;

    @Subscribe(order=PostOrder.FIRST)
    public final void handle(@NotNull LoginEvent event) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
        InetSocketAddress inetSocketAddress = player2.getRemoteAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"player.remoteAddress");
        String string = inetSocketAddress.getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.remoteAddress.hostString");
        InetSocketAddress inetSocketAddress2 = player.getRemoteAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress2, (String)"player.remoteAddress");
        DefaultPlayerAddress playerAddress = new DefaultPlayerAddress(string, inetSocketAddress2.getPort());
        String string2 = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"player.username");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        ProxyConfig proxyConfig = this.plugin.getProxyServer().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)proxyConfig, (String)"plugin.proxyServer.configuration");
        boolean bl = proxyConfig.isOnlineMode();
        ProtocolVersion protocolVersion = player.getProtocolVersion();
        Intrinsics.checkNotNullExpressionValue((Object)protocolVersion, (String)"player.protocolVersion");
        DefaultPlayerConnection playerConnection = new DefaultPlayerConnection(playerAddress, string2, uUID, bl, protocolVersion.getProtocol());
        ProxyEventHandler.INSTANCE.handleLogin(playerConnection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(event){
            final /* synthetic */ LoginEvent $event;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$event.setResult(ResultedEvent.ComponentResult.denied((Component)new CloudTextBuilder().build(new CloudText(it))));
            }
            {
                this.$event = loginEvent;
                super(1);
            }
        }));
    }

    @Subscribe
    public final void handle(@NotNull PostLoginEvent event) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.username");
        ProxyEventHandler.INSTANCE.handlePostLogin(uUID, string);
        if (LobbyConnector.getLobbyServer$default(this.plugin.getLobbyConnector(), player, null, 2, null) == null) {
            event.getPlayer().disconnect(new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage())));
        }
    }

    @Subscribe
    public final void handle(@NotNull DisconnectEvent event) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.username");
        ProxyEventHandler.INSTANCE.handleDisconnect(uUID, string);
    }

    @Subscribe
    public final void handle(@NotNull ServerPreConnectEvent event) {
        Optional currentServer;
        RegisteredServer target;
        RegisteredServer registeredServer;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPreConnectEvent.ServerResult serverResult = event.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)serverResult, (String)"event.result");
        if (!serverResult.isAllowed()) {
            return;
        }
        Player player = event.getPlayer();
        RegisteredServer registeredServer2 = event.getOriginalServer();
        Intrinsics.checkNotNullExpressionValue((Object)registeredServer2, (String)"event.originalServer");
        ServerInfo serverInfo = registeredServer2.getServerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"event.originalServer.serverInfo");
        if (Intrinsics.areEqual((Object)serverInfo.getName(), (Object)"fallback")) {
            LobbyConnector lobbyConnector = this.plugin.getLobbyConnector();
            Player player2 = player;
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
            registeredServer = LobbyConnector.getLobbyServer$default(lobbyConnector, player2, null, 2, null);
        } else {
            registeredServer = target = event.getOriginalServer();
        }
        if (target == null) {
            event.getPlayer().disconnect(new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage())));
            return;
        }
        ServerInfo serverInfo2 = target.getServerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo2, (String)"target.serverInfo");
        String serverNameTo = serverInfo2.getName();
        event.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)this.plugin.getProxyServer().getServer(serverNameTo).orElse(null)));
        String serverNameFrom = null;
        Player player3 = player;
        Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"player");
        Optional optional = currentServer = player3.getCurrentServer();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"currentServer");
        if (optional.isPresent()) {
            Object t = currentServer.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"currentServer.get()");
            ServerInfo serverInfo3 = ((ServerConnection)t).getServerInfo();
            Intrinsics.checkNotNullExpressionValue((Object)serverInfo3, (String)"currentServer.get().serverInfo");
            serverNameFrom = serverInfo3.getName();
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = serverNameTo;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serverNameTo");
        ProxyEventHandler.INSTANCE.handleServerPreConnect(uUID, serverNameFrom, string, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(player, event){
            final /* synthetic */ Player $player;
            final /* synthetic */ ServerPreConnectEvent $event;

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$player.sendMessage(new CloudTextBuilder().build(new CloudText(message)));
                } else {
                    this.$player.disconnect(new CloudTextBuilder().build(new CloudText(message)));
                }
                this.$event.setResult(ServerPreConnectEvent.ServerResult.denied());
            }
            {
                this.$player = player;
                this.$event = serverPreConnectEvent;
                super(2);
            }
        }));
    }

    @Subscribe
    public final void handle(@NotNull ServerConnectedEvent event) {
        Player player;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player2 = player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        RegisteredServer registeredServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)registeredServer, (String)"event.server");
        ServerInfo serverInfo = registeredServer.getServerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"event.server.serverInfo");
        String string = serverInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.server.serverInfo.name");
        ProxyEventHandler.INSTANCE.handleServerConnect(uUID, string, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(player){
            final /* synthetic */ Player $player;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$player.disconnect(new CloudTextBuilder().build(new CloudText("\u00a7cService does not exist.")));
            }
            {
                this.$player = player;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Subscribe
    public final void handle(@NotNull KickedFromServerEvent event) {
        void kickReasonComponent;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String kickReasonString = null;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = event.getServerKickReason();
        Optional optional = (Optional)kickReasonComponent.element;
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"kickReasonComponent");
        if (!optional.isPresent()) {
            kickReasonString = "";
            kickReasonComponent.element = Optional.of(new CloudTextBuilder().build(new CloudText("")));
        } else {
            Object t = ((Optional)kickReasonComponent.element).get();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.kyori.adventure.text.TextComponent");
            }
            String string = ((TextComponent)t).content();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(kickReasonComponent.get\u2026 TextComponent).content()");
            kickReasonString = string;
        }
        Player player = event.getPlayer();
        RegisteredServer registeredServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)registeredServer, (String)"event.server");
        ServerInfo serverInfo = registeredServer.getServerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)serverInfo, (String)"event.server.serverInfo");
        String kickedServerName = serverInfo.getName();
        Player player2 = player;
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"player");
        ICloudPlayer iCloudPlayer = PlayerExtensionsKt.getCloudPlayer(player2);
        String string = kickedServerName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kickedServerName");
        ProxyEventHandler.INSTANCE.handleServerKick(iCloudPlayer, kickReasonString, string, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(player, event, (Ref.ObjectRef)kickReasonComponent){
            final /* synthetic */ Player $player;
            final /* synthetic */ KickedFromServerEvent $event;
            final /* synthetic */ Ref.ObjectRef $kickReasonComponent;

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$player.sendMessage(new CloudTextBuilder().build(new CloudText(message)));
                } else {
                    this.$event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)((Component)((Optional)this.$kickReasonComponent.element).get())));
                }
            }
            {
                this.$player = player;
                this.$event = kickedFromServerEvent;
                this.$kickReasonComponent = objectRef;
                super(2);
            }
        }));
        RegisteredServer fallback = this.plugin.getLobbyConnector().getLobbyServer(player, CollectionsKt.listOf((Object)kickedServerName));
        if (fallback == null) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)new CloudTextBuilder().build(new CloudText(this.getNoFallbackServerFoundMessage()))));
            return;
        }
        event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)fallback));
    }

    private final String getNoFallbackServerFoundMessage() {
        return CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
    }

    @NotNull
    public final CloudVelocityPlugin getPlugin() {
        return this.plugin;
    }

    public VelocityListener(@NotNull CloudVelocityPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }
}

