/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.server;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.plugin.impl.player.CloudPlayerManagerSpigot;
import eu.thesimplecloud.plugin.listener.CloudListener;
import eu.thesimplecloud.plugin.server.ICloudServerPlugin;
import eu.thesimplecloud.plugin.server.listener.ReloadCommandBlocker;
import eu.thesimplecloud.plugin.server.listener.SpigotListener;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Leu/thesimplecloud/plugin/server/CloudSpigotPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Leu/thesimplecloud/plugin/server/ICloudServerPlugin;", "()V", "getCloudPlayerManagerClass", "Lkotlin/reflect/KClass;", "Leu/thesimplecloud/api/player/ICloudPlayerManager;", "onBeforeFirstUpdate", "", "onDisable", "onEnable", "onLoad", "shutdown", "synchronizeOnlineCountTask", "Companion", "simplecloud-plugin"})
public final class CloudSpigotPlugin
extends JavaPlugin
implements ICloudServerPlugin {
    public static CloudSpigotPlugin instance;
    @NotNull
    public static final Companion Companion;

    public void onLoad() {
        new CloudPlugin(this);
    }

    public void onEnable() {
        CloudPlugin.Companion.getInstance().onEnable();
        CloudAPI.Companion.getInstance().getEventManager().registerListener(CloudPlugin.Companion.getInstance(), new CloudListener());
        Server server = this.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"server");
        server.getPluginManager().registerEvents((Listener)new SpigotListener(), (Plugin)this);
        Server server2 = this.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)server2, (String)"server");
        server2.getPluginManager().registerEvents((Listener)new ReloadCommandBlocker(), (Plugin)this);
        this.synchronizeOnlineCountTask();
    }

    @Override
    public void onBeforeFirstUpdate() {
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"Bukkit.getServer()");
        String string = server.getMotd();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Bukkit.getServer().motd");
        String motd = string;
        CloudPlugin.Companion.getInstance().thisService().setMOTD(motd);
    }

    public void onDisable() {
        CloudPlugin.Companion.getInstance().onDisable();
    }

    @Override
    public void shutdown() {
        Bukkit.getServer().shutdown();
    }

    @Override
    @NotNull
    public KClass<? extends ICloudPlayerManager> getCloudPlayerManagerClass() {
        return Reflection.getOrCreateKotlinClass(CloudPlayerManagerSpigot.class);
    }

    private final void synchronizeOnlineCountTask() {
        new BukkitRunnable(this){
            final /* synthetic */ CloudSpigotPlugin this$0;

            public void run() {
                ICloudService service = CloudPlugin.Companion.getInstance().thisService();
                int n = service.getOnlineCount();
                Server server = this.this$0.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)server, (String)"server");
                if (n != server.getOnlinePlayers().size()) {
                    Server server2 = this.this$0.getServer();
                    Intrinsics.checkNotNullExpressionValue((Object)server2, (String)"server");
                    service.setOnlineCount(server2.getOnlinePlayers().size());
                    service.update();
                }
            }
            {
                this.this$0 = this$0;
            }
        }.runTaskTimerAsynchronously((Plugin)this, 600L, 600L);
    }

    public CloudSpigotPlugin() {
        instance = this;
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final CloudSpigotPlugin getInstance() {
        Companion companion = Companion;
        CloudSpigotPlugin cloudSpigotPlugin = instance;
        if (cloudSpigotPlugin == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
        }
        return cloudSpigotPlugin;
    }

    public static final void setInstance(@NotNull CloudSpigotPlugin cloudSpigotPlugin) {
        Companion companion = Companion;
        instance = cloudSpigotPlugin;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Leu/thesimplecloud/plugin/server/CloudSpigotPlugin$Companion;", "", "()V", "instance", "Leu/thesimplecloud/plugin/server/CloudSpigotPlugin;", "getInstance$annotations", "getInstance", "()Leu/thesimplecloud/plugin/server/CloudSpigotPlugin;", "setInstance", "(Leu/thesimplecloud/plugin/server/CloudSpigotPlugin;)V", "simplecloud-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final CloudSpigotPlugin getInstance() {
            CloudSpigotPlugin cloudSpigotPlugin = instance;
            if (cloudSpigotPlugin == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            }
            return cloudSpigotPlugin;
        }

        public final void setInstance(@NotNull CloudSpigotPlugin cloudSpigotPlugin) {
            Intrinsics.checkNotNullParameter((Object)cloudSpigotPlugin, (String)"<set-?>");
            instance = cloudSpigotPlugin;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

