/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.server.listener;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.net.InetAddress;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nH\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/plugin/server/listener/SpigotListener;", "Lorg/bukkit/event/Listener;", "()V", "NOT_REGISTERED", "", "UNKNOWN_ADRESS", "on", "", "event", "Lorg/bukkit/event/player/PlayerKickEvent;", "Lorg/bukkit/event/player/PlayerLoginEvent;", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerDisconnected", "player", "Lorg/bukkit/entity/Player;", "updateCurrentOnlineCountTo", "count", "", "simplecloud-plugin"})
public final class SpigotListener
implements Listener {
    private final String UNKNOWN_ADRESS;
    private final String NOT_REGISTERED;

    @EventHandler
    public final void on(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        InetAddress inetAddress = event.getRealAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"event.realAddress");
        String hostAddress = inetAddress.getHostAddress();
        if (Intrinsics.areEqual((Object)hostAddress, (Object)"127.0.0.1") ^ true) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = CloudAPI.Companion.getInstance().getWrapperManager().getAllCachedObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IWrapperInfo it = (IWrapperInfo)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getHost(), (Object)hostAddress)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.UNKNOWN_ADRESS);
                return;
            }
        }
        ICloudPlayerManager iCloudPlayerManager = CloudAPI.Companion.getInstance().getCloudPlayerManager();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        if (iCloudPlayerManager.getCachedCloudPlayer(uUID) == null) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.NOT_REGISTERED);
        }
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateCurrentOnlineCountTo(Bukkit.getOnlinePlayers().size());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void on(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onPlayerDisconnected(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void on(@NotNull PlayerKickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onPlayerDisconnected(player);
    }

    private final void onPlayerDisconnected(Player player) {
        ICloudPlayerManager playerManager = CloudAPI.Companion.getInstance().getCloudPlayerManager();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        ICloudPlayer cloudPlayer = playerManager.getCachedCloudPlayer(uUID);
        if (cloudPlayer != null && !cloudPlayer.isUpdatesEnabled()) {
            ICacheList.DefaultImpls.delete$default(playerManager, cloudPlayer, false, 2, null);
        }
        this.updateCurrentOnlineCountTo(Bukkit.getOnlinePlayers().size() - 1);
    }

    private final void updateCurrentOnlineCountTo(int count) {
        ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();
        thisService.setOnlineCount(count);
        thisService.update();
    }

    public SpigotListener() {
        this.UNKNOWN_ADRESS = "\u00a7cYou are connected from an unknown address!";
        this.NOT_REGISTERED = "\u00a7cYou are not registered on the network!";
    }
}

