/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.language;

import eu.thesimplecloud.api.language.LanguagePlaceholder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001f\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000e\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/api/language/LanguageProperty;", "", "property", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getProperty", "getAllPlaceHolders", "", "Leu/thesimplecloud/api/language/LanguagePlaceholder;", "getReplacedMessage", "replacements", "", "([Ljava/lang/String;)Ljava/lang/String;", "simplecloud-api"})
public final class LanguageProperty {
    @NotNull
    private final String property;
    @NotNull
    private final String message;

    public LanguageProperty(@NotNull String property, @NotNull String message) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(message, "message");
        this.property = property;
        this.message = message;
    }

    @NotNull
    public final String getProperty() {
        return this.property;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final List<LanguagePlaceholder> getAllPlaceHolders() {
        String[] stringArray = new String[]{"%"};
        List percentParts = StringsKt.split$default((CharSequence)this.message, stringArray, false, 0, 6, null);
        if (CollectionsKt.getLastIndex(percentParts) % 2 != 0) {
            throw new IllegalArgumentException("Invalid message format for property " + this.property);
        }
        List returnList = new ArrayList();
        int i = 1;
        int n = CollectionsKt.getLastIndex(percentParts);
        int n2 = ProgressionUtilKt.getProgressionLastElement(1, n, 2);
        if (i <= n2) {
            while (true) {
                returnList.add(new LanguagePlaceholder((String)percentParts.get(i)));
                if (i == n2) break;
                i += 2;
            }
        }
        return returnList;
    }

    @NotNull
    public final String getReplacedMessage(String ... replacements) {
        Intrinsics.checkNotNullParameter(replacements, "replacements");
        List<LanguagePlaceholder> allPlaceHolders = this.getAllPlaceHolders();
        String message = this.message;
        Iterator<String> replacementsIterator = ArrayIteratorKt.iterator(replacements);
        for (LanguagePlaceholder placeHolder : allPlaceHolders) {
            message = StringsKt.replace$default(message, placeHolder.getStringToReplace(), replacementsIterator.next(), false, 4, null);
        }
        return message;
    }
}

