/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.location;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.location.TemplateLocation;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Leu/thesimplecloud/api/location/GroupLocation;", "Leu/thesimplecloud/api/location/SimpleLocation;", "serviceGroupName", "", "worldName", "x", "", "y", "z", "yaw", "", "pitch", "(Ljava/lang/String;Ljava/lang/String;DDDFF)V", "add", "equals", "", "other", "", "getGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "hashCode", "", "setWorldName", "toTemplateLocation", "Leu/thesimplecloud/api/location/TemplateLocation;", "simplecloud-api"})
public class GroupLocation
extends SimpleLocation {
    @NotNull
    private final String serviceGroupName;

    public GroupLocation(@NotNull String serviceGroupName, @NotNull String worldName, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter(serviceGroupName, "serviceGroupName");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        super(worldName, x, y, z, yaw, pitch);
        this.serviceGroupName = serviceGroupName;
    }

    @Nullable
    public final ICloudServiceGroup getGroup() {
        return CloudAPI.Companion.getInstance().getCloudServiceGroupManager().getServiceGroupByName(this.serviceGroupName);
    }

    @Override
    @NotNull
    public GroupLocation add(double x, double y, double z) {
        return new GroupLocation(this.serviceGroupName, this.getWorldName(), this.getX() + x, this.getY() + y, this.getZ() + z, this.getYaw(), this.getPitch());
    }

    @Override
    @NotNull
    public GroupLocation setWorldName(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        return new GroupLocation(this.serviceGroupName, worldName, this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @NotNull
    public final TemplateLocation toTemplateLocation() {
        ICloudServiceGroup iCloudServiceGroup = this.getGroup();
        if (iCloudServiceGroup == null) {
            throw new IllegalStateException("Group " + this.serviceGroupName + " cannot be found");
        }
        ICloudServiceGroup group = iCloudServiceGroup;
        return new TemplateLocation(group.getTemplateName(), this.getWorldName(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupLocation)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual(this.serviceGroupName, ((GroupLocation)other).serviceGroupName);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.serviceGroupName.hashCode();
        return result2;
    }
}

