/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.player;

import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerUpdater;
import eu.thesimplecloud.api.player.IOfflineCloudPlayer;
import eu.thesimplecloud.api.player.SimpleCloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.player.text.CloudText;
import eu.thesimplecloud.api.player.text.CloudTextBuilder;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromiseExtensionKt;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0005H&J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0014\u001a\u00020\rH&J$\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000f0\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J$\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000f0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005H&J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00052\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00052\u0006\u0010\u0014\u001a\u00020\rH&J$\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u000f0\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J$\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u000f0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00052\u0006\u0010\b\u001a\u00020\tH&J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005H&J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\rH&J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\rH&J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010+\u001a\u00020\u001fH&J\u0018\u0010,\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.H&J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u00102\u001a\u00020.H&J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&J1\u00104\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\r062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\r06H&\u00a2\u0006\u0002\u00108J8\u00109\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u001dH&J \u0010?\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010@\u001a\u00020&2\u0006\u0010A\u001a\u00020\rH\u0016J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u001bH&J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DH&\u00a8\u0006E"}, d2={"Leu/thesimplecloud/api/player/ICloudPlayerManager;", "Leu/thesimplecloud/api/cachelist/ICacheList;", "Leu/thesimplecloud/api/player/ICloudPlayerUpdater;", "Leu/thesimplecloud/api/player/ICloudPlayer;", "connectPlayer", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudPlayer", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "forcePlayerCommandExecution", "", "command", "", "getAllOnlinePlayers", "", "Leu/thesimplecloud/api/player/SimpleCloudPlayer;", "getCachedCloudPlayer", "uniqueId", "Ljava/util/UUID;", "name", "getCloudPlayer", "getCloudPlayersByNames", "names", "getCloudPlayersByUniqueIds", "uniqueIds", "getLocationOfPlayer", "Leu/thesimplecloud/api/location/ServiceLocation;", "getNetworkOnlinePlayerCount", "", "getOfflineCloudPlayer", "Leu/thesimplecloud/api/player/IOfflineCloudPlayer;", "getOfflineCloudPlayersByNames", "getOfflineCloudPlayersByUniqueIds", "getPlayerPing", "getPlayersConnectedToService", "getRegisteredPlayerCount", "hasPermission", "", "permission", "kickPlayer", "message", "savePlayerToDatabase", "offlinePlayer", "sendActionbar", "actionbar", "Lnet/kyori/adventure/text/Component;", "sendMessageToPlayer", "cloudText", "Leu/thesimplecloud/api/player/text/CloudText;", "component", "sendPlayerToLobby", "sendTablist", "headers", "", "footers", "(Leu/thesimplecloud/api/player/ICloudPlayer;[Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "stay", "fadeOut", "setUpdates", "update", "serviceName", "teleportPlayer", "location", "Leu/thesimplecloud/api/location/SimpleLocation;", "simplecloud-api"})
public interface ICloudPlayerManager
extends ICacheList<ICloudPlayerUpdater, ICloudPlayer> {
    @Nullable
    public ICloudPlayer getCachedCloudPlayer(@NotNull UUID var1);

    @Nullable
    public ICloudPlayer getCachedCloudPlayer(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<ICloudPlayer> getCloudPlayer(@NotNull UUID var1);

    @NotNull
    public ICommunicationPromise<ICloudPlayer> getCloudPlayer(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer var1, @NotNull CloudText var2);

    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer var1, @NotNull Component var2);

    @NotNull
    public ICommunicationPromise<ConnectionResponse> connectPlayer(@NotNull ICloudPlayer var1, @NotNull ICloudService var2);

    @NotNull
    public ICommunicationPromise<Unit> kickPlayer(@NotNull ICloudPlayer var1, @NotNull String var2);

    public void sendTitle(@NotNull ICloudPlayer var1, @NotNull String var2, @NotNull String var3, int var4, int var5, int var6);

    public void forcePlayerCommandExecution(@NotNull ICloudPlayer var1, @NotNull String var2);

    public void sendActionbar(@NotNull ICloudPlayer var1, @NotNull Component var2);

    public void sendTablist(@NotNull ICloudPlayer var1, @NotNull String[] var2, @NotNull String[] var3);

    public void setUpdates(@NotNull ICloudPlayer var1, boolean var2, @NotNull String var3);

    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer var1, @NotNull SimpleLocation var2);

    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer var1, @NotNull ServiceLocation var2);

    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer var1, @NotNull String var2);

    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocationOfPlayer(@NotNull ICloudPlayer var1);

    @NotNull
    public ICommunicationPromise<Unit> sendPlayerToLobby(@NotNull ICloudPlayer var1);

    @NotNull
    public ICommunicationPromise<Integer> getPlayerPing(@NotNull ICloudPlayer var1);

    @NotNull
    public ICommunicationPromise<IOfflineCloudPlayer> getOfflineCloudPlayer(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<IOfflineCloudPlayer> getOfflineCloudPlayer(@NotNull UUID var1);

    @NotNull
    public ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByNames(@NotNull List<String> var1);

    @NotNull
    public ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByUniqueIds(@NotNull List<UUID> var1);

    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByNames(@NotNull List<String> var1);

    @NotNull
    public ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByUniqueIds(@NotNull List<UUID> var1);

    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getAllOnlinePlayers();

    @NotNull
    public ICommunicationPromise<Integer> getNetworkOnlinePlayerCount();

    @NotNull
    public ICommunicationPromise<Integer> getRegisteredPlayerCount();

    @NotNull
    public ICommunicationPromise<Unit> savePlayerToDatabase(@NotNull IOfflineCloudPlayer var1);

    @NotNull
    public ICommunicationPromise<List<SimpleCloudPlayer>> getPlayersConnectedToService(@NotNull ICloudService var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nICloudPlayerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ICloudPlayerManager.kt\neu/thesimplecloud/api/player/ICloudPlayerManager$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n288#2,2:298\n288#2,2:300\n1549#2:302\n1620#2,3:303\n1549#2:306\n1620#2,3:307\n1549#2:310\n1620#2,3:311\n1549#2:314\n1620#2,3:315\n*S KotlinDebug\n*F\n+ 1 ICloudPlayerManager.kt\neu/thesimplecloud/api/player/ICloudPlayerManager$DefaultImpls\n*L\n44#1:298,2\n50#1:300,2\n244#1:302\n244#1:303,3\n252#1:306\n252#1:307,3\n260#1:310\n260#1:311,3\n268#1:314\n268#1:315,3\n*E\n"})
    public static final class DefaultImpls {
        @Nullable
        public static ICloudPlayer getCachedCloudPlayer(@NotNull ICloudPlayerManager $this, @NotNull UUID uniqueId) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
                Iterable $this$firstOrNull$iv = $this.getAllCachedObjects();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ICloudPlayer it = (ICloudPlayer)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getUniqueId(), uniqueId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public static ICloudPlayer getCachedCloudPlayer(@NotNull ICloudPlayerManager $this, @NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name, "name");
                Iterable $this$firstOrNull$iv = $this.getAllCachedObjects();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ICloudPlayer it = (ICloudPlayer)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals(it.getName(), name, true)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer cloudPlayer, @NotNull CloudText cloudText) {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(cloudText, "cloudText");
            return $this.sendMessageToPlayer(cloudPlayer, new CloudTextBuilder().build(cloudText));
        }

        public static void setUpdates(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer cloudPlayer, boolean update, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(serviceName, "serviceName");
            if (!($this.getCachedCloudPlayer(cloudPlayer.getUniqueId()) == cloudPlayer)) {
                boolean bl = false;
                String string = "CloudPlayer must be in the cache of CloudPlayerManager";
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByNames(@NotNull ICloudPlayerManager $this, @NotNull List<String> names) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(names, "names");
            Iterable $this$map$iv = names;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this.getOfflineCloudPlayer((String)it));
            }
            List playerPromises = (List)destination$iv$iv;
            return CommunicationPromiseExtensionKt.toListPromise(playerPromises);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ICommunicationPromise<List<IOfflineCloudPlayer>> getOfflineCloudPlayersByUniqueIds(@NotNull ICloudPlayerManager $this, @NotNull List<UUID> uniqueIds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(uniqueIds, "uniqueIds");
            Iterable $this$map$iv = uniqueIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this.getOfflineCloudPlayer((UUID)it));
            }
            List playerPromises = (List)destination$iv$iv;
            return CommunicationPromiseExtensionKt.toListPromise(playerPromises);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByNames(@NotNull ICloudPlayerManager $this, @NotNull List<String> names) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(names, "names");
            Iterable $this$map$iv = names;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this.getCloudPlayer((String)it));
            }
            List playerPromises = (List)destination$iv$iv;
            return CommunicationPromiseExtensionKt.toListPromise(playerPromises);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ICommunicationPromise<List<ICloudPlayer>> getCloudPlayersByUniqueIds(@NotNull ICloudPlayerManager $this, @NotNull List<UUID> uniqueIds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(uniqueIds, "uniqueIds");
            Iterable $this$map$iv = uniqueIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UUID uUID = (UUID)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this.getCloudPlayer((UUID)it));
            }
            List playerPromises = (List)destination$iv$iv;
            return CommunicationPromiseExtensionKt.toListPromise(playerPromises);
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer value, boolean fromPacket, boolean isCalledFromDelete) {
            Intrinsics.checkNotNullParameter(value, "value");
            return ICacheList.DefaultImpls.update($this, (ICacheValue)value, fromPacket, isCalledFromDelete);
        }

        @NotNull
        public static ICommunicationPromise<Unit> delete(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer value, boolean fromPacket) {
            Intrinsics.checkNotNullParameter(value, "value");
            return ICacheList.DefaultImpls.delete($this, (ICacheValue)value, fromPacket);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendUpdateToConnection(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer value, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendUpdateToConnection($this, (ICacheValue)value, connection);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendDeleteToConnection(@NotNull ICloudPlayerManager $this, @NotNull ICloudPlayer value, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendDeleteToConnection($this, (ICacheValue)value, connection);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendAllCachedObjectsToConnection(@NotNull ICloudPlayerManager $this, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendAllCachedObjectsToConnection($this, connection);
        }
    }
}

