/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service;

import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ICloudServiceUpdater;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH&J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\u0016"}, d2={"Leu/thesimplecloud/api/service/ICloudServiceManager;", "Leu/thesimplecloud/api/cachelist/ICacheList;", "Leu/thesimplecloud/api/service/ICloudServiceUpdater;", "Leu/thesimplecloud/api/service/ICloudService;", "copyService", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "cloudService", "path", "", "deleteCloudService", "name", "getCloudServiceByName", "getCloudServicesByGroupName", "", "groupName", "getCloudServicesInLobbyStateByGroupName", "getNotFullServicesInLobbyStateByGroupName", "getServicesRunningOnWrapper", "wrapperName", "startService", "stopService", "simplecloud-api"})
public interface ICloudServiceManager
extends ICacheList<ICloudServiceUpdater, ICloudService> {
    public void deleteCloudService(@NotNull String var1);

    @Nullable
    public ICloudService getCloudServiceByName(@NotNull String var1);

    @NotNull
    public List<ICloudService> getCloudServicesByGroupName(@NotNull String var1);

    @NotNull
    public List<ICloudService> getCloudServicesInLobbyStateByGroupName(@NotNull String var1);

    @NotNull
    public List<ICloudService> getNotFullServicesInLobbyStateByGroupName(@NotNull String var1);

    @NotNull
    public List<ICloudService> getServicesRunningOnWrapper(@NotNull String var1);

    @NotNull
    public ICommunicationPromise<Unit> startService(@NotNull ICloudService var1);

    @NotNull
    public ICommunicationPromise<Unit> stopService(@NotNull ICloudService var1);

    @NotNull
    public ICommunicationPromise<Unit> copyService(@NotNull ICloudService var1, @NotNull String var2);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nICloudServiceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ICloudServiceManager.kt\neu/thesimplecloud/api/service/ICloudServiceManager$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n288#2,2:84\n766#2:86\n857#2,2:87\n1045#2:89\n766#2:90\n857#2,2:91\n766#2:93\n857#2,2:94\n766#2:96\n857#2,2:97\n*S KotlinDebug\n*F\n+ 1 ICloudServiceManager.kt\neu/thesimplecloud/api/service/ICloudServiceManager$DefaultImpls\n*L\n39#1:84,2\n45#1:86\n45#1:87,2\n45#1:89\n51#1:90\n51#1:91,2\n57#1:93\n57#1:94,2\n63#1:96\n63#1:97,2\n*E\n"})
    public static final class DefaultImpls {
        @Nullable
        public static ICloudService getCloudServiceByName(@NotNull ICloudServiceManager $this, @NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name, "name");
                Iterable $this$firstOrNull$iv = $this.getAllCachedObjects();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ICloudService it = (ICloudService)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals(it.getName(), name, true)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<ICloudService> getCloudServicesByGroupName(@NotNull ICloudServiceManager $this, @NotNull String groupName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Iterable $this$filter$iv = $this.getAllCachedObjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getGroupName(), groupName, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    ICloudService it = (ICloudService)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getServiceNumber());
                    it = (ICloudService)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getServiceNumber());
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<ICloudService> getCloudServicesInLobbyStateByGroupName(@NotNull ICloudServiceManager $this, @NotNull String groupName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Iterable $this$filter$iv = $this.getCloudServicesByGroupName(groupName);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getState() == ServiceState.VISIBLE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<ICloudService> getNotFullServicesInLobbyStateByGroupName(@NotNull ICloudServiceManager $this, @NotNull String groupName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Iterable $this$filter$iv = $this.getCloudServicesInLobbyStateByGroupName(groupName);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!(it.getOnlineCount() < it.getMaxPlayers())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<ICloudService> getServicesRunningOnWrapper(@NotNull ICloudServiceManager $this, @NotNull String wrapperName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(wrapperName, "wrapperName");
            Iterable $this$filter$iv = $this.getAllCachedObjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ICloudService it = (ICloudService)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getWrapperName(), wrapperName, true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static ICommunicationPromise<Unit> startService(@NotNull ICloudServiceManager $this, @NotNull ICloudService cloudService) {
            Intrinsics.checkNotNullParameter(cloudService, "cloudService");
            throw new UnsupportedOperationException("Can not start a service here.");
        }

        @NotNull
        public static ICommunicationPromise<Unit> update(@NotNull ICloudServiceManager $this, @NotNull ICloudService value, boolean fromPacket, boolean isCalledFromDelete) {
            Intrinsics.checkNotNullParameter(value, "value");
            return ICacheList.DefaultImpls.update($this, (ICacheValue)value, fromPacket, isCalledFromDelete);
        }

        @NotNull
        public static ICommunicationPromise<Unit> delete(@NotNull ICloudServiceManager $this, @NotNull ICloudService value, boolean fromPacket) {
            Intrinsics.checkNotNullParameter(value, "value");
            return ICacheList.DefaultImpls.delete($this, (ICacheValue)value, fromPacket);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendUpdateToConnection(@NotNull ICloudServiceManager $this, @NotNull ICloudService value, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendUpdateToConnection($this, (ICacheValue)value, connection);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendDeleteToConnection(@NotNull ICloudServiceManager $this, @NotNull ICloudService value, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendDeleteToConnection($this, (ICacheValue)value, connection);
        }

        @NotNull
        public static ICommunicationPromise<Unit> sendAllCachedObjectsToConnection(@NotNull ICloudServiceManager $this, @NotNull IConnection connection) {
            Intrinsics.checkNotNullParameter(connection, "connection");
            return ICacheList.DefaultImpls.sendAllCachedObjectsToConnection($this, connection);
        }
    }
}

