/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.service.version;

import eu.thesimplecloud.api.service.version.IServiceVersionHandler;
import eu.thesimplecloud.api.service.version.ServiceVersion;
import eu.thesimplecloud.api.service.version.type.ServiceAPIType;
import eu.thesimplecloud.api.service.version.type.ServiceVersionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u001b"}, d2={"Leu/thesimplecloud/api/service/version/ServiceVersionHandler;", "Leu/thesimplecloud/api/service/version/IServiceVersionHandler;", "versions", "", "Leu/thesimplecloud/api/service/version/ServiceVersion;", "(Ljava/util/List;)V", "getVersions", "()Ljava/util/List;", "setVersions", "getAllAvailablePrefixes", "", "", "getAllVersionSuffixes", "prefix", "getAllVersions", "getPrefixFromFullName", "fullName", "getPrefixesByServiceAPIType", "serviceAPIType", "Leu/thesimplecloud/api/service/version/type/ServiceAPIType;", "getPrefixesByServiceVersionType", "serviceVersionType", "Leu/thesimplecloud/api/service/version/type/ServiceVersionType;", "getServiceVersionByName", "name", "getVersionsByPrefix", "getVersionsByServiceVersionType", "simplecloud-api"})
@SourceDebugExtension(value={"SMAP\nServiceVersionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceVersionHandler.kt\neu/thesimplecloud/api/service/version/ServiceVersionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n766#2:93\n857#2,2:94\n766#2:96\n857#2,2:97\n1726#2,3:99\n1549#2:102\n1620#2,3:103\n1549#2:106\n1620#2,3:107\n1549#2:110\n1620#2,3:111\n1549#2:114\n1620#2,3:115\n766#2:118\n857#2,2:119\n1549#2:121\n1620#2,3:122\n288#2,2:125\n*S KotlinDebug\n*F\n+ 1 ServiceVersionHandler.kt\neu/thesimplecloud/api/service/version/ServiceVersionHandler\n*L\n41#1:93\n41#1:94,2\n46#1:96\n46#1:97,2\n50#1:99,3\n56#1:102\n56#1:103,3\n61#1:106\n61#1:107,3\n62#1:110\n62#1:111,3\n66#1:114\n66#1:115,3\n70#1:118\n70#1:119,2\n75#1:121\n75#1:122,3\n80#1:125,2\n*E\n"})
public class ServiceVersionHandler
implements IServiceVersionHandler {
    @NotNull
    private volatile List<ServiceVersion> versions;

    public ServiceVersionHandler(@NotNull List<ServiceVersion> versions) {
        Intrinsics.checkNotNullParameter(versions, "versions");
        this.versions = versions;
    }

    public /* synthetic */ ServiceVersionHandler(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final List<ServiceVersion> getVersions() {
        return this.versions;
    }

    public final void setVersions(@NotNull List<ServiceVersion> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.versions = list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ServiceVersion> getVersions(@NotNull ServiceAPIType serviceAPIType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serviceAPIType, "serviceAPIType");
        Iterable $this$filter$iv = this.versions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServiceVersion it = (ServiceVersion)element$iv$iv;
            boolean bl = false;
            if (!(it.getServiceAPIType() == serviceAPIType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ServiceVersion> getVersionsByPrefix(@NotNull String prefix) {
        boolean bl;
        List serviceVersions;
        block7: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            if (StringsKt.contains$default((CharSequence)prefix, "_", false, 2, null)) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = this.versions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServiceVersion it = (ServiceVersion)element$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                String string2 = prefix.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            serviceVersions = (List)destination$iv$iv;
            if (serviceVersions.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            ServiceAPIType firstVersionType = ((ServiceVersion)CollectionsKt.first(serviceVersions)).getServiceAPIType();
            Iterable $this$all$iv = serviceVersions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ServiceVersion it = (ServiceVersion)element$iv;
                    boolean bl3 = false;
                    if (it.getServiceAPIType() == firstVersionType) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw new IllegalStateException("API types of prefix " + prefix + " are not equal");
        }
        return serviceVersions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getAllAvailablePrefixes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.versions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServiceVersion serviceVersion = (ServiceVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPrefixFromFullName(it.getName()));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public List<String> getAllVersionSuffixes(@NotNull String prefix) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Iterable $this$map$iv = this.getVersionsByPrefix(prefix);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ServiceVersion serviceVersion = (ServiceVersion)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ServiceVersion)((Object)it)).getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = (prefix + '_').toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase()");
            collection.add(StringsKt.replace$default(it, string, "", false, 4, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getPrefixesByServiceAPIType(@NotNull ServiceAPIType serviceAPIType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serviceAPIType, "serviceAPIType");
        Iterable $this$map$iv = this.getVersions(serviceAPIType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServiceVersion serviceVersion = (ServiceVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPrefixFromFullName(it.getName()));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ServiceVersion> getVersionsByServiceVersionType(@NotNull ServiceVersionType serviceVersionType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serviceVersionType, "serviceVersionType");
        Iterable $this$filter$iv = this.versions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServiceVersion it = (ServiceVersion)element$iv$iv;
            boolean bl = false;
            if (!(it.getServiceAPIType().getServiceVersionType() == serviceVersionType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getPrefixesByServiceVersionType(@NotNull ServiceVersionType serviceVersionType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serviceVersionType, "serviceVersionType");
        Iterable $this$map$iv = this.getVersionsByServiceVersionType(serviceVersionType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServiceVersion serviceVersion = (ServiceVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getPrefixFromFullName(it.getName()));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public ServiceVersion getServiceVersionByName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$firstOrNull$iv = this.versions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ServiceVersion it = (ServiceVersion)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public List<ServiceVersion> getAllVersions() {
        return this.versions;
    }

    private final String getPrefixFromFullName(String fullName) {
        String[] stringArray = new String[]{"_"};
        return (String)StringsKt.split$default((CharSequence)fullName, stringArray, false, 0, 6, null).get(0);
    }

    public ServiceVersionHandler() {
        this(null, 1, null);
    }
}

