/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.sync.object;

import com.google.common.collect.Maps;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.event.sync.object.GlobalPropertyUpdatedEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.network.packets.sync.object.PacketIOGetGlobalProperty;
import eu.thesimplecloud.api.network.packets.sync.object.PacketIORemoveGlobalProperty;
import eu.thesimplecloud.api.network.packets.sync.object.PacketIOUpdateGlobalProperty;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.property.Property;
import eu.thesimplecloud.api.sync.object.IGlobalPropertyHolder;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.ICommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005J&\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00060\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J-\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0006\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010 \u001a\u0002H\u001dH\u0016\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0006J\u001c\u0010$\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001c\u0010%\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\u0007\u001aZ\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \t*,\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Leu/thesimplecloud/api/sync/object/GlobalPropertyHolder;", "Leu/thesimplecloud/api/sync/object/IGlobalPropertyHolder;", "()V", "nameToValue", "", "", "Leu/thesimplecloud/api/property/IProperty;", "propertyNameToUpdateClient", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "addConnectionToUpdates", "", "propertyName", "connection", "clearProperties", "forwardPacket", "name", "packet", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "getProperties", "", "removeConnectionFromUpdates", "removeProperty", "removePropertyFromNetwork", "removePropertyFromPacket", "requestProperty", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "T", "", "setProperty", "value", "(Ljava/lang/String;Ljava/lang/Object;)Leu/thesimplecloud/api/property/IProperty;", "updatePropertyFromPacket", "property", "updatePropertyToNetwork", "writeUpdateToMap", "simplecloud-api"})
@SourceDebugExtension(value={"SMAP\nGlobalPropertyHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPropertyHolder.kt\neu/thesimplecloud/api/sync/object/GlobalPropertyHolder\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 IPacketSender.kt\neu/thesimplecloud/clientserverapi/lib/packet/packetsender/IPacketSenderKt\n*L\n1#1,129:1\n73#2,2:130\n1#3:132\n1855#4,2:133\n1855#4,2:136\n48#5:135\n*S KotlinDebug\n*F\n+ 1 GlobalPropertyHolder.kt\neu/thesimplecloud/api/sync/object/GlobalPropertyHolder\n*L\n47#1:130,2\n47#1:132\n52#1:133,2\n120#1:136,2\n78#1:135\n*E\n"})
public final class GlobalPropertyHolder
implements IGlobalPropertyHolder {
    private final ConcurrentMap<String, Set<IConnection>> propertyNameToUpdateClient = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, IProperty<?>> nameToValue;

    public GlobalPropertyHolder() {
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap()");
        this.nameToValue = concurrentMap;
    }

    public final void addConnectionToUpdates(@NotNull String propertyName, @NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(connection, "connection");
        ConcurrentMap<String, Set<IConnection>> concurrentMap = this.propertyNameToUpdateClient;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "this.propertyNameToUpdateClient");
        ConcurrentMap<String, Set<IConnection>> $this$getOrPut$iv = concurrentMap;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(propertyName);
        if (object == null) {
            boolean bl = false;
            Set default$iv = new CopyOnWriteArraySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(propertyName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Set list = (Set)object;
        list.add(connection);
    }

    public final void removeConnectionFromUpdates(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Iterable $this$forEach$iv = this.propertyNameToUpdateClient.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            it.remove(connection);
        }
    }

    @Override
    @NotNull
    public Map<String, IProperty<?>> getProperties() {
        return this.nameToValue;
    }

    @Override
    @NotNull
    public <T> IProperty<T> setProperty(@NotNull String name, @NotNull T value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        Property<T> newProperty = new Property<T>(value);
        this.writeUpdateToMap(name, (IProperty)newProperty);
        this.updatePropertyToNetwork(name, (IProperty)newProperty);
        return newProperty;
    }

    @Override
    public void clearProperties() {
        throw new UnsupportedOperationException("Cannot clear global properties");
    }

    @Override
    public void removeProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.nameToValue.remove(name);
        this.removePropertyFromNetwork(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> ICommunicationPromise<IProperty<T>> requestProperty(@NotNull String name) {
        void packet$iv;
        void $this$sendQuery$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        if (CloudAPI.Companion.getInstance().isManager()) {
            throw new UnsupportedOperationException("Cannot request properties from manager");
        }
        ICommunicationBootstrap iCommunicationBootstrap = CloudAPI.Companion.getInstance().getThisSidesCommunicationBootstrap();
        Intrinsics.checkNotNull(iCommunicationBootstrap, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.INettyClient");
        INettyClient client = (INettyClient)iCommunicationBootstrap;
        IPacketSender iPacketSender = client.getConnection();
        IPacket iPacket = new PacketIOGetGlobalProperty(name);
        long timeout$iv = 5000L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, IProperty.class, timeout$iv).addResultListener(new Function1<IProperty<T>, Unit>(this, name){
            final /* synthetic */ GlobalPropertyHolder this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(1);
            }

            public final void invoke(@NotNull IProperty<T> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.updatePropertyFromPacket(this.$name, it);
            }
        });
    }

    public final void updatePropertyFromPacket(@NotNull String name, @NotNull IProperty<?> property) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(property, "property");
        this.writeUpdateToMap(name, property);
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new GlobalPropertyUpdatedEvent(name, property), false, 2, null);
        if (CloudAPI.Companion.getInstance().isManager()) {
            this.updatePropertyToNetwork(name, property);
        }
    }

    public final void removePropertyFromPacket(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.nameToValue.remove(name);
        if (CloudAPI.Companion.getInstance().isManager()) {
            this.removePropertyFromNetwork(name);
        }
    }

    private final void writeUpdateToMap(String name, IProperty<?> property) {
        IProperty<?> cachedProperty = this.nameToValue.get(name);
        if (cachedProperty == null) {
            this.nameToValue.put(name, property);
            return;
        }
        Property cfr_ignored_0 = (Property)cachedProperty;
        ((Property)cachedProperty).setStringValue(property.getValueAsString());
        ((Property)cachedProperty).resetValue();
    }

    private final void updatePropertyToNetwork(String name, IProperty<?> property) {
        PacketIOUpdateGlobalProperty updatePacket = new PacketIOUpdateGlobalProperty(name, property);
        this.forwardPacket(name, updatePacket);
    }

    private final void removePropertyFromNetwork(String name) {
        PacketIORemoveGlobalProperty updatePacket = new PacketIORemoveGlobalProperty(name);
        this.forwardPacket(name, updatePacket);
    }

    private final void forwardPacket(String name, IPacket packet) {
        if (CloudAPI.Companion.getInstance().isManager()) {
            Set set = (Set)this.propertyNameToUpdateClient.get(name);
            if (set != null) {
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IConnection it = (IConnection)element$iv;
                    boolean bl = false;
                    IPacketSender.DefaultImpls.sendUnitQuery$default(it, packet, 0L, 2, null);
                }
            }
        } else {
            ICommunicationBootstrap iCommunicationBootstrap = CloudAPI.Companion.getInstance().getThisSidesCommunicationBootstrap();
            Intrinsics.checkNotNull(iCommunicationBootstrap, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.INettyClient");
            INettyClient client = (INettyClient)iCommunicationBootstrap;
            IPacketSender.DefaultImpls.sendUnitQuery$default(client.getConnection(), packet, 0L, 2, null);
        }
    }

    @Override
    @Nullable
    public <T> IProperty<T> getProperty(@NotNull String name) {
        return IGlobalPropertyHolder.DefaultImpls.getProperty(this, name);
    }

    @Override
    public boolean hasProperty(@NotNull String property) {
        return IGlobalPropertyHolder.DefaultImpls.hasProperty(this, property);
    }

    @Override
    @NotNull
    public ConcurrentMap<String, IProperty<?>> getMapWithNewestProperties(@NotNull Map<String, ? extends IProperty<?>> compareMap) {
        return IGlobalPropertyHolder.DefaultImpls.getMapWithNewestProperties(this, compareMap);
    }
}

