/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.api.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Leu/thesimplecloud/api/utils/ZipUtils;", "", "()V", "deletePath", "", "file", "Ljava/io/File;", "path", "", "hasPath", "", "simplecloud-api"})
public final class ZipUtils {
    public final void deletePath(@NotNull File file, @NotNull String path) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(path, "path");
        HashMap env = new HashMap();
        ((Map)env).put("create", "true");
        ((Map)env).put("encoding", "UTF-8");
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
        URI uri = URI.create("jar:" + file.toURI());
        FileSystem fileSystem = FileSystems.newFileSystem(uri, (Map)env);
        while (entries2.hasMoreElements()) {
            Path pathInZipfile;
            ZipEntry nextElement = entries2.nextElement();
            String string = nextElement.getName();
            Intrinsics.checkNotNullExpressionValue(string, "nextElement.name");
            if (!StringsKt.startsWith$default(string, path, false, 2, null) || nextElement.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue(fileSystem.getPath(nextElement.getName(), new String[0]), "fileSystem.getPath(nextElement.name)");
            Files.delete(pathInZipfile);
        }
        zipFile.close();
        fileSystem.close();
    }

    public final boolean hasPath(@NotNull File file, @NotNull String path) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(path, "path");
        HashMap env = new HashMap();
        ((Map)env).put("create", "true");
        ((Map)env).put("encoding", "UTF-8");
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
        URI uri = URI.create("jar:" + file.toURI());
        FileSystem fileSystem = FileSystems.newFileSystem(uri, (Map)env);
        while (entries2.hasMoreElements()) {
            ZipEntry nextElement = entries2.nextElement();
            String string = nextElement.getName();
            Intrinsics.checkNotNullExpressionValue(string, "nextElement.name");
            if (!StringsKt.startsWith$default(string, path, false, 2, null) || nextElement.isDirectory()) continue;
            zipFile.close();
            fileSystem.close();
            return true;
        }
        zipFile.close();
        fileSystem.close();
        return false;
    }
}

