/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.packet;

import eu.thesimplecloud.clientserverapi.client.ClientConnection;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.lib.ByteBufStringHelper;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.ICommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.debug.DebugMessage;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.PacketData;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.exception.PacketException;
import eu.thesimplecloud.clientserverapi.lib.packet.packettype.ObjectPacket;
import eu.thesimplecloud.clientserverapi.lib.packetmanager.IPacketManager;
import eu.thesimplecloud.clientserverapi.server.INettyServer;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.ClientManager;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import eu.thesimplecloud.jsonlib.JsonLib;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Leu/thesimplecloud/clientserverapi/lib/packet/PacketDecoder;", "Lio/netty/handler/codec/ByteToMessageDecoder;", "communicationBootstrap", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/ICommunicationBootstrap;", "packetManager", "Leu/thesimplecloud/clientserverapi/lib/packetmanager/IPacketManager;", "(Leu/thesimplecloud/clientserverapi/lib/bootstrap/ICommunicationBootstrap;Leu/thesimplecloud/clientserverapi/lib/packetmanager/IPacketManager;)V", "checkAccess", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "decode", "", "byteBuf", "Lio/netty/buffer/ByteBuf;", "out", "", "", "getConnectionByChannelHandlerContext", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "clientserverapi"})
public final class PacketDecoder
extends ByteToMessageDecoder {
    @NotNull
    private final ICommunicationBootstrap communicationBootstrap;
    @NotNull
    private final IPacketManager packetManager;

    public PacketDecoder(@NotNull ICommunicationBootstrap communicationBootstrap, @NotNull IPacketManager packetManager) {
        Intrinsics.checkNotNullParameter(communicationBootstrap, "communicationBootstrap");
        Intrinsics.checkNotNullParameter(packetManager, "packetManager");
        this.communicationBootstrap = communicationBootstrap;
        this.packetManager = packetManager;
    }

    @Override
    protected synchronized void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf byteBuf, @NotNull List<Object> out) {
        IPacket iPacket;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(byteBuf, "byteBuf");
        Intrinsics.checkNotNullParameter(out, "out");
        if (!this.checkAccess(ctx)) {
            return;
        }
        String receivedString = ByteBufStringHelper.Companion.nextString(byteBuf);
        JsonLib jsonLib = JsonLib.Companion.fromJsonString$default(JsonLib.Companion, receivedString, null, 2, null);
        PacketData packetData = jsonLib.getObject("data", PacketData.class);
        if (packetData == null) {
            throw new PacketException("PacketData is not present.");
        }
        PacketData packetData2 = packetData;
        if (packetData2.isResponse()) {
            ObjectPacket objectPacket = ObjectPacket.Companion.getNewEmptyObjectPacket();
            objectPacket.read(byteBuf, this.communicationBootstrap);
            iPacket = objectPacket;
        } else {
            Class<? extends IPacket> packetClass = this.packetManager.getPacketClassByOppositePacketName(packetData2.getSentPacketName());
            if (packetClass == null) {
                byteBuf.clear();
                throw new PacketException("Can't find opposite packet of: " + packetData2.getSentPacketName());
            }
            IPacket packet = packetClass.newInstance();
            try {
                packet.read(byteBuf, this.communicationBootstrap);
            }
            catch (Exception e) {
                throw new PacketException("An error occurred while reading packet: " + packetClass.getName(), e);
            }
            iPacket = packet;
        }
        IPacket packet = iPacket;
        Intrinsics.checkNotNull(packet);
        out.add(new WrappedPacket(packetData2, packet));
        if (this.communicationBootstrap.getDebugMessageManager().isActive(DebugMessage.PACKET_RECEIVED)) {
            System.out.println((Object)("Received Packet " + packet.getClass().getSimpleName() + " (" + packetData2.getUniqueId() + ')'));
        }
    }

    private final boolean checkAccess(ChannelHandlerContext ctx) {
        IConnection connection = this.getConnectionByChannelHandlerContext(ctx);
        if (connection == null) {
            ctx.close();
            return false;
        }
        boolean accessAllowed = connection.getCommunicationBootstrap().getAccessHandler().isAccessAllowed(connection);
        if (!accessAllowed) {
            try {
                connection.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private final IConnection getConnectionByChannelHandlerContext(ChannelHandlerContext ctx) {
        if (this.communicationBootstrap instanceof INettyServer) {
            IClientManager clientManager = ((INettyServer)this.communicationBootstrap).getClientManager();
            Intrinsics.checkNotNull(clientManager, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.server.client.clientmanager.ClientManager<*>");
            ClientManager cfr_ignored_0 = (ClientManager)clientManager;
            return ((ClientManager)clientManager).getClient(ctx);
        }
        ICommunicationBootstrap iCommunicationBootstrap = this.communicationBootstrap;
        Intrinsics.checkNotNull(iCommunicationBootstrap, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.INettyClient");
        INettyClient client = (INettyClient)iCommunicationBootstrap;
        IConnection iConnection = client.getConnection();
        Intrinsics.checkNotNull(iConnection, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.ClientConnection");
        ClientConnection clientConnection = (ClientConnection)iConnection;
        if (clientConnection.getChannel() == ctx.channel()) {
            return clientConnection;
        }
        return null;
    }
}

