/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.testing;

import com.google.common.collect.Maps;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.lib.bootstrap.ICommunicationBootstrap;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.server.INettyServer;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue;
import eu.thesimplecloud.clientserverapi.testing.AbstractTestConnection;
import eu.thesimplecloud.clientserverapi.testing.client.TestNettyClient;
import eu.thesimplecloud.clientserverapi.testing.server.TestClientManager;
import eu.thesimplecloud.clientserverapi.testing.server.TestConnectedClient;
import eu.thesimplecloud.clientserverapi.testing.server.TestNettyServer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001b\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007J\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u00020\u000e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nRn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\b \u0006*\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rv\u0010\t\u001aj\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\n0\n\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \u0006*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b \u0006*4\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\n0\n\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \u0006*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Leu/thesimplecloud/clientserverapi/testing/NetworkTestManager;", "", "()V", "portServerMap", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Leu/thesimplecloud/clientserverapi/testing/server/TestNettyServer;", "Leu/thesimplecloud/clientserverapi/server/client/connectedclient/IConnectedClientValue;", "serverToConnectedClients", "Leu/thesimplecloud/clientserverapi/server/INettyServer;", "", "Leu/thesimplecloud/clientserverapi/client/INettyClient;", "closeConnection", "", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "connectToServer", "client", "disconnectFromServer", "Leu/thesimplecloud/clientserverapi/server/client/connectedclient/IConnectedClient;", "getServerListeningOnPort", "port", "isServerRegistered", "", "server", "performDisconnectOnClient", "registerServer", "sendPacket", "fromConnection", "packet", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "setConnectionActive", "forBootstrap", "Leu/thesimplecloud/clientserverapi/lib/bootstrap/ICommunicationBootstrap;", "connectionOnBoostrapSide", "connectionOnOtherSide", "shutdownConnection", "Leu/thesimplecloud/clientserverapi/testing/AbstractTestConnection;", "unregisterServer", "clientserverapi"})
@SourceDebugExtension(value={"SMAP\nNetworkTestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkTestManager.kt\neu/thesimplecloud/clientserverapi/testing/NetworkTestManager\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n72#2,2:131\n1#3:133\n1#3:134\n*S KotlinDebug\n*F\n+ 1 NetworkTestManager.kt\neu/thesimplecloud/clientserverapi/testing/NetworkTestManager\n*L\n70#1:131,2\n70#1:133\n*E\n"})
public final class NetworkTestManager {
    @NotNull
    public static final NetworkTestManager INSTANCE = new NetworkTestManager();
    private static final ConcurrentMap<Integer, TestNettyServer<? extends IConnectedClientValue>> portServerMap = Maps.newConcurrentMap();
    private static final ConcurrentMap<INettyServer<?>, List<INettyClient>> serverToConnectedClients = Maps.newConcurrentMap();

    private NetworkTestManager() {
    }

    private final INettyServer<?> getServerListeningOnPort(int port) {
        return (INettyServer)portServerMap.get(port);
    }

    public final void registerServer(@NotNull TestNettyServer<? extends IConnectedClientValue> server) {
        Intrinsics.checkNotNullParameter(server, "server");
        ConcurrentMap<Integer, TestNettyServer<? extends IConnectedClientValue>> concurrentMap = portServerMap;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "portServerMap");
        Map map2 = concurrentMap;
        map2.put(server.getPort(), server);
    }

    public final void unregisterServer(@NotNull INettyServer<?> server) {
        Intrinsics.checkNotNullParameter(server, "server");
        portServerMap.remove(server.getPort());
    }

    public final boolean isServerRegistered(@NotNull INettyServer<?> server) {
        Intrinsics.checkNotNullParameter(server, "server");
        return portServerMap.containsKey(server.getPort());
    }

    public final void connectToServer(@NotNull INettyClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        INettyServer<?> iNettyServer = this.getServerListeningOnPort(client.getPort());
        if (iNettyServer == null) {
            throw new IllegalArgumentException("There is no server listening on port " + client.getPort());
        }
        INettyServer<?> server = iNettyServer;
        ConcurrentMap<INettyServer<?>, List<INettyClient>> concurrentMap = serverToConnectedClients;
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "serverToConnectedClients");
        ConcurrentMap<INettyServer<?>, List<INettyClient>> $this$getOrPut$iv = concurrentMap;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(server);
        if (object == null) {
            boolean bl = false;
            List default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(server, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        List list = (List)object;
        list.add(client);
        TestNettyServer cfr_ignored_0 = (TestNettyServer)server;
        IClientManager<?> iClientManager = server.getClientManager();
        Intrinsics.checkNotNull(iClientManager, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.testing.server.TestClientManager<eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue>");
        TestClientManager clientManager = (TestClientManager)iClientManager;
        TestConnectedClient connectedClient = new TestConnectedClient(server, client.getConnection());
        clientManager.addClient(connectedClient);
        this.setConnectionActive(client, client.getConnection(), connectedClient);
        this.setConnectionActive(server, connectedClient, client.getConnection());
    }

    private final void setConnectionActive(ICommunicationBootstrap forBootstrap, IConnection connectionOnBoostrapSide, IConnection connectionOnOtherSide) {
        forBootstrap.getConnectionHandler().onConnectionActive(connectionOnBoostrapSide);
        Intrinsics.checkNotNull(connectionOnBoostrapSide, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.testing.AbstractTestConnection");
        AbstractTestConnection cfr_ignored_0 = (AbstractTestConnection)connectionOnBoostrapSide;
        ((AbstractTestConnection)connectionOnBoostrapSide).setOtherSideConnection(connectionOnOtherSide);
    }

    public final void sendPacket(@NotNull IConnection fromConnection, @NotNull WrappedPacket packet) {
        Intrinsics.checkNotNullParameter(fromConnection, "fromConnection");
        Intrinsics.checkNotNullParameter(packet, "packet");
        AbstractTestConnection cfr_ignored_0 = (AbstractTestConnection)fromConnection;
        IConnection iConnection = ((AbstractTestConnection)fromConnection).getOtherSideConnection();
        Intrinsics.checkNotNull(iConnection);
        IConnection otherSideConnection = iConnection;
        AbstractTestConnection cfr_ignored_1 = (AbstractTestConnection)otherSideConnection;
        ((AbstractTestConnection)otherSideConnection).incomingPacket(packet);
    }

    public final void closeConnection(@NotNull IConnection connection) {
        block0: {
            Intrinsics.checkNotNullParameter(connection, "connection");
            AbstractTestConnection cfr_ignored_0 = (AbstractTestConnection)connection;
            AbstractTestConnection otherSideConnection = (AbstractTestConnection)((AbstractTestConnection)connection).getOtherSideConnection();
            this.shutdownConnection((AbstractTestConnection)connection);
            AbstractTestConnection abstractTestConnection = otherSideConnection;
            if (abstractTestConnection == null) break block0;
            AbstractTestConnection it = abstractTestConnection;
            boolean bl = false;
            INSTANCE.shutdownConnection(it);
        }
    }

    private final void shutdownConnection(AbstractTestConnection connection) {
        if (connection instanceof IConnectedClient) {
            this.disconnectFromServer((IConnectedClient)((Object)connection));
        } else {
            this.performDisconnectOnClient(connection);
        }
        connection.setOtherSideConnection(null);
    }

    private final void performDisconnectOnClient(IConnection connection) {
        ICommunicationBootstrap iCommunicationBootstrap = connection.getCommunicationBootstrap();
        Intrinsics.checkNotNull(iCommunicationBootstrap, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.testing.client.TestNettyClient");
        TestNettyClient client = (TestNettyClient)iCommunicationBootstrap;
        client.getConnectionHandler().onConnectionInactive(connection);
    }

    private final void disconnectFromServer(IConnectedClient<IConnectedClientValue> connection) {
        INettyServer<IConnectedClientValue> iNettyServer = connection.getCommunicationBootstrap();
        Intrinsics.checkNotNull(iNettyServer, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.testing.server.TestNettyServer<eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue>");
        TestNettyServer server = (TestNettyServer)iNettyServer;
        IClientManager iClientManager = server.getClientManager();
        Intrinsics.checkNotNull(iClientManager, "null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.testing.server.TestClientManager<eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClientValue>");
        TestClientManager clientManager = (TestClientManager)iClientManager;
        clientManager.removeClient(connection);
        server.getConnectionHandler().onConnectionInactive(connection);
    }
}

