/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.impl.player;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.exception.NoSuchPlayerException;
import eu.thesimplecloud.api.exception.NoSuchServiceException;
import eu.thesimplecloud.api.exception.PlayerConnectException;
import eu.thesimplecloud.api.exception.UnreachableComponentException;
import eu.thesimplecloud.api.location.ServiceLocation;
import eu.thesimplecloud.api.location.SimpleLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOCloudPlayerForceCommandExecution;
import eu.thesimplecloud.api.network.packets.player.PacketIOConnectCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOGetPlayerLocation;
import eu.thesimplecloud.api.network.packets.player.PacketIOKickCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOPlayerHasPermission;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendActionbarToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendMessageToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendPlayerToLobby;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTablistToPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOSendTitleToCloudPlayer;
import eu.thesimplecloud.api.network.packets.player.PacketIOTeleportPlayer;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.ConnectionResponse;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceType;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.impl.player.AbstractCloudPlayerManagerProxy;
import eu.thesimplecloud.plugin.network.packets.PacketOutTeleportOtherService;
import eu.thesimplecloud.plugin.proxy.bungee.BungeeComponentExtensionsKt;
import eu.thesimplecloud.plugin.proxy.bungee.CloudBungeePlugin;
import eu.thesimplecloud.plugin.proxy.bungee.LobbyConnector;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J1\u0010!\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0016\u00a2\u0006\u0002\u0010%J8\u0010&\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0011H\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000fH\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.H\u0016\u00a8\u0006/"}, d2={"Leu/thesimplecloud/plugin/impl/player/CloudPlayerManagerBungee;", "Leu/thesimplecloud/plugin/impl/player/AbstractCloudPlayerManagerProxy;", "()V", "connectPlayer", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "Leu/thesimplecloud/api/player/connection/ConnectionResponse;", "cloudPlayer", "Leu/thesimplecloud/api/player/ICloudPlayer;", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "forcePlayerCommandExecution", "", "command", "", "getLocationOfPlayer", "Leu/thesimplecloud/api/location/ServiceLocation;", "getPlayerPing", "", "getProxiedPlayerByCloudPlayer", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "getServerInfoByCloudService", "Lnet/md_5/bungee/api/config/ServerInfo;", "hasPermission", "", "permission", "kickPlayer", "message", "sendActionbar", "actionbar", "Lnet/kyori/adventure/text/Component;", "sendMessageToPlayer", "component", "sendPlayerToLobby", "sendTablist", "headers", "", "footers", "(Leu/thesimplecloud/api/player/ICloudPlayer;[Ljava/lang/String;[Ljava/lang/String;)V", "sendTitle", "title", "subTitle", "fadeIn", "stay", "fadeOut", "teleportPlayer", "location", "Leu/thesimplecloud/api/location/SimpleLocation;", "simplecloud-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudPlayerManagerBungee.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudPlayerManagerBungee.kt\neu/thesimplecloud/plugin/impl/player/CloudPlayerManagerBungee\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IPacketSender.kt\neu/thesimplecloud/clientserverapi/lib/packet/packetsender/IPacketSenderKt\n*L\n1#1,260:1\n1#2:261\n48#3:262\n48#3:263\n48#3:264\n48#3:265\n*S KotlinDebug\n*F\n+ 1 CloudPlayerManagerBungee.kt\neu/thesimplecloud/plugin/impl/player/CloudPlayerManagerBungee\n*L\n85#1:262\n215#1:263\n229#1:264\n234#1:265\n*E\n"})
public final class CloudPlayerManagerBungee
extends AbstractCloudPlayerManagerProxy {
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendMessageToPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull Component component) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(component, "component");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendMessageToCloudPlayer(cloudPlayer, component), 0L, 2, null);
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendMessage(BungeeComponentExtensionsKt.toBaseComponent(component));
        }
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ConnectionResponse> connectPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        Intrinsics.checkNotNullParameter(cloudService, "cloudService");
        if (!(this.getCachedCloudPlayer(cloudPlayer.getUniqueId()) == cloudPlayer)) {
            boolean $i$a$-require-CloudPlayerManagerBungee$connectPlayer$22 = false;
            String $i$a$-require-CloudPlayerManagerBungee$connectPlayer$22 = "CloudPlayer must be the cached player.";
            throw new IllegalArgumentException($i$a$-require-CloudPlayerManagerBungee$connectPlayer$22.toString());
        }
        if (cloudService.getServiceType() == ServiceType.PROXY) {
            return CommunicationPromise.Companion.failed(new IllegalArgumentException("Cannot send a player to a proxy service"));
        }
        if (Intrinsics.areEqual(cloudPlayer.getConnectedServerName(), cloudService.getName())) {
            return CommunicationPromise.Companion.of(new ConnectionResponse(cloudPlayer.getUniqueId(), true));
        }
        if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
            void timeout$iv;
            void packet$iv;
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket $i$a$-require-CloudPlayerManagerBungee$connectPlayer$22 = new PacketIOConnectCloudPlayer(cloudPlayer, cloudService);
            long l = 500L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, ConnectionResponse.class, (long)timeout$iv);
        }
        ServerInfo serverInfo = this.getServerInfoByCloudService(cloudService);
        if (serverInfo == null) {
            return CommunicationPromise.Companion.failed(new UnreachableComponentException("Service is not registered on player's proxy"));
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchElementException("Unable to find the player on the proxy service"));
        }
        CommunicationPromise communicationPromise = new CommunicationPromise(0L, false, 3, null);
        proxiedPlayer.connect(serverInfo, (arg_0, arg_1) -> CloudPlayerManagerBungee.connectPlayer$lambda$1(communicationPromise, cloudPlayer, arg_0, arg_1));
        return communicationPromise;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> kickPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull String message) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(message, "message");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOKickCloudPlayer(cloudPlayer, message), 0L, 2, null);
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            TextComponent textComponent = Component.text(message);
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(message)");
            proxiedPlayer.disconnect(BungeeComponentExtensionsKt.toBaseComponent(textComponent));
        }
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    @Override
    public void sendTitle(@NotNull ICloudPlayer cloudPlayer, @NotNull String title, @NotNull String subTitle, int fadeIn, int stay, int fadeOut) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(title, "title");
            Intrinsics.checkNotNullParameter(subTitle, "subTitle");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTitleToCloudPlayer(cloudPlayer, title, subTitle, fadeIn, stay, fadeOut), 0L, 2, null);
                return;
            }
            Title titleObj = ProxyServer.getInstance().createTitle();
            TextComponent textComponent = Component.text(title);
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(title)");
            Title title2 = titleObj.title(BungeeComponentExtensionsKt.toBaseComponent(textComponent));
            TextComponent textComponent2 = Component.text(subTitle);
            Intrinsics.checkNotNullExpressionValue(textComponent2, "text(subTitle)");
            title2.subTitle(BungeeComponentExtensionsKt.toBaseComponent(textComponent2)).fadeIn(fadeIn).stay(stay).fadeOut(fadeOut);
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendTitle(titleObj);
        }
    }

    @Override
    public void forcePlayerCommandExecution(@NotNull ICloudPlayer cloudPlayer, @NotNull String command2) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(command2, "command");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOCloudPlayerForceCommandExecution(cloudPlayer, command2), 0L, 2, null);
                return;
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.chat('/' + command2);
        }
    }

    @Override
    public void sendActionbar(@NotNull ICloudPlayer cloudPlayer, @NotNull Component actionbar) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(actionbar, "actionbar");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendActionbarToCloudPlayer(cloudPlayer, actionbar), 0L, 2, null);
                return;
            }
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.sendMessage(ChatMessageType.ACTION_BAR, BungeeComponentExtensionsKt.toBaseComponent(actionbar));
        }
    }

    @Override
    public void sendTablist(@NotNull ICloudPlayer cloudPlayer, @NotNull String[] headers, @NotNull String[] footers) {
        block1: {
            Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
            Intrinsics.checkNotNullParameter(headers, "headers");
            Intrinsics.checkNotNullParameter(footers, "footers");
            if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
                IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOSendTablistToPlayer(cloudPlayer.getUniqueId(), headers, footers), 0L, 2, null);
                return;
            }
            TextComponent headerComponent = this.getHexColorComponent(ArraysKt.joinToString$default(headers, (CharSequence)"\n", null, null, 0, null, null, 62, null));
            TextComponent footerComponent = this.getHexColorComponent(ArraysKt.joinToString$default(footers, (CharSequence)"\n", null, null, 0, null, null, 62, null));
            ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
            if (proxiedPlayer == null) break block1;
            proxiedPlayer.setTabHeader(BungeeComponentSerializer.get().serialize(headerComponent), BungeeComponentSerializer.get().serialize(footerComponent));
        }
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        Intrinsics.checkNotNullParameter(location, "location");
        return IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketIOTeleportPlayer(cloudPlayer, location), 0L, 2, null);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> teleportPlayer(@NotNull ICloudPlayer cloudPlayer, @NotNull ServiceLocation location) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        Intrinsics.checkNotNullParameter(location, "location");
        if (location.getService() == null) {
            return CommunicationPromise.Companion.failed(new NoSuchServiceException("Service to connect the player to cannot be found."));
        }
        return CloudPlugin.Companion.getInstance().getConnectionToManager().sendUnitQuery(new PacketOutTeleportOtherService(cloudPlayer.getUniqueId(), location.getServiceName(), location), 1000L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Boolean> hasPermission(@NotNull ICloudPlayer cloudPlayer, @NotNull String permission) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        Intrinsics.checkNotNullParameter(permission, "permission");
        if (!Intrinsics.areEqual(cloudPlayer.getConnectedProxyName(), CloudPlugin.Companion.getInstance().getThisServiceName())) {
            void timeout$iv;
            void packet$iv;
            void $this$sendQuery$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket iPacket = new PacketIOPlayerHasPermission(cloudPlayer.getUniqueId(), permission);
            long l = 400L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery$iv.sendQuery((IPacket)packet$iv, Boolean.class, (long)timeout$iv);
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find bungeecord player"));
        }
        return CommunicationPromise.Companion.of(proxiedPlayer.hasPermission(permission));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<ServiceLocation> getLocationOfPlayer(@NotNull ICloudPlayer cloudPlayer) {
        void $this$sendQuery_u24default$iv;
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket packet$iv = new PacketIOGetPlayerLocation(cloudPlayer);
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery_u24default$iv.sendQuery(packet$iv, ServiceLocation.class, timeout$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ICommunicationPromise<Unit> sendPlayerToLobby(@NotNull ICloudPlayer cloudPlayer) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        if (!Intrinsics.areEqual(CloudPlugin.Companion.getInstance().getThisServiceName(), cloudPlayer.getConnectedProxyName())) {
            void $this$sendQuery_u24default$iv;
            IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
            IPacket packet$iv = new PacketIOSendPlayerToLobby(cloudPlayer.getUniqueId());
            long timeout$iv = 200L;
            boolean $i$f$sendQuery = false;
            return $this$sendQuery_u24default$iv.sendQuery(packet$iv, Unit.class, timeout$iv);
        }
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        if (proxiedPlayer == null) {
            return CommunicationPromise.Companion.failed(new NoSuchPlayerException("Unable to find bungeecord player"));
        }
        ProxiedPlayer proxiedPlayer2 = proxiedPlayer;
        ServerInfo serverInfo = LobbyConnector.getLobbyServer$default(CloudBungeePlugin.Companion.getInstance().getLobbyConnector(), proxiedPlayer2, null, 2, null);
        if (serverInfo == null) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
            TextComponent textComponent = Component.text(message);
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(message)");
            proxiedPlayer2.disconnect(BungeeComponentExtensionsKt.toBaseComponent(textComponent));
            return CommunicationPromise.Companion.failed(new NoSuchServiceException("No fallback server found"));
        }
        proxiedPlayer2.connect(serverInfo);
        return CommunicationPromise.Companion.of(Unit.INSTANCE);
    }

    @Override
    @NotNull
    public ICommunicationPromise<Integer> getPlayerPing(@NotNull ICloudPlayer cloudPlayer) {
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        ProxiedPlayer proxiedPlayer = this.getProxiedPlayerByCloudPlayer(cloudPlayer);
        return CommunicationPromise.Companion.of(proxiedPlayer != null ? proxiedPlayer.getPing() : -1);
    }

    private final ProxiedPlayer getProxiedPlayerByCloudPlayer(ICloudPlayer cloudPlayer) {
        return ProxyServer.getInstance().getPlayer(cloudPlayer.getUniqueId());
    }

    private final ServerInfo getServerInfoByCloudService(ICloudService cloudService) {
        return ProxyServer.getInstance().getServerInfo(cloudService.getName());
    }

    private static final void connectPlayer$lambda$1(CommunicationPromise $communicationPromise, ICloudPlayer $cloudPlayer, Boolean bl, Throwable throwable) {
        Intrinsics.checkNotNullParameter($communicationPromise, "$communicationPromise");
        Intrinsics.checkNotNullParameter($cloudPlayer, "$cloudPlayer");
        Intrinsics.checkNotNullExpressionValue(bl, "boolean");
        if (bl.booleanValue()) {
            $communicationPromise.trySuccess(new ConnectionResponse($cloudPlayer.getUniqueId(), false));
        } else {
            $communicationPromise.tryFailure(new PlayerConnectException("Unable to connect the player to the service"));
        }
    }
}

