/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.dto.PlayerLoginRequestResult;
import eu.thesimplecloud.api.event.player.CloudPlayerDisconnectEvent;
import eu.thesimplecloud.api.event.player.CloudPlayerLoginEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerUpdater;
import eu.thesimplecloud.api.player.PlayerServerConnectState;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.api.player.impl.CloudPlayer;
import eu.thesimplecloud.api.player.impl.CloudPlayerUpdater;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.network.packets.PacketOutCreateCloudPlayer;
import eu.thesimplecloud.plugin.network.packets.PacketOutGetTabSuggestions;
import eu.thesimplecloud.plugin.network.packets.PacketOutPlayerConnectToServer;
import eu.thesimplecloud.plugin.network.packets.PacketOutPlayerLoginRequest;
import eu.thesimplecloud.plugin.proxy.CancelType;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u0012J8\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00060\u0019J:\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\r2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00060\u0019J\"\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0 0\u001f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\rJ\b\u0010#\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Leu/thesimplecloud/plugin/proxy/ProxyEventHandler;", "", "()V", "thisGroup", "Leu/thesimplecloud/api/servicegroup/ICloudServiceGroup;", "handleAlreadyRegistered", "", "player", "Leu/thesimplecloud/api/player/ICloudPlayer;", "handleDisconnect", "uniqueId", "Ljava/util/UUID;", "name", "", "handleLogin", "playerConnection", "Leu/thesimplecloud/api/player/connection/DefaultPlayerConnection;", "cancelEvent", "Lkotlin/Function1;", "handlePostLogin", "handleServerConnect", "serverName", "handleServerKick", "cloudPlayer", "kickReasonString", "Lkotlin/Function2;", "Leu/thesimplecloud/plugin/proxy/CancelType;", "handleServerPreConnect", "serverNameFrom", "serverNameTo", "handleTabComplete", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "uuid", "rawCommand", "subtractOneFromThisServiceOnlineCount", "simplecloud-plugin"})
@SourceDebugExtension(value={"SMAP\nProxyEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyEventHandler.kt\neu/thesimplecloud/plugin/proxy/ProxyEventHandler\n+ 2 IPacketSender.kt\neu/thesimplecloud/clientserverapi/lib/packet/packetsender/IPacketSenderKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,253:1\n48#2:254\n48#2:255\n48#2:257\n26#3:256\n*S KotlinDebug\n*F\n+ 1 ProxyEventHandler.kt\neu/thesimplecloud/plugin/proxy/ProxyEventHandler\n*L\n70#1:254\n79#1:255\n239#1:257\n237#1:256\n*E\n"})
public final class ProxyEventHandler {
    @NotNull
    public static final ProxyEventHandler INSTANCE = new ProxyEventHandler();
    @NotNull
    private static final ICloudServiceGroup thisGroup = CloudPlugin.Companion.getInstance().thisService().getServiceGroup();

    private ProxyEventHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public final void handleLogin(@NotNull DefaultPlayerConnection playerConnection, @NotNull Function1<? super String, Unit> cancelEvent) {
        void timeout$iv;
        void packet$iv;
        void $this$sendQuery$iv;
        void timeout$iv22;
        IPacketSender packet$iv2;
        void $this$sendQuery$iv2;
        Intrinsics.checkNotNullParameter(playerConnection, "playerConnection");
        Intrinsics.checkNotNullParameter(cancelEvent, "cancelEvent");
        ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();
        if (!thisService.isAuthenticated() || !thisService.isOnline()) {
            cancelEvent.invoke("\u00a7cProxy is still starting.");
            return;
        }
        ICommunicationPromise<ICloudPlayer> playerPromise = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCloudPlayer(playerConnection.getUniqueId()).awaitUninterruptibly();
        if (playerPromise.isSuccess()) {
            ICloudPlayer iCloudPlayer = playerPromise.getNow();
            Intrinsics.checkNotNull(iCloudPlayer);
            this.handleAlreadyRegistered(iCloudPlayer);
        }
        IPacketSender iPacketSender = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket iPacket = new PacketOutCreateCloudPlayer(playerConnection, CloudPlugin.Companion.getInstance().getThisServiceName());
        long l = 1000L;
        boolean $i$f$sendQuery = false;
        ICommunicationPromise<CloudPlayer> createPromise = $this$sendQuery$iv2.sendQuery((IPacket)((Object)packet$iv2), CloudPlayer.class, (long)timeout$iv22).awaitUninterruptibly();
        if (!createPromise.isSuccess()) {
            cancelEvent.invoke("\u00a7cFailed to create player: " + createPromise.cause().getMessage());
            System.out.println((Object)"Failed to create CloudPlayer:");
            Throwable throwable = createPromise.cause();
            Intrinsics.checkNotNullExpressionValue(throwable, "createPromise.cause()");
            throw throwable;
        }
        packet$iv2 = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket timeout$iv22 = new PacketOutPlayerLoginRequest(playerConnection.getUniqueId());
        long l2 = 1000L;
        boolean $i$f$sendQuery2 = false;
        ICommunicationPromise<PlayerLoginRequestResult> loginRequestPromise = $this$sendQuery$iv.sendQuery((IPacket)packet$iv, PlayerLoginRequestResult.class, (long)timeout$iv).awaitUninterruptibly();
        if (!loginRequestPromise.isSuccess()) {
            loginRequestPromise.cause().printStackTrace();
            cancelEvent.invoke("\u00a7cLogin failed: " + loginRequestPromise.cause().getMessage());
            return;
        }
        PlayerLoginRequestResult loginRequestResult = loginRequestPromise.getBlocking();
        if (loginRequestResult.getCancel()) {
            cancelEvent.invoke(loginRequestResult.getKickMessage());
        }
        CloudPlayer cloudPlayer = createPromise.getNow();
        Intrinsics.checkNotNull(cloudPlayer);
        CloudPlayer cloudPlayer2 = cloudPlayer;
        String permission = thisGroup.getPermission();
        if (permission != null && !cloudPlayer2.hasPermissionSync(permission)) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-permission", new String[0]);
            cancelEvent.invoke(message);
            return;
        }
        ICacheList.DefaultImpls.update$default(CloudAPI.Companion.getInstance().getCloudPlayerManager(), cloudPlayer2, true, false, 4, null).awaitUninterruptibly();
    }

    private final void handleAlreadyRegistered(ICloudPlayer player) {
        player.kick().awaitUninterruptibly();
        CloudAPI.Companion.getInstance().getCloudPlayerManager().sendDeleteToConnection((ICacheValue)player, CloudPlugin.Companion.getInstance().getConnectionToManager()).awaitUninterruptibly();
    }

    public final void handlePostLogin(@NotNull UUID uniqueId, @NotNull String name) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(name, "name");
        ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();
        thisService.setOnlineCount(thisService.getOnlineCount() + 1);
        thisService.update().awaitUninterruptibly();
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new CloudPlayerLoginEvent(uniqueId, name), false, 2, null);
    }

    public final void handleDisconnect(@NotNull UUID uniqueId, @NotNull String name) {
        ICloudPlayer cloudPlayer;
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(name, "name");
        IEventManager.DefaultImpls.call$default(CloudAPI.Companion.getInstance().getEventManager(), new CloudPlayerDisconnectEvent(uniqueId, name), false, 2, null);
        ICloudPlayer iCloudPlayer = cloudPlayer = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(uniqueId);
        if (iCloudPlayer != null) {
            ICloudPlayer it = iCloudPlayer;
            boolean bl = false;
            CloudPlayer cfr_ignored_0 = (CloudPlayer)cloudPlayer;
            ((CloudPlayer)cloudPlayer).setOffline();
            ICacheList.DefaultImpls.delete$default(CloudAPI.Companion.getInstance().getCloudPlayerManager(), cloudPlayer, false, 2, null);
            IConnection connection = CloudPlugin.Companion.getInstance().getConnectionToManager();
            CloudAPI.Companion.getInstance().getCloudPlayerManager().sendDeleteToConnection((ICacheValue)cloudPlayer, connection).awaitUninterruptibly();
        }
        this.subtractOneFromThisServiceOnlineCount();
    }

    public final void handleServerPreConnect(@NotNull UUID uniqueId, @Nullable String serverNameFrom, @NotNull String serverNameTo, @NotNull Function2<? super String, ? super CancelType, Unit> cancelEvent) {
        String permission;
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(serverNameTo, "serverNameTo");
        Intrinsics.checkNotNullParameter(cancelEvent, "cancelEvent");
        if (Intrinsics.areEqual(serverNameFrom, serverNameTo)) {
            return;
        }
        ICloudService cloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serverNameTo);
        if (cloudService == null) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.service-not-registered", new String[0]);
            cancelEvent.invoke(message, CancelType.KICK);
            return;
        }
        ICloudServiceGroup serviceGroup = cloudService.getServiceGroup();
        ICloudPlayer cloudPlayer = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(uniqueId);
        if (cloudPlayer == null) {
            cancelEvent.invoke("\u00a7cUnable to find cloud player.", CancelType.KICK);
            return;
        }
        if (serviceGroup.isInMaintenance() && !cloudPlayer.hasPermissionSync("cloud.maintenance.join")) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.service-in-maintenance", new String[0]);
            cancelEvent.invoke(message, CancelType.MESSAGE);
            return;
        }
        if (serviceGroup instanceof ICloudServerGroup && (permission = serviceGroup.getPermission()) != null && !cloudPlayer.hasPermissionSync(permission)) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-permission", new String[0]);
            cancelEvent.invoke(message, CancelType.MESSAGE);
            return;
        }
        if (cloudService.getState() == ServiceState.STARTING) {
            String message = CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.server-still-starting", new String[0]);
            cancelEvent.invoke(message, CancelType.MESSAGE);
            return;
        }
        IPacketSender.DefaultImpls.sendUnitQuery$default(CloudPlugin.Companion.getInstance().getConnectionToManager(), new PacketOutPlayerConnectToServer(uniqueId, serverNameTo), 0L, 2, null).awaitUninterruptibly().addFailureListener(new Function1<Throwable, Unit>(cancelEvent){
            final /* synthetic */ Function2<String, CancelType, Unit> $cancelEvent;
            {
                this.$cancelEvent = $cancelEvent;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$cancelEvent.invoke("\u00a7cCan't connect to server: " + it.getMessage(), CancelType.MESSAGE);
            }
        });
        ICloudPlayerUpdater playerUpdater = (ICloudPlayerUpdater)cloudPlayer.getUpdater();
        Intrinsics.checkNotNull(playerUpdater, "null cannot be cast to non-null type eu.thesimplecloud.api.player.impl.CloudPlayerUpdater");
        CloudPlayerUpdater cfr_ignored_0 = (CloudPlayerUpdater)playerUpdater;
        ((CloudPlayerUpdater)playerUpdater).setServerConnectState(PlayerServerConnectState.CONNECTING);
        playerUpdater.update().awaitUninterruptibly();
    }

    public final void handleServerConnect(@NotNull UUID uniqueId, @NotNull String serverName, @NotNull Function1<? super String, Unit> cancelEvent) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(serverName, "serverName");
        Intrinsics.checkNotNullParameter(cancelEvent, "cancelEvent");
        ICloudService service = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serverName);
        if (service == null) {
            cancelEvent.invoke("\u00a7cService does not exist.");
            return;
        }
        ICloudPlayer cloudPlayer = CloudAPI.Companion.getInstance().getCloudPlayerManager().getCachedCloudPlayer(uniqueId);
        if (cloudPlayer == null) {
            return;
        }
        ICloudPlayerUpdater playerUpdater = (ICloudPlayerUpdater)cloudPlayer.getUpdater();
        Intrinsics.checkNotNull(playerUpdater, "null cannot be cast to non-null type eu.thesimplecloud.api.player.impl.CloudPlayerUpdater");
        CloudPlayerUpdater cfr_ignored_0 = (CloudPlayerUpdater)playerUpdater;
        ((CloudPlayerUpdater)playerUpdater).setConnectedServerName(service.getName());
        ((CloudPlayerUpdater)playerUpdater).setServerConnectState(PlayerServerConnectState.CONNECTED);
        playerUpdater.update().awaitUninterruptibly();
    }

    public final void handleServerKick(@NotNull ICloudPlayer cloudPlayer, @NotNull String kickReasonString, @NotNull String serverName, @NotNull Function2<? super String, ? super CancelType, Unit> cancelEvent) {
        ICloudService cloudService;
        Intrinsics.checkNotNullParameter(cloudPlayer, "cloudPlayer");
        Intrinsics.checkNotNullParameter(kickReasonString, "kickReasonString");
        Intrinsics.checkNotNullParameter(serverName, "serverName");
        Intrinsics.checkNotNullParameter(cancelEvent, "cancelEvent");
        if ((((CharSequence)kickReasonString).length() > 0 && StringsKt.contains$default((CharSequence)kickReasonString, "Outdated server", false, 2, null) || StringsKt.contains$default((CharSequence)kickReasonString, "Outdated client", false, 2, null)) && ((cloudService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(serverName)) == null || cloudService.isLobby())) {
            cancelEvent.invoke("\u00a7cYou are using an unsupported version.", CancelType.KICK);
            return;
        }
        ICloudPlayerUpdater playerUpdater = (ICloudPlayerUpdater)cloudPlayer.getUpdater();
        Intrinsics.checkNotNull(playerUpdater, "null cannot be cast to non-null type eu.thesimplecloud.api.player.impl.CloudPlayerUpdater");
        CloudPlayerUpdater cfr_ignored_0 = (CloudPlayerUpdater)playerUpdater;
        if (playerUpdater.getConnectedServerName() != null) {
            ((CloudPlayerUpdater)playerUpdater).setServerConnectState(PlayerServerConnectState.CONNECTED);
            playerUpdater.update().awaitUninterruptibly();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ICommunicationPromise<String[]> handleTabComplete(@NotNull UUID uuid, @NotNull String rawCommand) {
        void packet$iv;
        void $this$sendQuery_u24default$iv;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(rawCommand, "rawCommand");
        String commandString = StringsKt.replace$default(rawCommand, "/", "", false, 4, null);
        if (((CharSequence)commandString).length() == 0) {
            boolean $i$f$emptyArray = false;
            return CommunicationPromise.Companion.of(new String[0]);
        }
        IPacketSender $i$f$emptyArray = CloudPlugin.Companion.getInstance().getConnectionToManager();
        IPacket iPacket = new PacketOutGetTabSuggestions(uuid, commandString);
        long timeout$iv = 200L;
        boolean $i$f$sendQuery = false;
        return $this$sendQuery_u24default$iv.sendQuery((IPacket)packet$iv, String[].class, timeout$iv);
    }

    private final void subtractOneFromThisServiceOnlineCount() {
        ICloudService service = CloudPlugin.Companion.getInstance().thisService();
        service.setOnlineCount(service.getOnlineCount() - 1);
        service.update().awaitUninterruptibly();
    }
}

