/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.property.IProperty;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.servicegroup.ICloudServiceGroup;
import eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.plugin.impl.player.CloudPlayerManagerVelocity;
import eu.thesimplecloud.plugin.listener.CloudListener;
import eu.thesimplecloud.plugin.proxy.ICloudProxyPlugin;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.velocity.LobbyConnector;
import eu.thesimplecloud.plugin.proxy.velocity.commands.VelocityCommand;
import eu.thesimplecloud.plugin.proxy.velocity.listener.CloudPlayerDisconnectListener;
import eu.thesimplecloud.plugin.proxy.velocity.listener.VelocityListener;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Plugin(id="simplecloud_plugin")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR6\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "Leu/thesimplecloud/plugin/proxy/ICloudProxyPlugin;", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "(Lcom/velocitypowered/api/proxy/ProxyServer;)V", "lobbyConnector", "Leu/thesimplecloud/plugin/proxy/velocity/LobbyConnector;", "getLobbyConnector", "()Leu/thesimplecloud/plugin/proxy/velocity/LobbyConnector;", "getProxyServer", "()Lcom/velocitypowered/api/proxy/ProxyServer;", "<set-?>", "Leu/thesimplecloud/api/property/IProperty;", "", "", "synchronizedIngameCommandsProperty", "getSynchronizedIngameCommandsProperty", "()Leu/thesimplecloud/api/property/IProperty;", "addServiceToProxy", "", "cloudService", "Leu/thesimplecloud/api/service/ICloudService;", "getCloudPlayerManagerClass", "Lkotlin/reflect/KClass;", "Leu/thesimplecloud/api/player/ICloudPlayerManager;", "handleInit", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "handleShutdown", "Lcom/velocitypowered/api/event/proxy/ProxyShutdownEvent;", "registerService", "name", "socketAddress", "Ljava/net/InetSocketAddress;", "removeServiceFromProxy", "runOfflinePlayerChecker", "shutdown", "synchronizeOnlineCountTask", "Companion", "simplecloud-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudVelocityPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudVelocityPlugin.kt\neu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n766#2:165\n857#2,2:166\n1855#2,2:168\n766#2:170\n857#2,2:171\n1855#2,2:173\n*S KotlinDebug\n*F\n+ 1 CloudVelocityPlugin.kt\neu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin\n*L\n92#1:165\n92#1:166,2\n93#1:168,2\n141#1:170\n141#1:171,2\n142#1:173,2\n*E\n"})
public final class CloudVelocityPlugin
implements ICloudProxyPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyServer proxyServer;
    private volatile IProperty<String[]> synchronizedIngameCommandsProperty;
    @NotNull
    private final LobbyConnector lobbyConnector;
    public static CloudVelocityPlugin instance;

    @Inject
    public CloudVelocityPlugin(@NotNull ProxyServer proxyServer) {
        Intrinsics.checkNotNullParameter(proxyServer, "proxyServer");
        this.proxyServer = proxyServer;
        this.lobbyConnector = new LobbyConnector();
        Companion.setInstance(this);
        new CloudPlugin(this);
        ICommunicationPromise synchronizedObjectPromise = CloudAPI.Companion.getInstance().getGlobalPropertyHolder().requestProperty("simplecloud-ingamecommands");
        synchronizedObjectPromise.addResultListener((Function1)new Function1<IProperty<String[]>, Unit>(){

            @Override
            public final void invoke(@NotNull IProperty<String[]> property) {
                String it;
                Object[] $this$forEach$iv;
                Intrinsics.checkNotNullParameter(property, "property");
                synchronizedIngameCommandsProperty = property;
                Object[] objectArray = this.getSynchronizedIngameCommandsProperty().getValue();
                CloudVelocityPlugin cloudVelocityPlugin = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    cloudVelocityPlugin.getProxyServer().getCommandManager().unregister(it);
                }
                $this$forEach$iv = this.getSynchronizedIngameCommandsProperty().getValue();
                cloudVelocityPlugin = this;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    CommandManager commandManager = cloudVelocityPlugin.getProxyServer().getCommandManager();
                    commandManager.register(commandManager.metaBuilder(it).build(), (Command)new VelocityCommand(it));
                }
            }
        }).throwFailure();
    }

    @NotNull
    public final ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    @NotNull
    public final IProperty<String[]> getSynchronizedIngameCommandsProperty() {
        IProperty<String[]> iProperty = this.synchronizedIngameCommandsProperty;
        if (iProperty != null) {
            return iProperty;
        }
        Intrinsics.throwUninitializedPropertyAccessException("synchronizedIngameCommandsProperty");
        return null;
    }

    @NotNull
    public final LobbyConnector getLobbyConnector() {
        return this.lobbyConnector;
    }

    /*
     * WARNING - void declaration
     */
    @Subscribe
    public final void handleInit(@NotNull ProxyInitializeEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        CloudPlugin.Companion.getInstance().onEnable();
        Iterable $this$filter$iv = CloudAPI.Companion.getInstance().getCloudServiceManager().getAllCachedObjects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudService it = (ICloudService)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudService it = (ICloudService)element$iv;
            boolean bl = false;
            this.addServiceToProxy(it);
        }
        CloudAPI.Companion.getInstance().getEventManager().registerListener(CloudPlugin.Companion.getInstance(), new CloudListener());
        this.proxyServer.getEventManager().register((Object)this, (Object)new VelocityListener(this));
        this.synchronizeOnlineCountTask();
        this.runOfflinePlayerChecker();
        CloudAPI.Companion.getInstance().getEventManager().registerListener(CloudPlugin.Companion.getInstance(), new CloudPlayerDisconnectListener(this.proxyServer));
    }

    @Subscribe
    public final void handleShutdown(@NotNull ProxyShutdownEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        CloudPlugin.Companion.getInstance().onDisable();
    }

    @Override
    public void addServiceToProxy(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter(cloudService, "cloudService");
        if (this.proxyServer.getServer(cloudService.getName()).isPresent()) {
            throw new IllegalArgumentException("Service is already registered!");
        }
        if (cloudService.getServiceType().isProxy()) {
            return;
        }
        ICloudServiceGroup cloudServiceGroup = cloudService.getServiceGroup();
        Intrinsics.checkNotNull(cloudServiceGroup, "null cannot be cast to non-null type eu.thesimplecloud.api.servicegroup.grouptype.ICloudServerGroup");
        if (((ICloudServerGroup)cloudServiceGroup).getHiddenAtProxyGroups().contains(CloudPlugin.Companion.getInstance().getGroupName())) {
            return;
        }
        System.out.println((Object)("Registered service " + cloudService.getName()));
        InetSocketAddress socketAddress = new InetSocketAddress(cloudService.getHost(), cloudService.getPort());
        this.registerService(cloudService.getName(), socketAddress);
    }

    private final void registerService(String name, InetSocketAddress socketAddress) {
        ServerInfo info = new ServerInfo(name, socketAddress);
        this.proxyServer.registerServer(info);
    }

    @Override
    public void removeServiceFromProxy(@NotNull ICloudService cloudService) {
        Intrinsics.checkNotNullParameter(cloudService, "cloudService");
        RegisteredServer registeredServer = this.proxyServer.getServer(cloudService.getName()).orElse(null);
        if (registeredServer == null) {
            return;
        }
        RegisteredServer registeredServer2 = registeredServer;
        this.proxyServer.unregisterServer(registeredServer2.getServerInfo());
    }

    private final void runOfflinePlayerChecker() {
        this.proxyServer.getScheduler().buildTask((Object)this, () -> CloudVelocityPlugin.runOfflinePlayerChecker$lambda$4(this)).delay(2L, TimeUnit.SECONDS).repeat(30L, TimeUnit.SECONDS).schedule();
    }

    private final void synchronizeOnlineCountTask() {
        this.proxyServer.getScheduler().buildTask((Object)this, () -> CloudVelocityPlugin.synchronizeOnlineCountTask$lambda$5(this)).repeat(30L, TimeUnit.SECONDS).schedule();
    }

    @Override
    public void shutdown() {
        this.proxyServer.getCommandManager().executeAsync((CommandSource)this.proxyServer.getConsoleCommandSource(), "shutdown");
    }

    @Override
    @NotNull
    public KClass<? extends ICloudPlayerManager> getCloudPlayerManagerClass() {
        return Reflection.getOrCreateKotlinClass(CloudPlayerManagerVelocity.class);
    }

    @Override
    public void onBeforeFirstUpdate() {
        ICloudProxyPlugin.DefaultImpls.onBeforeFirstUpdate(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final void runOfflinePlayerChecker$lambda$4(CloudVelocityPlugin this$0) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List playersOnThisService = CloudAPI.Companion.getInstance().getCloudPlayerManager().getAllCachedObjects();
        Iterable $this$filter$iv = playersOnThisService;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICloudPlayer it = (ICloudPlayer)element$iv$iv;
            boolean bl = false;
            if (!(this$0.proxyServer.getPlayer(it.getUniqueId()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersOffline = (List)destination$iv$iv;
        Iterable $this$forEach$iv = playersOffline;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICloudPlayer it = (ICloudPlayer)element$iv;
            boolean bl = false;
            ProxyEventHandler.INSTANCE.handleDisconnect(it.getUniqueId(), it.getName());
        }
    }

    private static final void synchronizeOnlineCountTask$lambda$5(CloudVelocityPlugin this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ICloudService service = CloudPlugin.Companion.getInstance().thisService();
        if (service.getOnlineCount() != this$0.proxyServer.getPlayerCount()) {
            service.setOnlineCount(this$0.proxyServer.getPlayerCount());
            service.update();
        }
    }

    @NotNull
    public static final CloudVelocityPlugin getInstance() {
        return Companion.getInstance();
    }

    public static final void setInstance(@NotNull CloudVelocityPlugin cloudVelocityPlugin) {
        Companion.setInstance(cloudVelocityPlugin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin$Companion;", "", "()V", "instance", "Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "getInstance$annotations", "getInstance", "()Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "setInstance", "(Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;)V", "simplecloud-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudVelocityPlugin getInstance() {
            CloudVelocityPlugin cloudVelocityPlugin = instance;
            if (cloudVelocityPlugin != null) {
                return cloudVelocityPlugin;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final void setInstance(@NotNull CloudVelocityPlugin cloudVelocityPlugin) {
            Intrinsics.checkNotNullParameter(cloudVelocityPlugin, "<set-?>");
            instance = cloudVelocityPlugin;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

