/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import _COROUTINE.ArtificialStackFrames;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineId;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.JobSupport;
import kotlinx.coroutines.debug.internal.AgentInstallationType;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMap;
import kotlinx.coroutines.debug.internal.DebugCoroutineInfo;
import kotlinx.coroutines.debug.internal.DebugCoroutineInfoImpl;
import kotlinx.coroutines.debug.internal.DebugProbesImpl;
import kotlinx.coroutines.debug.internal.DebugProbesImplKt;
import kotlinx.coroutines.debug.internal.DebuggerInfo;
import kotlinx.coroutines.debug.internal.StackTraceFrame;
import kotlinx.coroutines.internal.ScopeCoroutine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001}B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u00101\u001a\b\u0012\u0004\u0012\u0002H302\"\u0004\b\u0000\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H3022\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0001J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;J\u0011\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00010>\u00a2\u0006\u0002\u0010?J9\u0010@\u001a\b\u0012\u0004\u0012\u0002HA0;\"\b\b\u0000\u0010A*\u00020\u00012\u001e\b\u0004\u0010B\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u0002HA0CH\u0082\bJ\u0010\u0010E\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0002J\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0;J\"\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040;2\u0006\u0010I\u001a\u00020<2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040;J\u000e\u0010K\u001a\u00020)2\u0006\u0010I\u001a\u00020<J.\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040;2\u0006\u0010M\u001a\u00020)2\b\u0010N\u001a\u0004\u0018\u00010'2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040;H\u0002J=\u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020Q0P2\u0006\u0010R\u001a\u00020Q2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00040>2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040;H\u0002\u00a2\u0006\u0002\u0010TJ1\u0010U\u001a\u00020Q2\u0006\u0010V\u001a\u00020Q2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00040>2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040;H\u0002\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u0015\u0010Y\u001a\u00020)2\u0006\u0010Z\u001a\u00020*H\u0000\u00a2\u0006\u0002\b[J\r\u0010\\\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b]J\u001e\u0010^\u001a\u00020\u00142\u0006\u00108\u001a\u0002092\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00040;H\u0002J\u0014\u0010`\u001a\u00020\u00142\n\u0010a\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J'\u0010b\u001a\b\u0012\u0004\u0012\u0002H302\"\u0004\b\u0000\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H302H\u0000\u00a2\u0006\u0002\bcJ\u0019\u0010d\u001a\u00020\u00142\n\u00105\u001a\u0006\u0012\u0002\b\u000302H\u0000\u00a2\u0006\u0002\beJ\u0019\u0010f\u001a\u00020\u00142\n\u00105\u001a\u0006\u0012\u0002\b\u000302H\u0000\u00a2\u0006\u0002\bgJ%\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00040;\"\b\b\u0000\u00103*\u00020i2\u0006\u0010j\u001a\u0002H3H\u0002\u00a2\u0006\u0002\u0010kJ\b\u0010l\u001a\u00020\u0014H\u0002J\b\u0010m\u001a\u00020\u0014H\u0002J\r\u0010n\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\boJ\u0018\u0010p\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u00072\u0006\u0010M\u001a\u00020)H\u0002J\u001c\u0010q\u001a\u00020\u00142\n\u00105\u001a\u0006\u0012\u0002\b\u0003022\u0006\u0010M\u001a\u00020)H\u0002J(\u0010q\u001a\u00020\u00142\n\u0010a\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u00105\u001a\u0006\u0012\u0002\b\u0003022\u0006\u0010M\u001a\u00020)H\u0002J4\u0010r\u001a\u00020\u0014*\u00020*2\u0012\u0010s\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\b0t2\n\u0010u\u001a\u00060vj\u0002`w2\u0006\u0010x\u001a\u00020)H\u0002J\u0010\u0010y\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0016\u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u0006\u0012\u0002\b\u000302H\u0002J\u0013\u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\u0007H\u0082\u0010J\u000f\u0010z\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0082\u0010J\u0012\u0010{\u001a\u000206*\b\u0012\u0004\u0012\u00020\u00040;H\u0002J\f\u0010|\u001a\u00020)*\u00020\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\t\u0010\u001d\u001a\u00020\u001eX\u0082\u0004R\u0011\u0010\u001f\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010\u0019R\t\u0010$\u001a\u00020%X\u0082\u0004R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020)*\u00020*8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u00020\u000f*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006~"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl;", "", "()V", "ARTIFICIAL_FRAME", "Ljava/lang/StackTraceElement;", "callerInfoCache", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/debug/internal/DebugCoroutineInfoImpl;", "capturedCoroutines", "", "Lkotlinx/coroutines/debug/internal/DebugProbesImpl$CoroutineOwner;", "getCapturedCoroutines", "()Ljava/util/Set;", "capturedCoroutinesMap", "", "dateFormat", "Ljava/text/SimpleDateFormat;", "dynamicAttach", "Lkotlin/Function1;", "", "enableCreationStackTraces", "getEnableCreationStackTraces$kotlinx_coroutines_core", "()Z", "setEnableCreationStackTraces$kotlinx_coroutines_core", "(Z)V", "ignoreCoroutinesWithEmptyContext", "getIgnoreCoroutinesWithEmptyContext", "setIgnoreCoroutinesWithEmptyContext", "installations", "Lkotlinx/atomicfu/AtomicInt;", "isInstalled", "isInstalled$kotlinx_coroutines_debug", "sanitizeStackTraces", "getSanitizeStackTraces$kotlinx_coroutines_core", "setSanitizeStackTraces$kotlinx_coroutines_core", "sequenceNumber", "Lkotlinx/atomicfu/AtomicLong;", "weakRefCleanerThread", "Ljava/lang/Thread;", "debugString", "", "Lkotlinx/coroutines/Job;", "getDebugString$annotations", "(Lkotlinx/coroutines/Job;)V", "getDebugString", "(Lkotlinx/coroutines/Job;)Ljava/lang/String;", "isInternalMethod", "(Ljava/lang/StackTraceElement;)Z", "createOwner", "Lkotlin/coroutines/Continuation;", "T", "completion", "frame", "Lkotlinx/coroutines/debug/internal/StackTraceFrame;", "dumpCoroutines", "out", "Ljava/io/PrintStream;", "dumpCoroutinesInfo", "", "Lkotlinx/coroutines/debug/internal/DebugCoroutineInfo;", "dumpCoroutinesInfoAsJsonAndReferences", "", "()[Ljava/lang/Object;", "dumpCoroutinesInfoImpl", "R", "create", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext;", "dumpCoroutinesSynchronized", "dumpDebuggerInfo", "Lkotlinx/coroutines/debug/internal/DebuggerInfo;", "enhanceStackTraceWithThreadDump", "info", "coroutineTrace", "enhanceStackTraceWithThreadDumpAsJson", "enhanceStackTraceWithThreadDumpImpl", "state", "thread", "findContinuationStartIndex", "Lkotlin/Pair;", "", "indexOfResumeWith", "actualTrace", "(I[Ljava/lang/StackTraceElement;Ljava/util/List;)Lkotlin/Pair;", "findIndexOfFrame", "frameIndex", "(I[Ljava/lang/StackTraceElement;Ljava/util/List;)I", "getDynamicAttach", "hierarchyToString", "job", "hierarchyToString$kotlinx_coroutines_core", "install", "install$kotlinx_coroutines_core", "printStackTrace", "frames", "probeCoroutineCompleted", "owner", "probeCoroutineCreated", "probeCoroutineCreated$kotlinx_coroutines_core", "probeCoroutineResumed", "probeCoroutineResumed$kotlinx_coroutines_core", "probeCoroutineSuspended", "probeCoroutineSuspended$kotlinx_coroutines_core", "sanitizeStackTrace", "", "throwable", "(Ljava/lang/Throwable;)Ljava/util/List;", "startWeakRefCleanerThread", "stopWeakRefCleanerThread", "uninstall", "uninstall$kotlinx_coroutines_core", "updateRunningState", "updateState", "build", "map", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "isFinished", "realCaller", "toStackTraceFrame", "toStringRepr", "CoroutineOwner", "kotlinx-coroutines-core"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nDebugProbesImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugProbesImpl.kt\nkotlinx/coroutines/debug/internal/DebugProbesImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,620:1\n150#1:638\n151#1,4:640\n156#1,5:645\n150#1:650\n151#1,4:652\n156#1,5:657\n1#2:621\n1#2:639\n1#2:651\n766#3:622\n857#3,2:623\n1208#3,2:625\n1238#3,4:627\n1855#3,2:665\n350#3,7:673\n1819#3,8:680\n603#4:631\n603#4:644\n603#4:656\n603#4:662\n1295#4,2:663\n37#5,2:632\n37#5,2:634\n37#5,2:636\n1627#6,6:667\n1735#6,6:688\n*S KotlinDebug\n*F\n+ 1 DebugProbesImpl.kt\nkotlinx/coroutines/debug/internal/DebugProbesImpl\n*L\n245#1:638\n245#1:640,4\n245#1:645,5\n252#1:650\n252#1:652,4\n252#1:657,5\n245#1:639\n252#1:651\n110#1:622\n110#1:623,2\n111#1:625,2\n111#1:627,4\n307#1:665,2\n416#1:673,7\n506#1:680,8\n154#1:631\n245#1:644\n252#1:656\n287#1:662\n288#1:663,2\n211#1:632,2\n212#1:634,2\n213#1:636,2\n355#1:667,6\n558#1:688,6\n*E\n"})
public final class DebugProbesImpl {
    @NotNull
    public static final DebugProbesImpl INSTANCE = new DebugProbesImpl();
    @NotNull
    private static final StackTraceElement ARTIFICIAL_FRAME = new ArtificialStackFrames().coroutineCreation();
    @NotNull
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    @Nullable
    private static Thread weakRefCleanerThread;
    @NotNull
    private static final ConcurrentWeakMap<CoroutineOwner<?>, Boolean> capturedCoroutinesMap;
    private static boolean sanitizeStackTraces;
    private static boolean enableCreationStackTraces;
    private static boolean ignoreCoroutinesWithEmptyContext;
    @Nullable
    private static final Function1<Boolean, Unit> dynamicAttach;
    @NotNull
    private static final ConcurrentWeakMap<CoroutineStackFrame, DebugCoroutineInfoImpl> callerInfoCache;
    @NotNull
    private static final Installations.kotlinx.VolatileWrapper installations$kotlinx$VolatileWrapper;
    @NotNull
    private static final SequenceNumber.kotlinx.VolatileWrapper sequenceNumber$kotlinx$VolatileWrapper;

    private DebugProbesImpl() {
    }

    private final Set<CoroutineOwner<?>> getCapturedCoroutines() {
        return capturedCoroutinesMap.keySet();
    }

    @JvmName(name="isInstalled$kotlinx_coroutines_debug")
    public final boolean isInstalled$kotlinx_coroutines_debug() {
        return Installations.kotlinx.VolatileWrapper.installations$FU.get(installations$kotlinx$VolatileWrapper) > 0;
    }

    public final boolean getSanitizeStackTraces$kotlinx_coroutines_core() {
        return sanitizeStackTraces;
    }

    public final void setSanitizeStackTraces$kotlinx_coroutines_core(boolean bl) {
        sanitizeStackTraces = bl;
    }

    public final boolean getEnableCreationStackTraces$kotlinx_coroutines_core() {
        return enableCreationStackTraces;
    }

    public final void setEnableCreationStackTraces$kotlinx_coroutines_core(boolean bl) {
        enableCreationStackTraces = bl;
    }

    public final boolean getIgnoreCoroutinesWithEmptyContext() {
        return ignoreCoroutinesWithEmptyContext;
    }

    public final void setIgnoreCoroutinesWithEmptyContext(boolean bl) {
        ignoreCoroutinesWithEmptyContext = bl;
    }

    private final Function1<Boolean, Unit> getDynamicAttach() {
        Object object;
        Object object2 = this;
        try {
            DebugProbesImpl $this$getDynamicAttach_u24lambda_u240 = object2;
            boolean bl = false;
            Class<?> clz = Class.forName("kotlinx.coroutines.debug.internal.ByteBuddyDynamicAttach");
            Constructor<?> ctor = clz.getConstructors()[0];
            Object obj = ctor.newInstance(new Object[0]);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Function1<kotlin.Boolean, kotlin.Unit>");
            object = Result.constructor-impl((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(obj, 1));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        return (Function1)(Result.isFailure-impl(object2) ? null : object2);
    }

    public final void install$kotlinx_coroutines_core() {
        block2: {
            if (Installations.kotlinx.VolatileWrapper.installations$FU.incrementAndGet(installations$kotlinx$VolatileWrapper) > 1) {
                return;
            }
            this.startWeakRefCleanerThread();
            if (AgentInstallationType.INSTANCE.isInstalledStatically$kotlinx_coroutines_core()) {
                return;
            }
            Function1<Boolean, Unit> function1 = dynamicAttach;
            if (function1 == null) break block2;
            function1.invoke(true);
        }
    }

    public final void uninstall$kotlinx_coroutines_core() {
        block3: {
            if (!this.isInstalled$kotlinx_coroutines_debug()) {
                boolean bl = false;
                String string = "Agent was not installed";
                throw new IllegalStateException(string.toString());
            }
            if (Installations.kotlinx.VolatileWrapper.installations$FU.decrementAndGet(installations$kotlinx$VolatileWrapper) != 0) {
                return;
            }
            this.stopWeakRefCleanerThread();
            capturedCoroutinesMap.clear();
            callerInfoCache.clear();
            if (AgentInstallationType.INSTANCE.isInstalledStatically$kotlinx_coroutines_core()) {
                return;
            }
            Function1<Boolean, Unit> function1 = dynamicAttach;
            if (function1 == null) break block3;
            function1.invoke(false);
        }
    }

    private final void startWeakRefCleanerThread() {
        weakRefCleanerThread = ThreadsKt.thread$default(false, true, null, "Coroutines Debugger Cleaner", 0, startWeakRefCleanerThread.1.INSTANCE, 21, null);
    }

    private final void stopWeakRefCleanerThread() {
        Thread thread2 = weakRefCleanerThread;
        if (thread2 == null) {
            return;
        }
        Thread thread3 = thread2;
        weakRefCleanerThread = null;
        thread3.interrupt();
        thread3.join();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String hierarchyToString$kotlinx_coroutines_core(@NotNull Job job2) {
        StringBuilder stringBuilder;
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            boolean $i$a$-check-DebugProbesImpl$hierarchyToString$22 = false;
            String $i$a$-check-DebugProbesImpl$hierarchyToString$22 = "Debug probes are not installed";
            throw new IllegalStateException($i$a$-check-DebugProbesImpl$hierarchyToString$22.toString());
        }
        Iterable $this$filter$iv = this.getCapturedCoroutines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoroutineOwner it = (CoroutineOwner)element$iv$iv;
            boolean bl = false;
            if (!(it.delegate.getContext().get(Job.Key) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            CoroutineOwner bl = (CoroutineOwner)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            CoroutineOwner it = (CoroutineOwner)element$iv$iv;
            Job job3 = JobKt.getJob(it.delegate.getContext());
            boolean bl3 = false;
            DebugCoroutineInfoImpl debugCoroutineInfoImpl = it.info;
            map2.put(job3, debugCoroutineInfoImpl);
        }
        Map jobToStack = destination$iv$iv2;
        StringBuilder $this$hierarchyToString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.build(job2, jobToStack, $this$hierarchyToString_u24lambda_u246, "");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void build(Job $this$build, Map<Job, DebugCoroutineInfoImpl> map2, StringBuilder builder, String indent) {
        DebugCoroutineInfoImpl info = map2.get($this$build);
        String newIndent = null;
        if (info == null) {
            if (!($this$build instanceof ScopeCoroutine)) {
                builder.append(indent + this.getDebugString($this$build) + '\n');
                newIndent = indent + '\t';
            } else {
                newIndent = indent;
            }
        } else {
            StackTraceElement element = CollectionsKt.firstOrNull(info.lastObservedStackTrace$kotlinx_coroutines_core());
            String state = info.getState$kotlinx_coroutines_core();
            builder.append(indent + this.getDebugString($this$build) + ", continuation is " + state + " at line " + element + '\n');
            newIndent = indent + '\t';
        }
        Iterator<Job> iterator2 = $this$build.getChildren().iterator();
        while (iterator2.hasNext()) {
            Job child = iterator2.next();
            this.build(child, map2, builder, newIndent);
        }
    }

    private final String getDebugString(Job $this$debugString) {
        return $this$debugString instanceof JobSupport ? ((JobSupport)$this$debugString).toDebugString() : $this$debugString.toString();
    }

    private static /* synthetic */ void getDebugString$annotations(Job job2) {
    }

    private final <R> List<R> dumpCoroutinesInfoImpl(Function2<? super CoroutineOwner<?>, ? super CoroutineContext, ? extends R> create) {
        boolean $i$f$dumpCoroutinesInfoImpl = false;
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            boolean $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$22 = false;
            String $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$22 = "Debug probes are not installed";
            throw new IllegalStateException($i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$22.toString());
        }
        Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)this.getCapturedCoroutines());
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                CoroutineOwner it = (CoroutineOwner)a;
                boolean bl = false;
                it = (CoroutineOwner)b;
                Comparable comparable = Long.valueOf(it.info.sequenceNumber);
                bl = false;
                return ComparisonsKt.compareValues(comparable, it.info.sequenceNumber);
            }
        }), new Function1<CoroutineOwner<?>, R>(create){
            final /* synthetic */ Function2<CoroutineOwner<?>, CoroutineContext, R> $create;
            {
                this.$create = $create;
                super(1);
            }

            @Nullable
            public final R invoke(@NotNull CoroutineOwner<?> owner) {
                Object v0;
                if (DebugProbesImpl.access$isFinished(DebugProbesImpl.INSTANCE, owner)) {
                    v0 = null;
                } else {
                    CoroutineContext coroutineContext = owner.info.getContext();
                    if (coroutineContext != null) {
                        CoroutineContext coroutineContext2 = coroutineContext;
                        Function2<CoroutineOwner<?>, CoroutineContext, R> function2 = this.$create;
                        CoroutineContext context = coroutineContext2;
                        boolean bl = false;
                        v0 = function2.invoke(owner, context);
                    } else {
                        v0 = null;
                    }
                }
                return v0;
            }
        }));
    }

    @NotNull
    public final Object[] dumpCoroutinesInfoAsJsonAndReferences() {
        List<DebugCoroutineInfo> coroutinesInfo = this.dumpCoroutinesInfo();
        int size = coroutinesInfo.size();
        ArrayList<Thread> lastObservedThreads = new ArrayList<Thread>(size);
        ArrayList<CoroutineStackFrame> lastObservedFrames = new ArrayList<CoroutineStackFrame>(size);
        ArrayList<String> coroutinesInfoAsJson = new ArrayList<String>(size);
        for (DebugCoroutineInfo info : coroutinesInfo) {
            CoroutineContext context = info.getContext();
            Object object = (CoroutineName)context.get(CoroutineName.Key);
            String name = object != null && (object = ((CoroutineName)object).getName()) != null ? this.toStringRepr(object) : null;
            CoroutineDispatcher coroutineDispatcher = (CoroutineDispatcher)context.get(CoroutineDispatcher.Key);
            String dispatcher = coroutineDispatcher != null ? this.toStringRepr(coroutineDispatcher) : null;
            CoroutineId coroutineId = (CoroutineId)context.get(CoroutineId.Key);
            coroutinesInfoAsJson.add(StringsKt.trimIndent("\n                {\n                    \"name\": " + name + ",\n                    \"id\": " + (coroutineId != null ? Long.valueOf(coroutineId.getId()) : null) + ",\n                    \"dispatcher\": " + dispatcher + ",\n                    \"sequenceNumber\": " + info.getSequenceNumber() + ",\n                    \"state\": \"" + info.getState() + "\"\n                } \n                "));
            lastObservedFrames.add(info.getLastObservedFrame());
            lastObservedThreads.add(info.getLastObservedThread());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = '[' + CollectionsKt.joinToString$default(coroutinesInfoAsJson, null, null, null, 0, null, null, 63, null) + ']';
        Collection $this$toTypedArray$iv = lastObservedThreads;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray[1] = thisCollection$iv.toArray(new Thread[0]);
        $this$toTypedArray$iv = lastObservedFrames;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        objectArray[2] = thisCollection$iv.toArray(new CoroutineStackFrame[0]);
        $this$toTypedArray$iv = coroutinesInfo;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        objectArray[3] = thisCollection$iv.toArray(new DebugCoroutineInfo[0]);
        return objectArray;
    }

    @NotNull
    public final String enhanceStackTraceWithThreadDumpAsJson(@NotNull DebugCoroutineInfo info) {
        List<StackTraceElement> stackTraceElements = this.enhanceStackTraceWithThreadDump(info, info.lastObservedStackTrace());
        List stackTraceElementsInfoAsJson = new ArrayList();
        for (StackTraceElement element : stackTraceElements) {
            String string = element.getFileName();
            stackTraceElementsInfoAsJson.add(StringsKt.trimIndent("\n                {\n                    \"declaringClass\": \"" + element.getClassName() + "\",\n                    \"methodName\": \"" + element.getMethodName() + "\",\n                    \"fileName\": " + (string != null ? this.toStringRepr(string) : null) + ",\n                    \"lineNumber\": " + element.getLineNumber() + "\n                }\n                "));
        }
        return '[' + CollectionsKt.joinToString$default(stackTraceElementsInfoAsJson, null, null, null, 0, null, null, 63, null) + ']';
    }

    private final String toStringRepr(Object $this$toStringRepr) {
        return DebugProbesImplKt.access$repr($this$toStringRepr.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebugCoroutineInfo> dumpCoroutinesInfo() {
        void $this$sortedBy$iv$iv;
        DebugProbesImpl this_$iv = this;
        boolean $i$f$dumpCoroutinesInfoImpl = false;
        if (!this_$iv.isInstalled$kotlinx_coroutines_debug()) {
            boolean $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22 = false;
            String $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22 = "Debug probes are not installed";
            throw new IllegalStateException($i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22.toString());
        }
        Sequence sequence = CollectionsKt.asSequence((Iterable)this_$iv.getCapturedCoroutines());
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.sortedWith($this$sortedBy$iv$iv, new /* invalid duplicate definition of identical inner class */), new Function1<CoroutineOwner<?>, DebugCoroutineInfo>(){

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DebugCoroutineInfo invoke(@NotNull CoroutineOwner<?> owner) {
                DebugCoroutineInfo debugCoroutineInfo;
                if (DebugProbesImpl.access$isFinished(DebugProbesImpl.INSTANCE, owner)) {
                    debugCoroutineInfo = null;
                } else {
                    CoroutineContext coroutineContext = owner.info.getContext();
                    if (coroutineContext != null) {
                        void context;
                        CoroutineContext context2 = coroutineContext;
                        boolean bl = false;
                        CoroutineContext coroutineContext2 = context2;
                        CoroutineOwner<?> owner2 = owner;
                        boolean bl2 = false;
                        debugCoroutineInfo = new DebugCoroutineInfo(owner2.info, (CoroutineContext)context);
                    } else {
                        debugCoroutineInfo = null;
                    }
                }
                return debugCoroutineInfo;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebuggerInfo> dumpDebuggerInfo() {
        void $this$sortedBy$iv$iv;
        DebugProbesImpl this_$iv = this;
        boolean $i$f$dumpCoroutinesInfoImpl = false;
        if (!this_$iv.isInstalled$kotlinx_coroutines_debug()) {
            boolean $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22 = false;
            String $i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22 = "Debug probes are not installed";
            throw new IllegalStateException($i$a$-check-DebugProbesImpl$dumpCoroutinesInfoImpl$1$iv22.toString());
        }
        Sequence sequence = CollectionsKt.asSequence((Iterable)this_$iv.getCapturedCoroutines());
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.sortedWith($this$sortedBy$iv$iv, new /* invalid duplicate definition of identical inner class */), new Function1<CoroutineOwner<?>, DebuggerInfo>(){

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DebuggerInfo invoke(@NotNull CoroutineOwner<?> owner) {
                DebuggerInfo debuggerInfo;
                if (DebugProbesImpl.access$isFinished(DebugProbesImpl.INSTANCE, owner)) {
                    debuggerInfo = null;
                } else {
                    CoroutineContext coroutineContext = owner.info.getContext();
                    if (coroutineContext != null) {
                        void context;
                        CoroutineContext context2 = coroutineContext;
                        boolean bl = false;
                        CoroutineContext coroutineContext2 = context2;
                        CoroutineOwner<?> owner2 = owner;
                        boolean bl2 = false;
                        debuggerInfo = new DebuggerInfo(owner2.info, (CoroutineContext)context);
                    } else {
                        debuggerInfo = null;
                    }
                }
                return debuggerInfo;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="dumpCoroutines")
    public final void dumpCoroutines(@NotNull PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            boolean bl = false;
            INSTANCE.dumpCoroutinesSynchronized(out);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isFinished(CoroutineOwner<?> $this$isFinished) {
        CoroutineContext coroutineContext = $this$isFinished.info.getContext();
        if (coroutineContext == null || (coroutineContext = (Job)coroutineContext.get(Job.Key)) == null) {
            return false;
        }
        CoroutineContext job2 = coroutineContext;
        if (!job2.isCompleted()) {
            return false;
        }
        capturedCoroutinesMap.remove($this$isFinished);
        return true;
    }

    private final void dumpCoroutinesSynchronized(PrintStream out) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            boolean $i$a$-check-DebugProbesImpl$dumpCoroutinesSynchronized$22 = false;
            String $i$a$-check-DebugProbesImpl$dumpCoroutinesSynchronized$22 = "Debug probes are not installed";
            throw new IllegalStateException($i$a$-check-DebugProbesImpl$dumpCoroutinesSynchronized$22.toString());
        }
        out.print("Coroutines dump " + dateFormat.format(System.currentTimeMillis()));
        Sequence $this$sortedBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getCapturedCoroutines()), dumpCoroutinesSynchronized.2.INSTANCE);
        boolean $i$f$sortedBy = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                CoroutineOwner it = (CoroutineOwner)a;
                boolean bl = false;
                it = (CoroutineOwner)b;
                Comparable comparable = Long.valueOf(it.info.sequenceNumber);
                bl = false;
                return ComparisonsKt.compareValues(comparable, it.info.sequenceNumber);
            }
        });
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            CoroutineOwner owner = (CoroutineOwner)element$iv;
            boolean bl = false;
            DebugCoroutineInfoImpl info = owner.info;
            List<StackTraceElement> observedStackTrace = info.lastObservedStackTrace$kotlinx_coroutines_core();
            List<StackTraceElement> enhancedStackTrace = INSTANCE.enhanceStackTraceWithThreadDumpImpl(info.getState$kotlinx_coroutines_core(), info.lastObservedThread, observedStackTrace);
            String state = Intrinsics.areEqual(info.getState$kotlinx_coroutines_core(), "RUNNING") && enhancedStackTrace == observedStackTrace ? info.getState$kotlinx_coroutines_core() + " (Last suspension stacktrace, not an actual stacktrace)" : info.getState$kotlinx_coroutines_core();
            out.print("\n\nCoroutine " + owner.delegate + ", state: " + state);
            if (observedStackTrace.isEmpty()) {
                out.print("\n\tat " + ARTIFICIAL_FRAME);
                INSTANCE.printStackTrace(out, info.getCreationStackTrace());
                continue;
            }
            INSTANCE.printStackTrace(out, enhancedStackTrace);
        }
    }

    private final void printStackTrace(PrintStream out, List<StackTraceElement> frames) {
        Iterable $this$forEach$iv = frames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackTraceElement frame = (StackTraceElement)element$iv;
            boolean bl = false;
            out.print("\n\tat " + frame);
        }
    }

    @NotNull
    public final List<StackTraceElement> enhanceStackTraceWithThreadDump(@NotNull DebugCoroutineInfo info, @NotNull List<StackTraceElement> coroutineTrace) {
        return this.enhanceStackTraceWithThreadDumpImpl(info.getState(), info.getLastObservedThread(), coroutineTrace);
    }

    private final List<StackTraceElement> enhanceStackTraceWithThreadDumpImpl(String state, Thread thread2, List<StackTraceElement> coroutineTrace) {
        int index;
        int n;
        StackTraceElement[] actualTrace;
        Pair<Integer, Integer> pair;
        block8: {
            Object $this$enhanceStackTraceWithThreadDumpImpl_u24lambda_u2416;
            if (!Intrinsics.areEqual(state, "RUNNING") || thread2 == null) {
                return coroutineTrace;
            }
            pair = this;
            try {
                $this$enhanceStackTraceWithThreadDumpImpl_u24lambda_u2416 = pair;
                boolean bl = false;
                $this$enhanceStackTraceWithThreadDumpImpl_u24lambda_u2416 = Result.constructor-impl(thread2.getStackTrace());
            }
            catch (Throwable bl) {
                $this$enhanceStackTraceWithThreadDumpImpl_u24lambda_u2416 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            pair = $this$enhanceStackTraceWithThreadDumpImpl_u24lambda_u2416;
            StackTraceElement[] stackTraceElementArray = (StackTraceElement[])(Result.isFailure-impl(pair) ? null : pair);
            if (stackTraceElementArray == null) {
                return coroutineTrace;
            }
            StackTraceElement[] $this$indexOfFirst$iv = actualTrace = stackTraceElementArray;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(it.getClassName(), "kotlin.coroutines.jvm.internal.BaseContinuationImpl") && Intrinsics.areEqual(it.getMethodName(), "resumeWith") && Intrinsics.areEqual(it.getFileName(), "ContinuationImpl.kt");
                if (!bl2) continue;
                n = index$iv;
                break block8;
            }
            n = -1;
        }
        int indexOfResumeWith = n;
        pair = this.findContinuationStartIndex(indexOfResumeWith, actualTrace, coroutineTrace);
        int continuationStartFrame = ((Number)pair.component1()).intValue();
        int delta = ((Number)pair.component2()).intValue();
        if (continuationStartFrame == -1) {
            return coroutineTrace;
        }
        int expectedSize = indexOfResumeWith + coroutineTrace.size() - continuationStartFrame - 1 - delta;
        ArrayList result2 = new ArrayList(expectedSize);
        int n3 = indexOfResumeWith - delta;
        for (index = 0; index < n3; ++index) {
            ((Collection)result2).add(actualTrace[index]);
        }
        n3 = coroutineTrace.size();
        for (index = continuationStartFrame + 1; index < n3; ++index) {
            ((Collection)result2).add(coroutineTrace.get(index));
        }
        return result2;
    }

    private final Pair<Integer, Integer> findContinuationStartIndex(int indexOfResumeWith, StackTraceElement[] actualTrace, List<StackTraceElement> coroutineTrace) {
        int n = 3;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            int result2 = INSTANCE.findIndexOfFrame(indexOfResumeWith - 1 - it, actualTrace, coroutineTrace);
            if (result2 == -1) continue;
            return TuplesKt.to(result2, it);
        }
        return TuplesKt.to(-1, 0);
    }

    private final int findIndexOfFrame(int frameIndex, StackTraceElement[] actualTrace, List<StackTraceElement> coroutineTrace) {
        int n;
        block3: {
            StackTraceElement stackTraceElement = ArraysKt.getOrNull(actualTrace, frameIndex);
            if (stackTraceElement == null) {
                return -1;
            }
            StackTraceElement continuationFrame = stackTraceElement;
            List<StackTraceElement> $this$indexOfFirst$iv = coroutineTrace;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<StackTraceElement> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                StackTraceElement item$iv;
                StackTraceElement it = item$iv = iterator2.next();
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(it.getFileName(), continuationFrame.getFileName()) && Intrinsics.areEqual(it.getClassName(), continuationFrame.getClassName()) && Intrinsics.areEqual(it.getMethodName(), continuationFrame.getMethodName());
                if (bl2) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final void probeCoroutineResumed$kotlinx_coroutines_core(@NotNull Continuation<?> frame) {
        this.updateState(frame, "RUNNING");
    }

    public final void probeCoroutineSuspended$kotlinx_coroutines_core(@NotNull Continuation<?> frame) {
        this.updateState(frame, "SUSPENDED");
    }

    private final void updateState(Continuation<?> frame, String state) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            return;
        }
        if (ignoreCoroutinesWithEmptyContext && frame.getContext() == EmptyCoroutineContext.INSTANCE) {
            return;
        }
        if (Intrinsics.areEqual(state, "RUNNING")) {
            CoroutineStackFrame coroutineStackFrame = frame instanceof CoroutineStackFrame ? (CoroutineStackFrame)((Object)frame) : null;
            if (coroutineStackFrame == null) {
                return;
            }
            CoroutineStackFrame stackFrame = coroutineStackFrame;
            this.updateRunningState(stackFrame, state);
            return;
        }
        CoroutineOwner<?> coroutineOwner = this.owner(frame);
        if (coroutineOwner == null) {
            return;
        }
        CoroutineOwner<?> owner = coroutineOwner;
        this.updateState(owner, frame, state);
    }

    private final void updateRunningState(CoroutineStackFrame frame, String state) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            return;
        }
        Object info = null;
        DebugCoroutineInfoImpl cached = callerInfoCache.remove(frame);
        boolean shouldBeMatchedWithProbeSuspended = false;
        if (cached != null) {
            info = cached;
            shouldBeMatchedWithProbeSuspended = false;
        } else {
            CoroutineStackFrame realCaller;
            CoroutineOwner<?> coroutineOwner = this.owner(frame);
            if (coroutineOwner == null || (coroutineOwner = coroutineOwner.info) == null) {
                return;
            }
            info = coroutineOwner;
            shouldBeMatchedWithProbeSuspended = true;
            CoroutineStackFrame coroutineStackFrame = ((DebugCoroutineInfoImpl)info).getLastObservedFrame$kotlinx_coroutines_core();
            CoroutineStackFrame coroutineStackFrame2 = realCaller = coroutineStackFrame != null ? this.realCaller(coroutineStackFrame) : null;
            if (realCaller != null) {
                callerInfoCache.remove(realCaller);
            }
        }
        Intrinsics.checkNotNull(frame, "null cannot be cast to non-null type kotlin.coroutines.Continuation<*>");
        ((DebugCoroutineInfoImpl)info).updateState$kotlinx_coroutines_core(state, (Continuation)((Object)frame), shouldBeMatchedWithProbeSuspended);
        CoroutineStackFrame coroutineStackFrame = this.realCaller(frame);
        if (coroutineStackFrame == null) {
            return;
        }
        CoroutineStackFrame caller = coroutineStackFrame;
        ((Map)callerInfoCache).put(caller, info);
    }

    private final CoroutineStackFrame realCaller(CoroutineStackFrame $this$realCaller) {
        CoroutineStackFrame caller;
        while (true) {
            if ($this$realCaller.getCallerFrame() == null) {
                return null;
            }
            if (caller.getStackTraceElement() != null) break;
            $this$realCaller = caller;
        }
        return caller;
    }

    private final void updateState(CoroutineOwner<?> owner, Continuation<?> frame, String state) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            return;
        }
        owner.info.updateState$kotlinx_coroutines_core(state, frame, true);
    }

    private final CoroutineOwner<?> owner(Continuation<?> $this$owner) {
        CoroutineStackFrame coroutineStackFrame = $this$owner instanceof CoroutineStackFrame ? (CoroutineStackFrame)((Object)$this$owner) : null;
        return coroutineStackFrame != null ? this.owner(coroutineStackFrame) : null;
    }

    private final CoroutineOwner<?> owner(CoroutineStackFrame $this$owner) {
        CoroutineOwner coroutineOwner;
        block2: {
            while (true) {
                if ($this$owner instanceof CoroutineOwner) {
                    coroutineOwner = (CoroutineOwner)$this$owner;
                    break block2;
                }
                CoroutineStackFrame coroutineStackFrame = $this$owner.getCallerFrame();
                if (coroutineStackFrame == null) break;
                $this$owner = coroutineStackFrame;
            }
            coroutineOwner = null;
        }
        return coroutineOwner;
    }

    @NotNull
    public final <T> Continuation<T> probeCoroutineCreated$kotlinx_coroutines_core(@NotNull Continuation<? super T> completion) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            return completion;
        }
        if (ignoreCoroutinesWithEmptyContext && completion.getContext() == EmptyCoroutineContext.INSTANCE) {
            return completion;
        }
        CoroutineOwner<?> owner = this.owner(completion);
        if (owner != null) {
            return completion;
        }
        StackTraceFrame frame = enableCreationStackTraces ? this.toStackTraceFrame(this.sanitizeStackTrace((Throwable)new Exception())) : null;
        return this.createOwner(completion, frame);
    }

    /*
     * WARNING - void declaration
     */
    private final StackTraceFrame toStackTraceFrame(List<StackTraceElement> $this$toStackTraceFrame) {
        void $this$foldRight$iv;
        List<StackTraceElement> list = $this$toStackTraceFrame;
        StackTraceFrame initial$iv = null;
        boolean $i$f$foldRight = false;
        StackTraceFrame accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                StackTraceFrame stackTraceFrame = accumulator$iv;
                StackTraceElement frame = (StackTraceElement)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = new StackTraceFrame((CoroutineStackFrame)acc, frame);
            }
        }
        StackTraceElement stackTraceElement = ARTIFICIAL_FRAME;
        CoroutineStackFrame coroutineStackFrame = accumulator$iv;
        return new StackTraceFrame(coroutineStackFrame, stackTraceElement);
    }

    private final <T> Continuation<T> createOwner(Continuation<? super T> completion, StackTraceFrame frame) {
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            return completion;
        }
        DebugCoroutineInfoImpl info = new DebugCoroutineInfoImpl(completion.getContext(), frame, SequenceNumber.kotlinx.VolatileWrapper.sequenceNumber$FU.incrementAndGet(sequenceNumber$kotlinx$VolatileWrapper));
        CoroutineOwner<? super T> owner = new CoroutineOwner<T>(completion, info);
        ((Map)capturedCoroutinesMap).put(owner, true);
        if (!this.isInstalled$kotlinx_coroutines_debug()) {
            capturedCoroutinesMap.clear();
        }
        return owner;
    }

    private final void probeCoroutineCompleted(CoroutineOwner<?> owner) {
        capturedCoroutinesMap.remove(owner);
        CoroutineStackFrame coroutineStackFrame = owner.info.getLastObservedFrame$kotlinx_coroutines_core();
        if (coroutineStackFrame == null || (coroutineStackFrame = this.realCaller(coroutineStackFrame)) == null) {
            return;
        }
        CoroutineStackFrame caller = coroutineStackFrame;
        callerInfoCache.remove(caller);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Throwable> List<StackTraceElement> sanitizeStackTrace(T throwable) {
        int n;
        int index$iv;
        int n2;
        int n3;
        int size;
        StackTraceElement[] stackTrace;
        block9: {
            void $this$indexOfLast$iv;
            stackTrace = throwable.getStackTrace();
            size = stackTrace.length;
            StackTraceElement[] stackTraceElementArray = stackTrace;
            n3 = 1;
            boolean $i$f$indexOfLast = false;
            n2 = ((void)$this$indexOfLast$iv).length + -1;
            if (0 <= n2) {
                do {
                    index$iv = n2--;
                    void it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getClassName(), "kotlin.coroutines.jvm.internal.DebugProbesKt")) continue;
                    n = index$iv;
                    break block9;
                } while (0 <= n2);
            }
            n = -1;
        }
        int n4 = n;
        int traceStart = n3 + n4;
        if (!sanitizeStackTraces) {
            int $this$indexOfLast$iv = size - traceStart;
            ArrayList<StackTraceElement> $i$f$indexOfLast = new ArrayList<StackTraceElement>($this$indexOfLast$iv);
            n2 = 0;
            while (n2 < $this$indexOfLast$iv) {
                int it = index$iv = n2++;
                ArrayList<StackTraceElement> arrayList = $i$f$indexOfLast;
                boolean bl = false;
                arrayList.add(stackTrace[it + traceStart]);
            }
            return $i$f$indexOfLast;
        }
        ArrayList result2 = new ArrayList(size - traceStart + 1);
        int i = traceStart;
        while (i < size) {
            if (this.isInternalMethod(stackTrace[i])) {
                int k;
                int j;
                ((Collection)result2).add(stackTrace[i]);
                for (j = i + 1; j < size && this.isInternalMethod(stackTrace[j]); ++j) {
                }
                for (k = j - 1; k > i && stackTrace[k].getFileName() == null; --k) {
                }
                if (k > i && k < j - 1) {
                    ((Collection)result2).add(stackTrace[k]);
                }
                ((Collection)result2).add(stackTrace[j - 1]);
                i = j;
                continue;
            }
            ((Collection)result2).add(stackTrace[i]);
            ++i;
        }
        return result2;
    }

    private final boolean isInternalMethod(StackTraceElement $this$isInternalMethod) {
        return StringsKt.startsWith$default($this$isInternalMethod.getClassName(), "kotlinx.coroutines", false, 2, null);
    }

    public static final /* synthetic */ ConcurrentWeakMap access$getCallerInfoCache$p() {
        return callerInfoCache;
    }

    public static final /* synthetic */ boolean access$isFinished(DebugProbesImpl $this, CoroutineOwner $receiver) {
        return $this.isFinished($receiver);
    }

    static {
        capturedCoroutinesMap = new ConcurrentWeakMap(false, 1, null);
        sanitizeStackTraces = true;
        enableCreationStackTraces = true;
        ignoreCoroutinesWithEmptyContext = true;
        dynamicAttach = INSTANCE.getDynamicAttach();
        callerInfoCache = new ConcurrentWeakMap(true);
        installations$kotlinx$VolatileWrapper = new Installations.kotlinx.VolatileWrapper(null);
        sequenceNumber$kotlinx$VolatileWrapper = new SequenceNumber.kotlinx.VolatileWrapper(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001d\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lkotlinx/coroutines/debug/internal/DebugProbesImpl$CoroutineOwner;", "T", "Lkotlin/coroutines/Continuation;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "delegate", "info", "Lkotlinx/coroutines/debug/internal/DebugCoroutineInfoImpl;", "(Lkotlin/coroutines/Continuation;Lkotlinx/coroutines/debug/internal/DebugCoroutineInfoImpl;)V", "callerFrame", "getCallerFrame", "()Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "context", "Lkotlin/coroutines/CoroutineContext;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "frame", "Lkotlinx/coroutines/debug/internal/StackTraceFrame;", "getFrame", "()Lkotlinx/coroutines/debug/internal/StackTraceFrame;", "getStackTraceElement", "Ljava/lang/StackTraceElement;", "resumeWith", "", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)V", "toString", "", "kotlinx-coroutines-core"})
    public static final class CoroutineOwner<T>
    implements Continuation<T>,
    CoroutineStackFrame {
        @JvmField
        @NotNull
        public final Continuation<T> delegate;
        @JvmField
        @NotNull
        public final DebugCoroutineInfoImpl info;

        public CoroutineOwner(@NotNull Continuation<? super T> delegate, @NotNull DebugCoroutineInfoImpl info) {
            this.delegate = delegate;
            this.info = info;
        }

        @Override
        @NotNull
        public CoroutineContext getContext() {
            return this.delegate.getContext();
        }

        private final StackTraceFrame getFrame() {
            return this.info.getCreationStackBottom$kotlinx_coroutines_core();
        }

        @Override
        @Nullable
        public CoroutineStackFrame getCallerFrame() {
            StackTraceFrame stackTraceFrame = this.getFrame();
            return stackTraceFrame != null ? stackTraceFrame.getCallerFrame() : null;
        }

        @Override
        @Nullable
        public StackTraceElement getStackTraceElement() {
            StackTraceFrame stackTraceFrame = this.getFrame();
            return stackTraceFrame != null ? stackTraceFrame.getStackTraceElement() : null;
        }

        @Override
        public void resumeWith(@NotNull Object result2) {
            INSTANCE.probeCoroutineCompleted(this);
            this.delegate.resumeWith(result2);
        }

        @NotNull
        public String toString() {
            return this.delegate.toString();
        }
    }
}

