/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.nbt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.nbt.AbstractBinaryTag;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"CompoundBinaryTag[length=\" + this.tags.size() + \"]\"", childrenArray="this.tags.entrySet().toArray()", hasChildren="!this.tags.isEmpty()")
final class CompoundBinaryTagImpl
extends AbstractBinaryTag
implements CompoundBinaryTag {
    static final CompoundBinaryTag EMPTY = new CompoundBinaryTagImpl(Collections.emptyMap());
    private final Map<String, BinaryTag> tags;
    private final int hashCode;

    CompoundBinaryTagImpl(Map<String, BinaryTag> tags) {
        this.tags = Collections.unmodifiableMap(tags);
        this.hashCode = tags.hashCode();
    }

    public boolean contains(@NotNull String key2, @NotNull BinaryTagType<?> type) {
        @Nullable BinaryTag tag = this.tags.get(key2);
        return tag != null && type.test(tag.type());
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.tags.keySet());
    }

    @Override
    @Nullable
    public BinaryTag get(String key2) {
        return this.tags.get(key2);
    }

    @Override
    @NotNull
    public CompoundBinaryTag put(@NotNull String key2, @NotNull BinaryTag tag) {
        return this.edit(map2 -> map2.put(key2, tag));
    }

    @Override
    @NotNull
    public CompoundBinaryTag put(@NotNull CompoundBinaryTag tag) {
        return this.edit(map2 -> {
            for (String key2 : tag.keySet()) {
                map2.put(key2, tag.get(key2));
            }
        });
    }

    @Override
    @NotNull
    public CompoundBinaryTag put(@NotNull Map<String, ? extends BinaryTag> tags) {
        return this.edit(map2 -> map2.putAll(tags));
    }

    @Override
    @NotNull
    public CompoundBinaryTag remove(@NotNull String key2, @Nullable Consumer<? super BinaryTag> removed) {
        if (!this.tags.containsKey(key2)) {
            return this;
        }
        return this.edit(map2 -> {
            BinaryTag tag = (BinaryTag)map2.remove(key2);
            if (removed != null) {
                removed.accept(tag);
            }
        });
    }

    @Override
    public byte getByte(@NotNull String key2, byte defaultValue) {
        if (this.contains(key2, BinaryTagTypes.BYTE)) {
            return ((NumberBinaryTag)this.tags.get(key2)).byteValue();
        }
        return defaultValue;
    }

    @Override
    public short getShort(@NotNull String key2, short defaultValue) {
        if (this.contains(key2, BinaryTagTypes.SHORT)) {
            return ((NumberBinaryTag)this.tags.get(key2)).shortValue();
        }
        return defaultValue;
    }

    @Override
    public int getInt(@NotNull String key2, int defaultValue) {
        if (this.contains(key2, BinaryTagTypes.INT)) {
            return ((NumberBinaryTag)this.tags.get(key2)).intValue();
        }
        return defaultValue;
    }

    @Override
    public long getLong(@NotNull String key2, long defaultValue) {
        if (this.contains(key2, BinaryTagTypes.LONG)) {
            return ((NumberBinaryTag)this.tags.get(key2)).longValue();
        }
        return defaultValue;
    }

    @Override
    public float getFloat(@NotNull String key2, float defaultValue) {
        if (this.contains(key2, BinaryTagTypes.FLOAT)) {
            return ((NumberBinaryTag)this.tags.get(key2)).floatValue();
        }
        return defaultValue;
    }

    @Override
    public double getDouble(@NotNull String key2, double defaultValue) {
        if (this.contains(key2, BinaryTagTypes.DOUBLE)) {
            return ((NumberBinaryTag)this.tags.get(key2)).doubleValue();
        }
        return defaultValue;
    }

    @Override
    public byte @NotNull [] getByteArray(@NotNull String key2) {
        if (this.contains(key2, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key2)).value();
        }
        return new byte[0];
    }

    @Override
    public byte @NotNull [] getByteArray(@NotNull String key2, byte @NotNull [] defaultValue) {
        if (this.contains(key2, BinaryTagTypes.BYTE_ARRAY)) {
            return ((ByteArrayBinaryTag)this.tags.get(key2)).value();
        }
        return defaultValue;
    }

    @Override
    @NotNull
    public String getString(@NotNull String key2, @NotNull String defaultValue) {
        if (this.contains(key2, BinaryTagTypes.STRING)) {
            return ((StringBinaryTag)this.tags.get(key2)).value();
        }
        return defaultValue;
    }

    @Override
    @NotNull
    public ListBinaryTag getList(@NotNull String key2, @NotNull ListBinaryTag defaultValue) {
        if (this.contains(key2, BinaryTagTypes.LIST)) {
            return (ListBinaryTag)this.tags.get(key2);
        }
        return defaultValue;
    }

    @Override
    @NotNull
    public ListBinaryTag getList(@NotNull String key2, @NotNull BinaryTagType<? extends BinaryTag> expectedType, @NotNull ListBinaryTag defaultValue) {
        ListBinaryTag tag;
        if (this.contains(key2, BinaryTagTypes.LIST) && expectedType.test((tag = (ListBinaryTag)this.tags.get(key2)).elementType())) {
            return tag;
        }
        return defaultValue;
    }

    @Override
    @NotNull
    public CompoundBinaryTag getCompound(@NotNull String key2, @NotNull CompoundBinaryTag defaultValue) {
        if (this.contains(key2, BinaryTagTypes.COMPOUND)) {
            return (CompoundBinaryTag)this.tags.get(key2);
        }
        return defaultValue;
    }

    @Override
    public int @NotNull [] getIntArray(@NotNull String key2) {
        if (this.contains(key2, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key2)).value();
        }
        return new int[0];
    }

    @Override
    public int @NotNull [] getIntArray(@NotNull String key2, int @NotNull [] defaultValue) {
        if (this.contains(key2, BinaryTagTypes.INT_ARRAY)) {
            return ((IntArrayBinaryTag)this.tags.get(key2)).value();
        }
        return defaultValue;
    }

    @Override
    public long @NotNull [] getLongArray(@NotNull String key2) {
        if (this.contains(key2, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key2)).value();
        }
        return new long[0];
    }

    @Override
    public long @NotNull [] getLongArray(@NotNull String key2, long @NotNull [] defaultValue) {
        if (this.contains(key2, BinaryTagTypes.LONG_ARRAY)) {
            return ((LongArrayBinaryTag)this.tags.get(key2)).value();
        }
        return defaultValue;
    }

    private CompoundBinaryTag edit(Consumer<Map<String, BinaryTag>> consumer) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(this.tags);
        consumer.accept(tags);
        return new CompoundBinaryTagImpl(tags);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof CompoundBinaryTagImpl && this.tags.equals(((CompoundBinaryTagImpl)that).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, ? extends BinaryTag>> iterator() {
        return this.tags.entrySet().iterator();
    }

    @Override
    public void forEach(@NotNull Consumer<? super Map.Entry<String, ? extends BinaryTag>> action) {
        this.tags.entrySet().forEach(Objects.requireNonNull(action, "action"));
    }
}

