/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.internal.Internals;
import net.kyori.adventure.text.AbstractComponent;
import net.kyori.adventure.text.AbstractComponentBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TranslatableComponentImpl
extends AbstractComponent
implements TranslatableComponent {
    private final String key;
    @Nullable
    private final String fallback;
    private final List<Component> args;

    static TranslatableComponent create(@NotNull List<Component> children2, @NotNull Style style, @NotNull String key2, @Nullable String fallback, @NotNull @NotNull ComponentLike @NotNull [] args2) {
        Objects.requireNonNull(args2, "args");
        return TranslatableComponentImpl.create(children2, style, key2, fallback, Arrays.asList(args2));
    }

    static TranslatableComponent create(@NotNull List<? extends ComponentLike> children2, @NotNull Style style, @NotNull String key2, @Nullable String fallback, @NotNull List<? extends ComponentLike> args2) {
        return new TranslatableComponentImpl(ComponentLike.asComponents(children2, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(key2, "key"), fallback, ComponentLike.asComponents(args2));
    }

    TranslatableComponentImpl(@NotNull List<Component> children2, @NotNull Style style, @NotNull String key2, @Nullable String fallback, @NotNull List<Component> args2) {
        super(children2, style);
        this.key = key2;
        this.fallback = fallback;
        this.args = args2;
    }

    @Override
    @NotNull
    public String key() {
        return this.key;
    }

    @Override
    @NotNull
    public TranslatableComponent key(@NotNull String key2) {
        if (Objects.equals(this.key, key2)) {
            return this;
        }
        return TranslatableComponentImpl.create(this.children, this.style, key2, this.fallback, this.args);
    }

    @Override
    @NotNull
    public List<Component> args() {
        return this.args;
    }

    @Override
    @NotNull
    public TranslatableComponent args(ComponentLike ... args2) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, args2);
    }

    @Override
    @NotNull
    public TranslatableComponent args(@NotNull List<? extends ComponentLike> args2) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, args2);
    }

    @Override
    @Nullable
    public String fallback() {
        return this.fallback;
    }

    @Override
    @NotNull
    public TranslatableComponent fallback(@Nullable String fallback) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, fallback, this.args);
    }

    @Override
    @NotNull
    public TranslatableComponent children(@NotNull List<? extends ComponentLike> children2) {
        return TranslatableComponentImpl.create(children2, this.style, this.key, this.fallback, this.args);
    }

    @Override
    @NotNull
    public TranslatableComponent style(@NotNull Style style) {
        return TranslatableComponentImpl.create(this.children, style, this.key, this.fallback, this.args);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TranslatableComponent that = (TranslatableComponent)other;
        return Objects.equals(this.key, that.key()) && Objects.equals(this.fallback, that.fallback()) && Objects.equals(this.args, that.args());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.key.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.fallback);
        result2 = 31 * result2 + this.args.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public TranslatableComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TranslatableComponent, TranslatableComponent.Builder>
    implements TranslatableComponent.Builder {
        @Nullable
        private String key;
        @Nullable
        private String fallback;
        private List<? extends Component> args = Collections.emptyList();

        BuilderImpl() {
        }

        BuilderImpl(@NotNull TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.args();
            this.fallback = component.fallback();
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder key(@NotNull String key2) {
            this.key = key2;
            return this;
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder args(@NotNull ComponentBuilder<?, ?> arg) {
            return this.args(Collections.singletonList(Objects.requireNonNull(arg, "arg").build()));
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder args(ComponentBuilder<?, ?> ... args2) {
            Objects.requireNonNull(args2, "args");
            if (args2.length == 0) {
                return this.args(Collections.emptyList());
            }
            return this.args(Stream.of(args2).map(ComponentBuilder::build).collect(Collectors.toList()));
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder args(@NotNull Component arg) {
            return this.args(Collections.singletonList(Objects.requireNonNull(arg, "arg")));
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder args(ComponentLike ... args2) {
            Objects.requireNonNull(args2, "args");
            if (args2.length == 0) {
                return this.args(Collections.emptyList());
            }
            return this.args(Arrays.asList(args2));
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder args(@NotNull List<? extends ComponentLike> args2) {
            this.args = ComponentLike.asComponents(Objects.requireNonNull(args2, "args"));
            return this;
        }

        @Override
        @NotNull
        public TranslatableComponent.Builder fallback(@Nullable String fallback) {
            this.fallback = fallback;
            return this;
        }

        @Override
        @NotNull
        public TranslatableComponent build() {
            if (this.key == null) {
                throw new IllegalStateException("key must be set");
            }
            return TranslatableComponentImpl.create(this.children, this.buildStyle(), this.key, this.fallback, this.args);
        }
    }
}

