/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jetbrains.annotations.Nullable;

final class SelectorTag {
    private static final String SEL = "sel";
    private static final String SELECTOR = "selector";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("sel", "selector"), SelectorTag::create, SelectorTag::claim);

    private SelectorTag() {
    }

    static Tag create(ArgumentQueue args2, Context ctx) throws ParsingException {
        String key2 = args2.popOr("A selection key is required").value();
        Component separator = null;
        if (args2.hasNext()) {
            separator = ctx.deserialize(args2.pop().value());
        }
        return Tag.inserting(Component.selector(key2, separator));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof SelectorComponent)) {
            return null;
        }
        SelectorComponent st = (SelectorComponent)input;
        return emit2 -> {
            emit2.tag(SEL);
            emit2.argument(st.pattern());
            if (st.separator() != null) {
                emit2.argument(st.separator());
            }
        };
    }
}

