/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.annotation.Nonnull;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.JavassistHelper;

public class MemberUsageScanner
implements Scanner {
    private Predicate<String> resultFilter = s2 -> true;
    private final ClassLoader[] classLoaders;
    private volatile ClassPool classPool;

    public MemberUsageScanner() {
        this(ClasspathHelper.classLoaders(new ClassLoader[0]));
    }

    public MemberUsageScanner(@Nonnull ClassLoader[] classLoaders) {
        this.classLoaders = classLoaders;
    }

    @Override
    public List<Map.Entry<String, String>> scan(ClassFile classFile) {
        ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>();
        CtClass ctClass = null;
        try {
            ctClass = this.getClassPool().get(classFile.getName());
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember(ctConstructor, entries2);
            }
            for (CtBehavior ctBehavior : ctClass.getDeclaredMethods()) {
                this.scanMember(ctBehavior, entries2);
            }
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + classFile.getName(), e);
        }
        finally {
            if (ctClass != null) {
                ctClass.detach();
            }
        }
        return entries2;
    }

    public Scanner filterResultsBy(Predicate<String> filter2) {
        this.resultFilter = filter2;
        return this;
    }

    private void scanMember(CtBehavior member, final List<Map.Entry<String, String>> entries2) throws CannotCompileException {
        final String key2 = member.getDeclaringClass().getName() + "." + member.getMethodInfo().getName() + "(" + MemberUsageScanner.parameterNames(member.getMethodInfo()) + ")";
        member.instrument(new ExprEditor(){

            @Override
            public void edit(NewExpr e) {
                try {
                    MemberUsageScanner.this.add(entries2, e.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.parameterNames(e.getConstructor().getMethodInfo()) + ")", key2 + " #" + e.getLineNumber());
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key2, e1);
                }
            }

            @Override
            public void edit(MethodCall m4) {
                try {
                    MemberUsageScanner.this.add(entries2, m4.getMethod().getDeclaringClass().getName() + "." + m4.getMethodName() + "(" + MemberUsageScanner.parameterNames(m4.getMethod().getMethodInfo()) + ")", key2 + " #" + m4.getLineNumber());
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m4.getClassName() + " in " + key2, e);
                }
            }

            @Override
            public void edit(ConstructorCall c) {
                try {
                    MemberUsageScanner.this.add(entries2, c.getConstructor().getDeclaringClass().getName() + ".<init>(" + MemberUsageScanner.parameterNames(c.getConstructor().getMethodInfo()) + ")", key2 + " #" + c.getLineNumber());
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key2, e);
                }
            }

            @Override
            public void edit(FieldAccess f) {
                try {
                    MemberUsageScanner.this.add(entries2, f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), key2 + " #" + f.getLineNumber());
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key2, e);
                }
            }
        });
    }

    private void add(List<Map.Entry<String, String>> entries2, String key2, String value) {
        if (this.resultFilter.test(key2)) {
            entries2.add(this.entry(key2, value));
        }
    }

    public static String parameterNames(MethodInfo info) {
        return String.join((CharSequence)", ", JavassistHelper.getParameters(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getClassPool() {
        if (this.classPool == null) {
            MemberUsageScanner memberUsageScanner = this;
            synchronized (memberUsageScanner) {
                if (this.classPool == null) {
                    this.classPool = new ClassPool();
                    for (ClassLoader classLoader : this.classLoaders) {
                        this.classPool.appendClassPath(new LoaderClassPath(classLoader));
                    }
                }
            }
        }
        return this.classPool;
    }
}

