/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.bungee.listener;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.DefaultPlayerAddress;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import eu.thesimplecloud.plugin.proxy.CancelType;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.bungee.BungeeComponentExtensionsKt;
import eu.thesimplecloud.plugin.proxy.bungee.CloudBungeePlugin;
import eu.thesimplecloud.plugin.proxy.bungee.LobbyConnector;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\rH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u0010"}, d2={"Leu/thesimplecloud/plugin/proxy/bungee/listener/BungeeListener;", "Lnet/md_5/bungee/api/plugin/Listener;", "()V", "getNoFallbackServerFoundMessage", "", "isWaterFallCauseLostConnection", "", "event", "Lnet/md_5/bungee/api/event/ServerKickEvent;", "on", "", "Lnet/md_5/bungee/api/event/LoginEvent;", "Lnet/md_5/bungee/api/event/PlayerDisconnectEvent;", "Lnet/md_5/bungee/api/event/PostLoginEvent;", "Lnet/md_5/bungee/api/event/ServerConnectEvent;", "Lnet/md_5/bungee/api/event/ServerConnectedEvent;", "simplecloud-plugin"})
public final class BungeeListener
implements Listener {
    @EventHandler(priority=-32)
    public final void on(@NotNull LoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        PendingConnection connection = event.getConnection();
        String string = connection.getAddress().getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.address.hostString");
        DefaultPlayerAddress playerAddress = new DefaultPlayerAddress(string, connection.getAddress().getPort());
        String string2 = connection.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.name");
        UUID uUID = connection.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"connection.uniqueId");
        DefaultPlayerConnection playerConnection = new DefaultPlayerConnection(playerAddress, string2, uUID, connection.isOnlineMode(), connection.getVersion());
        ProxyEventHandler.INSTANCE.handleLogin(playerConnection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(event){
            final /* synthetic */ LoginEvent $event;
            {
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$event.setCancelled(true);
                BaseComponent[] baseComponentArray = new BaseComponent[1];
                TextComponent textComponent = Component.text((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(it)");
                baseComponentArray[0] = BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent);
                this.$event.setCancelReason(baseComponentArray);
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull PostLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        proxiedPlayer.setReconnectServer(null);
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = proxiedPlayer.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proxiedPlayer.name");
        ProxyEventHandler.INSTANCE.handlePostLogin(uUID, string);
        LobbyConnector lobbyConnector = CloudBungeePlugin.Companion.getInstance().getLobbyConnector();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer, (String)"proxiedPlayer");
        if (LobbyConnector.getLobbyServer$default(lobbyConnector, proxiedPlayer, null, 2, null) == null) {
            ProxiedPlayer proxiedPlayer2 = event.getPlayer();
            TextComponent textComponent = Component.text((String)this.getNoFallbackServerFoundMessage());
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(getNoFallbackServerFoundMessage())");
            proxiedPlayer2.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
            return;
        }
    }

    @EventHandler(priority=64)
    public final void on(@NotNull PlayerDisconnectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = proxiedPlayer.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proxiedPlayer.name");
        ProxyEventHandler.INSTANCE.handleDisconnect(uUID, string);
    }

    @EventHandler
    public final void on(@NotNull ServerConnectEvent event) {
        ServerInfo target;
        ServerInfo serverInfo;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        if (Intrinsics.areEqual((Object)event.getTarget().getName(), (Object)"fallback")) {
            LobbyConnector lobbyConnector = CloudBungeePlugin.Companion.getInstance().getLobbyConnector();
            Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer, (String)"proxiedPlayer");
            serverInfo = LobbyConnector.getLobbyServer$default(lobbyConnector, proxiedPlayer, null, 2, null);
        } else {
            serverInfo = target = event.getTarget();
        }
        if (target == null) {
            ProxiedPlayer proxiedPlayer2 = event.getPlayer();
            TextComponent textComponent = Component.text((String)this.getNoFallbackServerFoundMessage());
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(getNoFallbackServerFoundMessage())");
            proxiedPlayer2.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
            return;
        }
        event.setTarget(target);
        Server server = proxiedPlayer.getServer();
        String name = server != null && (server = server.getInfo()) != null ? server.getName() : null;
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name");
        ProxyEventHandler.INSTANCE.handleServerPreConnect(uUID, name, string, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(proxiedPlayer, event){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;
            final /* synthetic */ ServerConnectEvent $event;
            {
                this.$proxiedPlayer = $proxiedPlayer;
                this.$event = $event;
                super(2);
            }

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    TextComponent textComponent = Component.text((String)message);
                    Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(message)");
                    this.$proxiedPlayer.sendMessage(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
                } else {
                    TextComponent textComponent = Component.text((String)message);
                    Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(message)");
                    this.$proxiedPlayer.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
                }
                this.$event.setCancelled(true);
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull ServerConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        UUID uUID = proxiedPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"proxiedPlayer.uniqueId");
        String string = event.getServer().getInfo().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.server.info.name");
        ProxyEventHandler.INSTANCE.handleServerConnect(uUID, string, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(proxiedPlayer){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;
            {
                this.$proxiedPlayer = $proxiedPlayer;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TextComponent textComponent = Component.text((String)"\u00a7cService does not exist.");
                Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(\"\u00a7cService does not exist.\")");
                this.$proxiedPlayer.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
            }
        }));
    }

    @EventHandler
    public final void on(@NotNull ServerKickEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCancelled()) {
            return;
        }
        if (this.isWaterFallCauseLostConnection(event)) {
            return;
        }
        BaseComponent[] baseComponentArray = event.getKickReasonComponent();
        Intrinsics.checkNotNullExpressionValue((Object)baseComponentArray, (String)"event.kickReasonComponent");
        if (((Object[])baseComponentArray).length == 0) {
            string = "";
        } else {
            String string2 = event.getKickReasonComponent()[0].toLegacyText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            event.kick\u2026.toLegacyText()\n        }");
            string = string2;
        }
        String kickReasonString = string;
        ProxiedPlayer proxiedPlayer = event.getPlayer();
        String kickedServerName = event.getKickedFrom().getName();
        Intrinsics.checkNotNullExpressionValue((Object)proxiedPlayer, (String)"proxiedPlayer");
        ICloudPlayer iCloudPlayer = PlayerExtensionsKt.getCloudPlayer(proxiedPlayer);
        Intrinsics.checkNotNullExpressionValue((Object)kickedServerName, (String)"kickedServerName");
        ProxyEventHandler.INSTANCE.handleServerKick(iCloudPlayer, kickReasonString, kickedServerName, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(proxiedPlayer){
            final /* synthetic */ ProxiedPlayer $proxiedPlayer;
            {
                this.$proxiedPlayer = $proxiedPlayer;
                super(2);
            }

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    TextComponent textComponent = Component.text((String)message);
                    Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(message)");
                    this.$proxiedPlayer.sendMessage(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
                } else {
                    TextComponent textComponent = Component.text((String)message);
                    Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(message)");
                    this.$proxiedPlayer.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
                }
            }
        }));
        ServerInfo fallback = CloudBungeePlugin.Companion.getInstance().getLobbyConnector().getLobbyServer(proxiedPlayer, CollectionsKt.listOf((Object)kickedServerName));
        if (fallback == null) {
            TextComponent textComponent = Component.text((String)this.getNoFallbackServerFoundMessage());
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(getNoFallbackServerFoundMessage())");
            proxiedPlayer.disconnect(BungeeComponentExtensionsKt.toBaseComponent((Component)textComponent));
            return;
        }
        BaseComponent[] baseComponentArray2 = event.getKickReasonComponent();
        proxiedPlayer.sendMessage(Arrays.copyOf(baseComponentArray2, baseComponentArray2.length));
        event.setCancelServer(fallback);
        event.setCancelled(true);
    }

    private final boolean isWaterFallCauseLostConnection(ServerKickEvent event) {
        try {
            Method method = ServerKickEvent.class.getDeclaredMethod("getCause", new Class[0]);
            return Intrinsics.areEqual((Object)method.invoke((Object)event, new Object[0]).toString(), (Object)"LOST_CONNECTION");
        }
        catch (Exception e) {
            return false;
        }
    }

    private final String getNoFallbackServerFoundMessage() {
        return CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
    }
}

