/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.proxy.velocity.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.connection.DefaultPlayerAddress;
import eu.thesimplecloud.api.player.connection.DefaultPlayerConnection;
import eu.thesimplecloud.plugin.extension.PlayerExtensionsKt;
import eu.thesimplecloud.plugin.proxy.CancelType;
import eu.thesimplecloud.plugin.proxy.ProxyEventHandler;
import eu.thesimplecloud.plugin.proxy.velocity.CloudVelocityPlugin;
import eu.thesimplecloud.plugin.proxy.velocity.LobbyConnector;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Leu/thesimplecloud/plugin/proxy/velocity/listener/VelocityListener;", "", "plugin", "Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "(Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;)V", "getPlugin", "()Leu/thesimplecloud/plugin/proxy/velocity/CloudVelocityPlugin;", "getNoFallbackServerFoundMessage", "", "handle", "", "event", "Lcom/velocitypowered/api/event/connection/DisconnectEvent;", "Lcom/velocitypowered/api/event/connection/LoginEvent;", "Lcom/velocitypowered/api/event/connection/PostLoginEvent;", "Lcom/velocitypowered/api/event/player/KickedFromServerEvent;", "Lcom/velocitypowered/api/event/player/ServerConnectedEvent;", "Lcom/velocitypowered/api/event/player/ServerPreConnectEvent;", "simplecloud-plugin"})
public final class VelocityListener {
    @NotNull
    private final CloudVelocityPlugin plugin;

    public VelocityListener(@NotNull CloudVelocityPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final CloudVelocityPlugin getPlugin() {
        return this.plugin;
    }

    @Subscribe(order=PostOrder.FIRST)
    public final void handle(@NotNull LoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        String string = player.getRemoteAddress().getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.remoteAddress.hostString");
        DefaultPlayerAddress playerAddress = new DefaultPlayerAddress(string, player.getRemoteAddress().getPort());
        String string2 = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"player.username");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        DefaultPlayerConnection playerConnection = new DefaultPlayerConnection(playerAddress, string2, uUID, this.plugin.getProxyServer().getConfiguration().isOnlineMode(), player.getProtocolVersion().getProtocol());
        ProxyEventHandler.INSTANCE.handleLogin(playerConnection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(event){
            final /* synthetic */ LoginEvent $event;
            {
                this.$event = $event;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$event.setResult(ResultedEvent.ComponentResult.denied((Component)((Component)Component.text((String)it))));
            }
        }));
    }

    @Subscribe
    public final void handle(@NotNull PostLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.username");
        ProxyEventHandler.INSTANCE.handlePostLogin(uUID, string);
        LobbyConnector lobbyConnector = this.plugin.getLobbyConnector();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        if (LobbyConnector.getLobbyServer$default(lobbyConnector, player, null, 2, null) == null) {
            event.getPlayer().disconnect((Component)Component.text((String)this.getNoFallbackServerFoundMessage()));
        }
    }

    @Subscribe
    public final void handle(@NotNull DisconnectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = player.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.username");
        ProxyEventHandler.INSTANCE.handleDisconnect(uUID, string);
    }

    @Subscribe
    public final void handle(@NotNull ServerPreConnectEvent event) {
        RegisteredServer target;
        RegisteredServer registeredServer;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getResult().isAllowed()) {
            return;
        }
        Player player = event.getPlayer();
        if (Intrinsics.areEqual((Object)event.getOriginalServer().getServerInfo().getName(), (Object)"fallback")) {
            LobbyConnector lobbyConnector = this.plugin.getLobbyConnector();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
            registeredServer = LobbyConnector.getLobbyServer$default(lobbyConnector, player, null, 2, null);
        } else {
            registeredServer = target = event.getOriginalServer();
        }
        if (target == null) {
            event.getPlayer().disconnect((Component)Component.text((String)this.getNoFallbackServerFoundMessage()));
            return;
        }
        String serverNameTo = target.getServerInfo().getName();
        event.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)this.plugin.getProxyServer().getServer(serverNameTo).orElse(null)));
        String serverNameFrom = null;
        Optional currentServer = player.getCurrentServer();
        if (currentServer.isPresent()) {
            serverNameFrom = ((ServerConnection)currentServer.get()).getServerInfo().getName();
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        Intrinsics.checkNotNullExpressionValue((Object)serverNameTo, (String)"serverNameTo");
        ProxyEventHandler.INSTANCE.handleServerPreConnect(uUID, serverNameFrom, serverNameTo, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(player, event){
            final /* synthetic */ Player $player;
            final /* synthetic */ ServerPreConnectEvent $event;
            {
                this.$player = $player;
                this.$event = $event;
                super(2);
            }

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$player.sendMessage((Component)Component.text((String)message));
                } else {
                    this.$player.disconnect((Component)Component.text((String)message));
                }
                this.$event.setResult(ServerPreConnectEvent.ServerResult.denied());
            }
        }));
    }

    @Subscribe
    public final void handle(@NotNull ServerConnectedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        String string = event.getServer().getServerInfo().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.server.serverInfo.name");
        ProxyEventHandler.INSTANCE.handleServerConnect(uUID, string, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(player){
            final /* synthetic */ Player $player;
            {
                this.$player = $player;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$player.disconnect((Component)Component.text((String)"\u00a7cService does not exist."));
            }
        }));
    }

    @Subscribe
    public final void handle(@NotNull KickedFromServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String kickReasonString = null;
        Ref.ObjectRef kickReasonComponent = new Ref.ObjectRef();
        kickReasonComponent.element = event.getServerKickReason();
        if (!((Optional)kickReasonComponent.element).isPresent()) {
            kickReasonString = "";
            kickReasonComponent.element = Optional.of(Component.empty());
        } else {
            String string;
            Object t = ((Optional)kickReasonComponent.element).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"kickReasonComponent.get()");
            Component component = (Component)t;
            if (component instanceof TextComponent) {
                String string2 = ((TextComponent)component).content();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                compon\u2026t.content()\n            }");
                string = string2;
            } else {
                string = "\u00a7cYou were kicked from the server";
            }
            kickReasonString = string;
        }
        Player player = event.getPlayer();
        String kickedServerName = event.getServer().getServerInfo().getName();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        ICloudPlayer iCloudPlayer = PlayerExtensionsKt.getCloudPlayer(player);
        Intrinsics.checkNotNullExpressionValue((Object)kickedServerName, (String)"kickedServerName");
        ProxyEventHandler.INSTANCE.handleServerKick(iCloudPlayer, kickReasonString, kickedServerName, (Function2<? super String, ? super CancelType, Unit>)((Function2)new Function2<String, CancelType, Unit>(player, event, (Ref.ObjectRef<Optional<Component>>)kickReasonComponent){
            final /* synthetic */ Player $player;
            final /* synthetic */ KickedFromServerEvent $event;
            final /* synthetic */ Ref.ObjectRef<Optional<Component>> $kickReasonComponent;
            {
                this.$player = $player;
                this.$event = $event;
                this.$kickReasonComponent = $kickReasonComponent;
                super(2);
            }

            public final void invoke(@NotNull String message, @NotNull CancelType cancelMessageType) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)((Object)cancelMessageType), (String)"cancelMessageType");
                if (cancelMessageType == CancelType.MESSAGE) {
                    this.$player.sendMessage((Component)Component.text((String)message));
                } else {
                    this.$event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)((Component)((Optional)this.$kickReasonComponent.element).get())));
                }
            }
        }));
        RegisteredServer fallback = this.plugin.getLobbyConnector().getLobbyServer(player, CollectionsKt.listOf((Object)kickedServerName));
        if (fallback == null) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)((Component)Component.text((String)this.getNoFallbackServerFoundMessage()))));
            return;
        }
        event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)fallback));
    }

    private final String getNoFallbackServerFoundMessage() {
        return CloudAPI.Companion.getInstance().getLanguageManager().getMessage("ingame.no-fallback-server-found", new String[0]);
    }
}

