/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.server.listener;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.cachelist.ICacheList;
import eu.thesimplecloud.api.cachelist.value.ICacheValue;
import eu.thesimplecloud.api.event.player.CloudPlayerChatEvent;
import eu.thesimplecloud.api.eventapi.IEvent;
import eu.thesimplecloud.api.eventapi.IEventManager;
import eu.thesimplecloud.api.player.ICloudPlayer;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.wrapper.IWrapperInfo;
import eu.thesimplecloud.plugin.startup.CloudPlugin;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Leu/thesimplecloud/plugin/server/listener/SpigotListener;", "Lorg/bukkit/event/Listener;", "()V", "NOT_REGISTERED", "", "UNKNOWN_ADRESS", "handleAsyncChat", "", "event", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "on", "Lorg/bukkit/event/player/PlayerKickEvent;", "Lorg/bukkit/event/player/PlayerLoginEvent;", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerDisconnected", "player", "Lorg/bukkit/entity/Player;", "updateCurrentOnlineCountTo", "count", "", "simplecloud-plugin"})
@SourceDebugExtension(value={"SMAP\nSpigotListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpigotListener.kt\neu/thesimplecloud/plugin/server/listener/SpigotListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1747#2,3:101\n*S KotlinDebug\n*F\n+ 1 SpigotListener.kt\neu/thesimplecloud/plugin/server/listener/SpigotListener\n*L\n50#1:101,3\n*E\n"})
public final class SpigotListener
implements Listener {
    @NotNull
    private final String UNKNOWN_ADRESS;
    @NotNull
    private final String NOT_REGISTERED;

    public SpigotListener() {
        this.UNKNOWN_ADRESS = "\u00a7cYou are connected from an unknown address!";
        this.NOT_REGISTERED = "\u00a7cYou are not registered on the network!";
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void on(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Player player2 = player;
        String hostAddress = event.getRealAddress().getHostAddress();
        if (!Intrinsics.areEqual((Object)hostAddress, (Object)"127.0.0.1")) {
            boolean bl;
            block6: {
                void $this$any$iv;
                Iterable iterable = CloudAPI.Companion.getInstance().getWrapperManager().getAllCachedObjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IWrapperInfo it = (IWrapperInfo)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getHost(), (Object)hostAddress)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.UNKNOWN_ADRESS);
                return;
            }
        }
        ICloudPlayerManager iCloudPlayerManager = CloudAPI.Companion.getInstance().getCloudPlayerManager();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        if (iCloudPlayerManager.getCachedCloudPlayer(uUID) == null) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.NOT_REGISTERED);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void handleAsyncChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ICloudPlayerManager iCloudPlayerManager = CloudAPI.Companion.getInstance().getCloudPlayerManager();
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"event.player.uniqueId");
        ICloudPlayer iCloudPlayer = iCloudPlayerManager.getCachedCloudPlayer(uUID);
        if (iCloudPlayer == null) {
            return;
        }
        ICloudPlayer cloudPlayer = iCloudPlayer;
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.message");
        CloudPlayerChatEvent playerChatEvent = new CloudPlayerChatEvent(cloudPlayer, string, CloudPlugin.Companion.getInstance().thisService());
        IEventManager.DefaultImpls.call$default((IEventManager)CloudAPI.Companion.getInstance().getEventManager(), (IEvent)((IEvent)playerChatEvent), (boolean)false, (int)2, null);
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateCurrentOnlineCountTo(Bukkit.getOnlinePlayers().size());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void on(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onPlayerDisconnected(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void on(@NotNull PlayerKickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        this.onPlayerDisconnected(player);
    }

    private final void onPlayerDisconnected(Player player) {
        ICloudPlayerManager playerManager = CloudAPI.Companion.getInstance().getCloudPlayerManager();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        ICloudPlayer cloudPlayer = playerManager.getCachedCloudPlayer(uUID);
        if (cloudPlayer != null && !cloudPlayer.isUpdatesEnabled()) {
            ICacheList.DefaultImpls.delete$default((ICacheList)((ICacheList)playerManager), (ICacheValue)((ICacheValue)cloudPlayer), (boolean)false, (int)2, null);
        }
        this.updateCurrentOnlineCountTo(Bukkit.getOnlinePlayers().size() - 1);
    }

    private final void updateCurrentOnlineCountTo(int count) {
        ICloudService thisService = CloudPlugin.Companion.getInstance().thisService();
        thisService.setOnlineCount(count);
        thisService.update();
    }
}

