/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.plugin.startup;

import eu.thesimplecloud.api.CloudAPI;
import eu.thesimplecloud.api.client.NetworkComponentType;
import eu.thesimplecloud.api.external.ICloudModule;
import eu.thesimplecloud.api.player.ICloudPlayerManager;
import eu.thesimplecloud.api.service.ICloudService;
import eu.thesimplecloud.api.service.ServiceState;
import eu.thesimplecloud.client.packets.PacketOutCloudClientLogin;
import eu.thesimplecloud.clientserverapi.client.INettyClient;
import eu.thesimplecloud.clientserverapi.client.NettyClient;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import eu.thesimplecloud.jsonlib.JsonLib;
import eu.thesimplecloud.plugin.ICloudServicePlugin;
import eu.thesimplecloud.plugin.impl.CloudAPIImpl;
import eu.thesimplecloud.plugin.startup.ConnectionHandlerImpl;
import eu.thesimplecloud.plugin.startup.UsedMemoryUpdater;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0014@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Leu/thesimplecloud/plugin/startup/CloudPlugin;", "Leu/thesimplecloud/api/external/ICloudModule;", "cloudServicePlugin", "Leu/thesimplecloud/plugin/ICloudServicePlugin;", "(Leu/thesimplecloud/plugin/ICloudServicePlugin;)V", "getCloudServicePlugin", "()Leu/thesimplecloud/plugin/ICloudServicePlugin;", "<set-?>", "Leu/thesimplecloud/clientserverapi/client/INettyClient;", "communicationClient", "getCommunicationClient", "()Leu/thesimplecloud/clientserverapi/client/INettyClient;", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "connectionToManager", "getConnectionToManager", "()Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "nettyThread", "Ljava/lang/Thread;", "thisService", "Leu/thesimplecloud/api/service/ICloudService;", "", "thisServiceName", "getThisServiceName", "()Ljava/lang/String;", "getGroupName", "loadConfig", "", "onDisable", "", "onEnable", "updateThisService", "Companion", "simplecloud-plugin"})
public final class CloudPlugin
implements ICloudModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICloudServicePlugin cloudServicePlugin;
    @Nullable
    private volatile ICloudService thisService;
    private volatile INettyClient communicationClient;
    private volatile IConnection connectionToManager;
    private volatile String thisServiceName;
    @NotNull
    private volatile Thread nettyThread;
    private static CloudPlugin instance;

    public CloudPlugin(@NotNull ICloudServicePlugin cloudServicePlugin) {
        Intrinsics.checkNotNullParameter((Object)cloudServicePlugin, (String)"cloudServicePlugin");
        this.cloudServicePlugin = cloudServicePlugin;
        System.out.println((Object)"<---------- Starting SimpleCloud-Plugin ---------->");
        instance = this;
        if (!this.loadConfig()) {
            this.cloudServicePlugin.shutdown();
        }
        System.out.println((Object)("<---------- Service-Name: " + this.getThisServiceName() + " ---------->"));
        Object t = JvmClassMappingKt.getJavaClass(this.cloudServicePlugin.getCloudPlayerManagerClass()).newInstance();
        Intrinsics.checkNotNullExpressionValue(t, (String)"cloudServicePlugin.getCl\u2026lass().java.newInstance()");
        new CloudAPIImpl((ICloudPlayerManager)t);
        INettyClient iNettyClient = this.getCommunicationClient();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"this::class.java.classLoader");
        iNettyClient.setPacketSearchClassLoader(classLoader);
        String[] stringArray = new String[]{"eu.thesimplecloud.plugin.network.packets"};
        this.getCommunicationClient().addPacketsByPackage(stringArray);
        stringArray = new String[]{"eu.thesimplecloud.client.packets"};
        this.getCommunicationClient().addPacketsByPackage(stringArray);
        stringArray = new String[]{"eu.thesimplecloud.api.network.packets"};
        this.getCommunicationClient().addPacketsByPackage(stringArray);
        this.nettyThread = ThreadsKt.thread$default((boolean)true, (boolean)false, (ClassLoader)this.getClass().getClassLoader(), null, (int)0, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                System.out.println((Object)"<------Starting cloud client----------->");
                this.getCommunicationClient().start().then((Function1)new Function1<Unit, ICommunicationPromise<? extends Unit>>(){

                    @Nullable
                    public final ICommunicationPromise<Unit> invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        System.out.println((Object)"<-------- Connection is now set up -------->");
                        return this.getConnectionToManager().sendUnitQuery((IPacket)new PacketOutCloudClientLogin(NetworkComponentType.SERVICE, this.getThisServiceName()), 10000L).addFailureListener((Function1)1.INSTANCE);
                    }
                }).addFailureListener((Function1)2.INSTANCE).addFailureListener((Function1)3.INSTANCE);
            }
        }), (int)24, null);
        new UsedMemoryUpdater().startUpdater();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> CloudPlugin._init_$lambda$0(this)));
    }

    @NotNull
    public final ICloudServicePlugin getCloudServicePlugin() {
        return this.cloudServicePlugin;
    }

    @NotNull
    public final INettyClient getCommunicationClient() {
        INettyClient iNettyClient = this.communicationClient;
        if (iNettyClient != null) {
            return iNettyClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"communicationClient");
        return null;
    }

    @NotNull
    public final IConnection getConnectionToManager() {
        IConnection iConnection = this.connectionToManager;
        if (iConnection != null) {
            return iConnection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"connectionToManager");
        return null;
    }

    @NotNull
    public final String getThisServiceName() {
        String string = this.thisServiceName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"thisServiceName");
        return null;
    }

    private final boolean loadConfig() {
        JsonLib jsonLib = JsonLib.Companion.fromJsonFile$default((JsonLib.Companion)JsonLib.Companion, (File)new File("SIMPLE-CLOUD.json"), null, (int)2, null);
        if (jsonLib == null) {
            return false;
        }
        JsonLib jsonLib2 = jsonLib;
        String string = jsonLib2.getString("serviceName");
        if (string == null) {
            return false;
        }
        this.thisServiceName = string;
        String string2 = jsonLib2.getString("managerHost");
        if (string2 == null) {
            return false;
        }
        String host = string2;
        Integer n = jsonLib2.getInt("managerPort");
        if (n == null) {
            return false;
        }
        int port = n;
        this.communicationClient = (INettyClient)new NettyClient(host, port, (IConnectionHandler)new ConnectionHandlerImpl());
        this.connectionToManager = this.getCommunicationClient().getConnection();
        return true;
    }

    @NotNull
    public final synchronized ICloudService thisService() {
        if (this.thisService == null) {
            this.thisService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(this.getThisServiceName());
        }
        while (true) {
            if (this.thisService != null) {
                ICloudService iCloudService = this.thisService;
                Intrinsics.checkNotNull((Object)iCloudService);
                if (iCloudService.isAuthenticated()) break;
            }
            Thread.sleep(10L);
            if (this.thisService != null) continue;
            this.thisService = CloudAPI.Companion.getInstance().getCloudServiceManager().getCloudServiceByName(this.getThisServiceName());
        }
        ICloudService iCloudService = this.thisService;
        Intrinsics.checkNotNull((Object)iCloudService);
        return iCloudService;
    }

    public void onEnable() {
        if (this.thisService().getServiceGroup().isStateUpdatingEnabled() && this.thisService().getState() == ServiceState.STARTING) {
            this.thisService().setState(ServiceState.VISIBLE);
            this.cloudServicePlugin.onBeforeFirstUpdate();
            this.updateThisService();
        }
    }

    public void onDisable() {
    }

    public final synchronized void updateThisService() {
        this.thisService().update();
    }

    @NotNull
    public final String getGroupName() {
        CharSequence charSequence = this.getThisServiceName();
        Regex regex = new Regex("-");
        int n = 0;
        List array = regex.split(charSequence, n);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)array, (int)1), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean isReloadable() {
        return ICloudModule.DefaultImpls.isReloadable((ICloudModule)this);
    }

    private static final void _init_$lambda$0(CloudPlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.getCommunicationClient().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final CloudPlugin getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Leu/thesimplecloud/plugin/startup/CloudPlugin$Companion;", "", "()V", "<set-?>", "Leu/thesimplecloud/plugin/startup/CloudPlugin;", "instance", "getInstance$annotations", "getInstance", "()Leu/thesimplecloud/plugin/startup/CloudPlugin;", "simplecloud-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudPlugin getInstance() {
            CloudPlugin cloudPlugin = instance;
            if (cloudPlugin != null) {
                return cloudPlugin;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

