/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.runner;

import eu.thesimplecloud.runner.RunnerClassLoader;
import eu.thesimplecloud.runner.dependency.AdvancedCloudDependency;
import eu.thesimplecloud.runner.dependency.DependencyLoaderStartup;
import eu.thesimplecloud.runner.utils.Downloader;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a#\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\b\u0010\u0011\u001a\u00020\tH\u0002\u001a\n\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001b\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0019\u0010\u0017\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"copiedDependencyLoaderFile", "Ljava/io/File;", "copiedLauncherFile", "copiedSimpleCloudPluginFile", "dependenciesDir", "lastStartedVersionFile", "downloadJarFromDependency", "", "artifactId", "", "file", "executeDependencyLoaderMain", "classLoader", "Ljava/net/URLClassLoader;", "args", "", "(Ljava/net/URLClassLoader;[Ljava/lang/String;)V", "getCloudVersion", "getLastStartedVersion", "initClassLoader", "loadedDependencies", "Ljava/net/URL;", "([Ljava/net/URL;)Ljava/net/URLClassLoader;", "main", "([Ljava/lang/String;)V", "simplecloud-runner"})
@SourceDebugExtension(value={"SMAP\nRunnerClassLoaderInitMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunnerClassLoaderInitMain.kt\neu/thesimplecloud/runner/RunnerClassLoaderInitMainKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n37#3,2:118\n*S KotlinDebug\n*F\n+ 1 RunnerClassLoaderInitMain.kt\neu/thesimplecloud/runner/RunnerClassLoaderInitMainKt\n*L\n78#1:114\n78#1:115,3\n78#1:118,2\n*E\n"})
public final class RunnerClassLoaderInitMainKt {
    @NotNull
    private static final File copiedDependencyLoaderFile = new File("storage", "dependency-loader.jar");
    @NotNull
    private static final File copiedLauncherFile = new File("launcher.jar");
    @NotNull
    private static final File copiedSimpleCloudPluginFile = new File("storage/pluginJars", "SimpleCloud-Plugin-" + RunnerClassLoaderInitMainKt.getCloudVersion() + ".jar");
    @NotNull
    private static final File lastStartedVersionFile = new File("storage/versions", "lastStartedVersion.json");
    @NotNull
    private static final File dependenciesDir = new File("dependencies/");

    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String version = RunnerClassLoaderInitMainKt.getCloudVersion();
        String lastStartedVersion = RunnerClassLoaderInitMainKt.getLastStartedVersion();
        if (!Intrinsics.areEqual((Object)version, (Object)lastStartedVersion) && dependenciesDir.exists()) {
            System.out.println((Object)"Deleting dependencies directory...");
            FilesKt.deleteRecursively((File)dependenciesDir);
        }
        if (!StringsKt.contains$default((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null)) {
            if (!copiedDependencyLoaderFile.exists()) {
                RunnerClassLoaderInitMainKt.downloadJarFromDependency("simplecloud-dependency-loader", copiedDependencyLoaderFile);
            }
            if (!copiedSimpleCloudPluginFile.exists()) {
                new Downloader().userAgentDownload("https://repo.thesimplecloud.eu/artifactory/gradle-release-local/eu/thesimplecloud/simplecloud/simplecloud-plugin/" + version + "/simplecloud-plugin-" + version + "-all.jar", copiedSimpleCloudPluginFile);
            }
            if (!copiedLauncherFile.exists()) {
                new Downloader().userAgentDownload("https://repo.thesimplecloud.eu/artifactory/gradle-release-local/eu/thesimplecloud/simplecloud/simplecloud-launcher/" + version + "/simplecloud-launcher-" + version + "-all.jar", copiedLauncherFile);
            }
        }
        DependencyLoaderStartup dependencyLoaderStartup = new DependencyLoaderStartup();
        Set<File> loadedDependencyFiles = dependencyLoaderStartup.loadDependenciesToResolveDependencies();
        Iterable $this$map$iv = loadedDependencyFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] loadedDependencyUrls = thisCollection$iv.toArray(new URL[0]);
        URLClassLoader classLoader = RunnerClassLoaderInitMainKt.initClassLoader(loadedDependencyUrls);
        Thread.currentThread().setContextClassLoader(classLoader);
        RunnerClassLoaderInitMainKt.executeDependencyLoaderMain(classLoader, args);
    }

    private static final String getLastStartedVersion() {
        if (!lastStartedVersionFile.exists()) {
            return null;
        }
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        String lastStartedVersion = (String)CollectionsKt.first((List)FilesKt.readLines((File)lastStartedVersionFile, (Charset)charset));
        return StringsKt.replace$default((String)lastStartedVersion, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    private static final String getCloudVersion() {
        String string = RunnerClassLoader.class.getPackage().getImplementationVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RunnerClassLoader::class\u2026ge`.implementationVersion");
        return string;
    }

    private static final void downloadJarFromDependency(String artifactId, File file) {
        AdvancedCloudDependency dependency = new AdvancedCloudDependency("eu.thesimplecloud.simplecloud", artifactId, RunnerClassLoaderInitMainKt.getCloudVersion());
        dependency.download("https://repo.thesimplecloud.eu/artifactory/gradle-release-local/", file);
    }

    private static final void executeDependencyLoaderMain(URLClassLoader classLoader, String[] args) {
        Class<?> loadedClass = classLoader.loadClass("eu.thesimplecloud.loader.dependency.DependencyLoaderMainKt");
        Object[] objectArray = new Class[]{String[].class};
        Method method = loadedClass.getMethod("main", (Class<?>[])objectArray);
        objectArray = new Object[]{args};
        method.invoke(null, objectArray);
    }

    private static final URLClassLoader initClassLoader(URL[] loadedDependencies) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        URL uRL = copiedDependencyLoaderFile.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"copiedDependencyLoaderFile.toURI().toURL()");
        spreadBuilder.add((Object)uRL);
        spreadBuilder.addSpread((Object)loadedDependencies);
        return new RunnerClassLoader((URL[])spreadBuilder.toArray((Object[])new URL[spreadBuilder.size()]));
    }
}

