/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.runner.dependency;

import eu.thesimplecloud.runner.dependency.CloudDependency;
import eu.thesimplecloud.runner.utils.Downloader;
import eu.thesimplecloud.runner.utils.WebContentLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u001c"}, d2={"Leu/thesimplecloud/runner/dependency/AdvancedCloudDependency;", "Leu/thesimplecloud/runner/dependency/CloudDependency;", "groupId", "", "artifactId", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "download", "", "repoUrl", "downloadFile", "Ljava/io/File;", "existInRepo", "", "getDependencyWithNewerVersion", "other", "getDownloadURL", "getDownloadedFile", "getDownloadedInfoFile", "getMainURL", "getUrlWithoutExtension", "getVersionStringAsIntArray", "", "", "(Ljava/lang/String;)[Ljava/lang/Integer;", "parseVersionPart", "part", "Companion", "simplecloud-runner"})
public final class AdvancedCloudDependency
extends CloudDependency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final File DEPENDENCIES_DIR = new File("dependencies/");
    @NotNull
    private static final File DEPENDENCY_INFO_DIR = new File("dependencies/info/");

    public AdvancedCloudDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(groupId, artifactId, version);
    }

    @NotNull
    public final String getDownloadURL(@NotNull String repoUrl) {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        return this.getUrlWithoutExtension(repoUrl) + ".jar";
    }

    @NotNull
    public final File getDownloadedFile() {
        return new File(DEPENDENCIES_DIR, this.getName() + ".jar");
    }

    @NotNull
    public final File getDownloadedInfoFile() {
        return new File(DEPENDENCY_INFO_DIR, this.getName() + ".info");
    }

    public final boolean existInRepo(@NotNull String repoUrl) {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        return new WebContentLoader().loadContent(this.getDownloadURL(repoUrl)) != null;
    }

    public final void download(@NotNull String repoUrl) throws IOException {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        this.download(repoUrl, this.getDownloadedFile());
    }

    public final void download(@NotNull String repoUrl, @NotNull File downloadFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        Intrinsics.checkNotNullParameter((Object)downloadFile, (String)"downloadFile");
        new Downloader().userAgentDownload(this.getDownloadURL(repoUrl), downloadFile);
    }

    private final String getMainURL(String repoUrl) {
        CharSequence charSequence = this.getGroupId();
        Regex regex = new Regex("\\.");
        String string = "/";
        return repoUrl + regex.replace(charSequence, string) + '/' + this.getArtifactId() + '/';
    }

    @NotNull
    public final String getUrlWithoutExtension(@NotNull String repoUrl) {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        return this.getMainURL(repoUrl) + this.getVersion() + '/' + this.getArtifactId() + '-' + this.getVersion();
    }

    @NotNull
    public final AdvancedCloudDependency getDependencyWithNewerVersion(@NotNull AdvancedCloudDependency other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Integer[] dependencyVersion = this.getVersionStringAsIntArray(this.getVersion());
        Integer[] otherDependencyVersion = this.getVersionStringAsIntArray(other.getVersion());
        if (dependencyVersion[0] > otherDependencyVersion[0]) {
            return this;
        }
        if (otherDependencyVersion[0] > dependencyVersion[0]) {
            return other;
        }
        if (dependencyVersion[1] > otherDependencyVersion[1]) {
            return this;
        }
        if (otherDependencyVersion[1] > dependencyVersion[1]) {
            return other;
        }
        if (dependencyVersion[2] > otherDependencyVersion[2]) {
            return this;
        }
        if (otherDependencyVersion[2] > dependencyVersion[2]) {
            return other;
        }
        return this;
    }

    private final Integer[] getVersionStringAsIntArray(String version) {
        String[] stringArray = new String[]{"."};
        List versionParts = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int major = Integer.parseInt((String)versionParts.get(0));
        int minor = this.parseVersionPart((String)CollectionsKt.getOrNull((List)versionParts, (int)1));
        int patch = this.parseVersionPart((String)CollectionsKt.getOrNull((List)versionParts, (int)2));
        Integer[] integerArray = new Integer[]{major, minor, patch};
        return integerArray;
    }

    private final int parseVersionPart(String part) {
        if (part == null) {
            return 0;
        }
        char[] cArray = part.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] charArray = cArray;
        List numbers = new ArrayList();
        for (char c : charArray) {
            if (!Character.isDigit(c)) break;
            numbers.add(Integer.valueOf(c));
        }
        if (numbers.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(CollectionsKt.joinToString$default((Iterable)numbers, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Leu/thesimplecloud/runner/dependency/AdvancedCloudDependency$Companion;", "", "()V", "DEPENDENCIES_DIR", "Ljava/io/File;", "getDEPENDENCIES_DIR", "()Ljava/io/File;", "DEPENDENCY_INFO_DIR", "getDEPENDENCY_INFO_DIR", "fromCoords", "Leu/thesimplecloud/runner/dependency/AdvancedCloudDependency;", "coords", "", "simplecloud-runner"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getDEPENDENCIES_DIR() {
            return DEPENDENCIES_DIR;
        }

        @NotNull
        public final File getDEPENDENCY_INFO_DIR() {
            return DEPENDENCY_INFO_DIR;
        }

        @NotNull
        public final AdvancedCloudDependency fromCoords(@NotNull String coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            String[] stringArray = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)coords, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (!(split.size() == 3)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new AdvancedCloudDependency((String)split.get(0), (String)split.get(1), (String)split.get(2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

